/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgBndConstraint;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnFunction;
import jvx.numeric.PnJacobi;
import jvx.numeric.PnMatrix;
import jvx.numeric.PnStiffMatrix;

public abstract class PnEnergy
extends PnFunction {
    protected PgElementSet m_domain;
    protected PgElementSet m_surface;
    protected int m_nop;
    protected int m_noiv;
    protected int m_dim;
    protected PnStiffMatrix m_stiffMatrix;
    protected PgBndPolygon[] m_bndList;
    protected PdVector m_store;
    private PdVector m_vertexGrad = new PdVector();
    protected boolean m_bTangential;
    protected boolean m_bNormal;
    protected int[] m_index;
    protected int[] m_invIndex;
    protected boolean m_zeroGradient = true;
    private static /* synthetic */ Class class$jvx$numeric$PnEnergy;

    public void testEigenvalues() {
        PdMatrix pdMatrix = this.evalHessian(null);
        PsDebug.message((String)("Hessian Q \n" + pdMatrix.toString()));
        PdMatrix pdMatrix2 = this.m_surface.getL2Matrix(null);
        PsDebug.message((String)"L2-Matrix");
        PsDebug.message((String)pdMatrix2.toString());
        PdMatrix pdMatrix3 = new PdMatrix(this.m_noiv);
        int n = 0;
        while (n < this.m_noiv) {
            int n2 = 0;
            while (n2 < this.m_noiv) {
                pdMatrix3.m_data[n][n2] = pdMatrix2.m_data[this.m_index[n]][this.m_index[n2]];
                ++n2;
            }
            ++n;
        }
        PsDebug.message((String)("S\n" + pdMatrix3.toString()));
        PdMatrix pdMatrix4 = new PdMatrix(this.m_noiv);
        PnMatrix.invert(pdMatrix4.m_data, pdMatrix3.m_data, this.m_noiv);
        PdMatrix pdMatrix5 = new PdMatrix(this.m_noiv);
        pdMatrix5.copy(pdMatrix4);
        pdMatrix5.rightMult(pdMatrix3);
        PsDebug.message((String)("SInv*S\n" + pdMatrix5.toString()));
        PdMatrix pdMatrix6 = PdMatrix.expandComponents((PdMatrix)pdMatrix3, (int)this.m_dim);
        PsDebug.message((String)("sBig\n" + pdMatrix6.toString()));
        PdMatrix pdMatrix7 = new PdMatrix(this.m_dim * this.m_noiv);
        PnMatrix.invert(pdMatrix7.m_data, pdMatrix6.m_data, this.m_dim * this.m_noiv);
        PsDebug.message((String)("sInvBig\n" + pdMatrix7.toString()));
        pdMatrix7.rightMult(pdMatrix);
        PsDebug.message((String)("SInvBig*Q\n" + pdMatrix7.toString()));
        PdVector pdVector = new PdVector(this.m_noiv);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)this.m_noiv, (int)this.m_noiv);
        PnJacobi.computeEigenvectors(pdMatrix3, this.m_noiv, pdVector, pdVectorArray);
        n = 0;
        while (n < this.m_noiv) {
            pdVectorArray[n].multScalar(1.0 / Math.sqrt(pdVector.m_data[n]));
            ++n;
        }
        PdMatrix pdMatrix8 = new PdMatrix(this.m_noiv);
        pdMatrix8.setColumns(pdVectorArray);
        PsDebug.message((String)("m\n" + pdMatrix8.toString()));
        PdMatrix pdMatrix9 = new PdMatrix(this.m_noiv);
        PnMatrix.invert(pdMatrix9.m_data, pdMatrix8.m_data, this.m_noiv);
        PdMatrix pdMatrix10 = new PdMatrix(this.m_noiv);
        pdMatrix10.mult(pdMatrix9, pdMatrix4);
        PdMatrix pdMatrix11 = PdMatrix.expandComponents((PdMatrix)pdMatrix10, (int)this.m_dim);
        PdMatrix pdMatrix12 = PdMatrix.expandComponents((PdMatrix)pdMatrix8, (int)this.m_dim);
        PdMatrix pdMatrix13 = new PdMatrix(this.m_dim * this.m_noiv);
        pdMatrix13.mult(pdMatrix11, pdMatrix);
        PdMatrix pdMatrix14 = new PdMatrix(this.m_dim * this.m_noiv);
        pdMatrix14.mult(pdMatrix13, pdMatrix12);
        PsDebug.message((String)("mInv*SInv*Q*mBig\n" + pdMatrix14.toString()));
        pdVector = new PdVector(this.m_dim * this.m_noiv);
        pdVectorArray = PdVector.realloc(null, (int)(this.m_dim * this.m_noiv), (int)(this.m_dim * this.m_noiv));
        PnJacobi.computeEigenvectors(pdMatrix14, this.m_dim * this.m_noiv, pdVector, pdVectorArray);
        n = 0;
        while (n < this.m_dim * this.m_noiv) {
            pdVectorArray[n].leftMultMatrix(pdMatrix12);
            pdVectorArray[n].normalize();
            ++n;
        }
        PsDebug.message((String)"Eigenvalues of operator sInv*Q after all transformations");
        PnJacobi.printEigenvectors(this.m_dim * this.m_noiv, pdVector, pdVectorArray);
    }

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        this.m_domain = pgElementSet;
        this.m_surface = pgElementSet2;
        int n = 0;
        int n2 = 0;
        this.m_dim = pgElementSet2.getDimOfVertices();
        this.m_nop = pgElementSet2.getNumVertices();
        this.m_bndList = pgElementSet2.getBoundaries();
        PdVector[] pdVectorArray = pgElementSet2.getVertices();
        this.m_store.setSize(this.m_dim * this.m_nop);
        this.m_vertexGrad.setSize(this.m_dim);
        pgElementSet2.markBoundary();
        int n3 = pgElementSet2.getNumBoundaryVertices();
        this.m_noiv = this.m_nop - n3;
        this.m_index = new int[this.m_noiv];
        this.m_invIndex = new int[this.m_nop];
        n2 = 0;
        n = 0;
        while (n < this.m_nop) {
            this.m_invIndex[n] = -1;
            if (!pdVectorArray[n].hasTag(13)) {
                this.m_invIndex[n] = n2;
                this.m_index[n2] = n;
                ++n2;
            }
            ++n;
        }
        if (this.m_noiv != n2) {
            PsDebug.warning((String)("error: m_noiv = " + this.m_noiv + " != " + n2 + " = ipos"));
            return false;
        }
        return true;
    }

    public void setZeroGradientAtBounds(boolean bl) {
        this.m_zeroGradient = bl;
    }

    public boolean getZeroGradientAtBounds() {
        return this.m_zeroGradient;
    }

    private void projectOntoPlane(double[] dArray, int n, PdVector pdVector) {
        int n2 = 0;
        while (n2 < this.m_dim) {
            this.m_vertexGrad.m_data[n2] = dArray[n + n2];
            ++n2;
        }
        PuVectorGeom.projectOntoPlane((PdVector)this.m_vertexGrad, (PdVector)pdVector);
        n2 = 0;
        while (n2 < this.m_dim) {
            dArray[n + n2] = this.m_vertexGrad.m_data[n2];
            ++n2;
        }
    }

    public PnEnergy() {
        this.m_store = new PdVector();
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnEnergy != null ? class$jvx$numeric$PnEnergy : (class$jvx$numeric$PnEnergy = PnEnergy.class$("jvx.numeric.PnEnergy")))) {
            this.init();
        }
    }

    public abstract PdMatrix evalHessian(PdMatrix var1);

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        int n;
        int n2;
        if (pdVector == null) {
            PsDebug.warning((String)"Missing coordinate array.");
            return null;
        }
        if (pdVector2 == null) {
            if (this.m_store == null || this.m_store.getSize() == 0 && pdVector.getSize() != 0) {
                PsDebug.warning((String)"PnEnergy not initialized, cannot evaluate gradient");
                return null;
            }
            pdVector2 = this.m_store;
        }
        pdVector2.setConstant(0.0);
        if (this.m_surface.getNumVertices() != this.m_nop) {
            return pdVector2;
        }
        int n3 = 0;
        while (n3 < this.m_nop) {
            int n4 = 0;
            while (n4 < this.m_stiffMatrix.m_snoe.m_data[n3]) {
                n2 = this.m_dim * this.m_stiffMatrix.m_sindx[n3].m_data[n4];
                n = 0;
                while (n < this.m_dim) {
                    int n5 = this.m_dim * n3 + n;
                    pdVector2.m_data[n5] = pdVector2.m_data[n5] + 2.0 * this.m_stiffMatrix.m_stiff[n3].m_data[n4] * pdVector.m_data[n2 + n];
                    ++n;
                }
                ++n4;
            }
            ++n3;
        }
        if (!(this.m_bTangential && this.m_bNormal || !this.m_surface.hasVertexNormals())) {
            PdVector[] pdVectorArray = this.m_surface.getVertexNormals();
            PdVector pdVector3 = new PdVector(this.m_dim);
            n2 = 0;
            n3 = 0;
            while (n3 < this.m_nop) {
                pdVector3.set(pdVector2, n2, this.m_dim);
                double d = PdVector.dot((PdVector)pdVector3, (PdVector)pdVectorArray[n3]);
                if (!this.m_bTangential) {
                    n = 0;
                    while (n < this.m_dim) {
                        pdVector2.m_data[n2 + n] = d * pdVectorArray[n3].m_data[n];
                        ++n;
                    }
                }
                if (!this.m_bNormal) {
                    n = 0;
                    while (n < this.m_dim) {
                        int n6 = n2 + n;
                        pdVector2.m_data[n6] = pdVector2.m_data[n6] - d * pdVectorArray[n3].m_data[n];
                        ++n;
                    }
                }
                n2 += this.m_dim;
                ++n3;
            }
        }
        if ((this.m_bndList == null || this.m_bndList.length == 0) && this.m_zeroGradient) {
            n3 = 0;
            while (n3 < this.m_nop) {
                if (this.m_invIndex[n3] == -1) {
                    n = 0;
                    while (n < this.m_dim) {
                        pdVector2.m_data[this.m_dim * n3 + n] = 0.0;
                        ++n;
                    }
                }
                ++n3;
            }
        } else {
            int n7 = 0;
            while (n7 < this.m_bndList.length) {
                if (!this.m_bndList[n7].hasTag(2)) {
                    PdVector pdVector4;
                    int n8 = this.m_bndList[n7].getNumVertices();
                    int[] nArray = this.m_bndList[n7].getVertexInd().m_data;
                    PgBndConstraint pgBndConstraint = this.m_bndList[n7].getBndConstraint();
                    if (pgBndConstraint == null) {
                        return pdVector2;
                    }
                    if (pgBndConstraint.hasShape(3)) {
                        n3 = 0;
                        while (n3 < n8) {
                            n2 = this.m_dim * nArray[n3];
                            n = 0;
                            while (n < this.m_dim) {
                                pdVector2.m_data[n2 + n] = 0.0;
                                ++n;
                            }
                            ++n3;
                        }
                    } else if (pgBndConstraint.hasShape(4)) {
                        pdVector4 = pgBndConstraint.m_dir;
                        n2 = this.m_dim * nArray[0];
                        n = 0;
                        while (n < this.m_dim) {
                            pdVector2.m_data[n2 + n] = 0.0;
                            ++n;
                        }
                        n2 = this.m_dim * nArray[n8 - 1];
                        n = 0;
                        while (n < this.m_dim) {
                            pdVector2.m_data[n2 + n] = 0.0;
                            ++n;
                        }
                        n3 = 1;
                        while (n3 < n8 - 1) {
                            this.projectOntoLine(pdVector2.m_data, this.m_dim * nArray[n3], pdVector4);
                            ++n3;
                        }
                    } else if (pgBndConstraint.hasShape(5)) {
                        pdVector4 = pgBndConstraint.m_dir;
                        PdVector pdVector5 = pgBndConstraint.m_startDir;
                        PdVector pdVector6 = pgBndConstraint.m_endDir;
                        if (pdVector5.sqrLength() > 1.0E-10) {
                            this.projectOntoLine(pdVector2.m_data, this.m_dim * nArray[0], pdVector5);
                        } else {
                            n2 = this.m_dim * nArray[0];
                            n = 0;
                            while (n < this.m_dim) {
                                pdVector2.m_data[n2 + n] = 0.0;
                                ++n;
                            }
                        }
                        if (pdVector6.sqrLength() > 1.0E-10) {
                            this.projectOntoLine(pdVector2.m_data, this.m_dim * nArray[n8 - 1], pdVector6);
                        } else {
                            n2 = this.m_dim * nArray[n8 - 1];
                            n = 0;
                            while (n < this.m_dim) {
                                pdVector2.m_data[n2 + n] = 0.0;
                                ++n;
                            }
                        }
                        n3 = 1;
                        while (n3 < n8 - 1) {
                            this.projectOntoPlane(pdVector2.m_data, this.m_dim * nArray[n3], pdVector4);
                            ++n3;
                        }
                    } else if (pgBndConstraint.hasShape(6)) {
                        n2 = this.m_dim * nArray[0];
                        n = 0;
                        while (n < this.m_dim) {
                            pdVector2.m_data[n2 + n] = 0.0;
                            ++n;
                        }
                        n2 = this.m_dim * nArray[n8 - 1];
                        n = 0;
                        while (n < this.m_dim) {
                            pdVector2.m_data[n2 + n] = 0.0;
                            ++n;
                        }
                        PsDebug.warning((String)"fixThread not implemented yet");
                    } else if (pgBndConstraint.hasShape(13)) {
                        n3 = 0;
                        while (n3 < n8) {
                            n2 = this.m_dim * nArray[n3];
                            n = 0;
                            while (n < this.m_dim) {
                                pdVector2.m_data[n2 + n] = 0.0;
                                ++n;
                            }
                            ++n3;
                        }
                    } else {
                        PsDebug.warning((String)"no boundary condition found");
                    }
                }
                ++n7;
            }
        }
        return pdVector2;
    }

    public PdVector[] getSpectrum(PdVector pdVector, PdVector[] pdVectorArray) {
        pdVector.setSize(this.m_dim * this.m_noiv);
        pdVectorArray = PdVector.realloc((PdVector[])pdVectorArray, (int)(this.m_dim * this.m_noiv), (int)(this.m_dim * this.m_noiv));
        PdMatrix pdMatrix = this.evalHessian(null);
        PdMatrix pdMatrix2 = this.m_surface.getL2Matrix(null);
        PdMatrix pdMatrix3 = new PdMatrix(this.m_noiv);
        int n = 0;
        while (n < this.m_noiv) {
            int n2 = 0;
            while (n2 < this.m_noiv) {
                pdMatrix3.m_data[n][n2] = pdMatrix2.m_data[this.m_index[n]][this.m_index[n2]];
                ++n2;
            }
            ++n;
        }
        PdMatrix pdMatrix4 = new PdMatrix(this.m_noiv);
        PnMatrix.invert(pdMatrix4.m_data, pdMatrix3.m_data, this.m_noiv);
        PdMatrix pdMatrix5 = PdMatrix.expandComponents((PdMatrix)pdMatrix4, (int)this.m_dim);
        pdMatrix5.rightMult(pdMatrix);
        PdVector pdVector2 = new PdVector(this.m_noiv);
        PdVector[] pdVectorArray2 = PdVector.realloc(null, (int)this.m_noiv, (int)this.m_noiv);
        PnJacobi.computeEigenvectors(pdMatrix3, this.m_noiv, pdVector2, pdVectorArray2);
        n = 0;
        while (n < this.m_noiv) {
            pdVectorArray2[n].multScalar(1.0 / Math.sqrt(pdVector2.m_data[n]));
            ++n;
        }
        PdMatrix pdMatrix6 = new PdMatrix(this.m_noiv);
        pdMatrix6.setColumns(pdVectorArray2);
        PdMatrix pdMatrix7 = new PdMatrix(this.m_noiv);
        PnMatrix.invert(pdMatrix7.m_data, pdMatrix6.m_data, this.m_noiv);
        PdMatrix pdMatrix8 = new PdMatrix(this.m_noiv);
        pdMatrix8.mult(pdMatrix7, pdMatrix4);
        PdMatrix pdMatrix9 = PdMatrix.expandComponents((PdMatrix)pdMatrix8, (int)this.m_dim);
        PdMatrix pdMatrix10 = PdMatrix.expandComponents((PdMatrix)pdMatrix6, (int)this.m_dim);
        PdMatrix pdMatrix11 = new PdMatrix(this.m_dim * this.m_noiv);
        pdMatrix11.mult(pdMatrix9, pdMatrix);
        PdMatrix pdMatrix12 = new PdMatrix(this.m_dim * this.m_noiv);
        pdMatrix12.mult(pdMatrix11, pdMatrix10);
        PnJacobi.computeEigenvectors(pdMatrix12, this.m_dim * this.m_noiv, pdVector, pdVectorArray);
        n = 0;
        while (n < this.m_dim * this.m_noiv) {
            pdVectorArray[n].leftMultMatrix(pdMatrix10);
            pdVectorArray[n].normalize();
            ++n;
        }
        return pdVectorArray;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getNumOfVariables() {
        return this.m_dim * this.m_noiv;
    }

    public void init() {
        super.init();
        this.m_bTangential = true;
        this.m_bNormal = true;
    }

    private void projectOntoLine(double[] dArray, int n, PdVector pdVector) {
        int n2 = 0;
        while (n2 < this.m_dim) {
            this.m_vertexGrad.m_data[n2] = dArray[n + n2];
            ++n2;
        }
        PuVectorGeom.projectOntoLine((PdVector)this.m_vertexGrad, (PdVector)pdVector);
        n2 = 0;
        while (n2 < this.m_dim) {
            dArray[n + n2] = this.m_vertexGrad.m_data[n2];
            ++n2;
        }
    }

    public double eval(PdVector pdVector) {
        int n;
        int n2;
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"missing m_stiffMatrix, call setSurface before.");
            return 0.0;
        }
        this.m_store.setConstant(0.0);
        int n3 = 0;
        while (n3 < this.m_nop) {
            int n4 = 0;
            while (n4 < this.m_stiffMatrix.m_snoe.m_data[n3]) {
                n2 = this.m_dim * this.m_stiffMatrix.m_sindx[n3].m_data[n4];
                n = 0;
                while (n < this.m_dim) {
                    int n5 = this.m_dim * n3 + n;
                    this.m_store.m_data[n5] = this.m_store.m_data[n5] + this.m_stiffMatrix.m_stiff[n3].m_data[n4] * pdVector.m_data[n2 + n];
                    ++n;
                }
                ++n4;
            }
            ++n3;
        }
        double d = 0.0;
        n3 = 0;
        while (n3 < this.m_nop) {
            if (this.m_stiffMatrix.m_snoe.m_data[n3] > 0) {
                n2 = this.m_dim * n3;
                n = 0;
                while (n < this.m_dim) {
                    d += this.m_store.m_data[n2 + n] * pdVector.m_data[n2 + n];
                    ++n;
                }
            }
            ++n3;
        }
        return d;
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"missing m_stiffMatrix, call setSurface before.");
            return;
        }
    }
}

