/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jvx.numeric.PnConjugateGradient;
import jvx.numeric.PnEnergy;
import jvx.numeric.PnJacobi;

public class PnEnergyMinimizer
extends PsObject
implements Runnable {
    public static final int DIRICHLET = 1;
    public static final int AREA = 2;
    public static final int CONFORMAL = 3;
    public static final int SPRING = 4;
    protected PgElementSet m_domain;
    protected PgElementSet m_surface;
    protected PgVectorField m_vf;
    protected PdMatrix m_hessian;
    protected boolean m_bUpdateNormals = false;
    protected boolean m_bUpdateDomain = true;
    protected PdVector m_coord;
    protected PnConjugateGradient m_cgMethod = new PnConjugateGradient();
    protected PnEnergy m_energy = null;
    protected int m_numLoops;
    protected int m_currLoop;
    protected double m_cgEps;
    protected double m_initialEnergy;
    protected double m_finalEnergy;
    protected int m_numIterations;
    protected Thread m_thread;
    protected PdVector[] m_eVector;
    protected PdVector m_eValue;
    protected int[] m_evSortInd;
    protected boolean m_bHessianIsL2Normalized = true;
    protected boolean m_bUseSteps = false;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;
    private static /* synthetic */ Class class$jvx$numeric$PnEnergyMinimizer;

    public void stop() {
        if (this.m_bRunning) {
            this.m_bRunning = false;
            this.m_thread = null;
            if (this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                this.m_infoPanel.update((Object)this);
            }
        }
        this.m_bUseSteps = false;
    }

    public void printEigenvalues() {
        if (this.m_eVector == null) {
            this.computeEigenvectors();
        }
        PnJacobi.printEigenvalues(this.m_eValue.getSize(), this.m_eValue);
    }

    public PgElementSet getSurface() {
        return this.m_surface;
    }

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet2 == null) {
            PsDebug.error((String)"missing surface", (Object)this);
            return false;
        }
        if (pgElementSet != null && pgElementSet.getNumElements() != pgElementSet2.getNumElements()) {
            pgElementSet.copy((PgGeometry)pgElementSet2);
        }
        PnEnergyMinimizer pnEnergyMinimizer = this;
        synchronized (pnEnergyMinimizer) {
            block11: {
                this.m_domain = pgElementSet;
                this.m_surface = pgElementSet2;
                if (!(!this.m_bUpdateNormals || this.m_energy != null && this.m_energy.m_bTangential && this.m_energy.m_bNormal)) {
                    pgElementSet2.makeVertexNormals();
                }
                this.m_vf = this.m_surface.getVectorField("Vector Field");
                if (this.m_vf != null) {
                    this.m_vf.setGeometry((PgPointSet)this.m_surface);
                }
                int n = this.m_surface.getDimOfVertices();
                int n2 = this.m_surface.getNumVertices();
                PdVector[] pdVectorArray = this.m_surface.getVertices();
                this.m_coord.setSize(n * n2);
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = 0;
                    while (n5 < n) {
                        this.m_coord.m_data[n3++] = pdVectorArray[n4].m_data[n5];
                        ++n5;
                    }
                    ++n4;
                }
                this.m_initialEnergy = Double.NaN;
                this.m_finalEnergy = Double.NaN;
                if (this.m_energy == null) break block11;
                if (!this.m_energy.setSurface(pgElementSet, pgElementSet2)) {
                    boolean bl = false;
                    Object var10_11 = null;
                    return bl;
                }
                this.m_initialEnergy = this.m_energy.eval(this.m_coord);
            }
            Object var10_12 = null;
        }
        if (this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
            this.m_infoPanel.update((Object)this);
        }
        return true;
    }

    private void minimizeStep() {
        this.m_eVector = null;
        this.m_eValue = null;
        if (this.m_surface == null) {
            PsDebug.warning((String)"missing elementSet");
            return;
        }
        PnEnergyMinimizer pnEnergyMinimizer = this;
        synchronized (pnEnergyMinimizer) {
            block9: {
                this.m_energy.initSurface(this.m_domain, this.m_surface);
                this.m_initialEnergy = this.m_energy.eval(this.m_coord);
                this.m_finalEnergy = Double.NaN;
                if (this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                    this.m_infoPanel.update((Object)this);
                }
                this.m_finalEnergy = this.m_cgMethod.dfrprmn(this.m_coord, this.m_cgEps, this.m_energy);
                this.m_numIterations = this.m_cgMethod.getNumIterations();
                if (this.m_surface.getNumVertices() * this.m_surface.getDimOfVertices() != this.m_coord.getSize()) {
                    Object var8_2 = null;
                    return;
                }
                PdVector[] pdVectorArray = this.m_surface.getVertices();
                int n = this.m_surface.getDimOfVertices();
                int n2 = this.m_surface.getNumVertices();
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = 0;
                    while (n5 < n) {
                        pdVectorArray[n4].m_data[n5] = this.m_coord.m_data[n3++];
                        ++n5;
                    }
                    ++n4;
                }
                if (this.m_bUpdateNormals) {
                    this.m_surface.makeVertexNormals();
                }
                if (this.m_domain == null || !this.m_bUpdateDomain || this.m_domain == this.m_surface || this.m_domain.getNumVertices() != n2 || this.m_domain.getDimOfVertices() != n) break block9;
                this.m_domain.copy((PgGeometry)this.m_surface);
            }
            Object var8_3 = null;
            return;
        }
    }

    public void step() {
        int n;
        int n2;
        int n3;
        int n4 = this.m_surface.getDimOfVertices();
        int n5 = this.m_surface.getNumVertices();
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        PdVector pdVector = null;
        double d = this.m_energy.eval(this.m_coord);
        pdVector = this.m_energy.evalGradient(this.m_coord, pdVector);
        double d2 = 0.01;
        int n6 = 0;
        do {
            n3 = 0;
            n2 = 0;
            while (n2 < n5) {
                n = 0;
                while (n < n4) {
                    this.m_coord.m_data[n3] = pdVectorArray[n2].m_data[n] - d2 * pdVector.m_data[n3++];
                    ++n;
                }
                ++n2;
            }
            d2 /= 2.0;
        } while (++n6 < 10 && d + 1.0E-10 <= this.m_energy.eval(this.m_coord));
        if (n6 == 10) {
            PsDebug.warning((String)"unable to do a steepest descent.");
            n3 = 0;
            n2 = 0;
            while (n2 < n5) {
                n = 0;
                while (n < n4) {
                    this.m_coord.m_data[n3++] = pdVectorArray[n2].m_data[n];
                    ++n;
                }
                ++n2;
            }
            return;
        }
        if (n6 > 1) {
            PsDebug.warning((String)("Stepsize in steepest descent adjusted, cnt = " + n6));
        }
        n3 = 0;
        n2 = 0;
        while (n2 < n5) {
            n = 0;
            while (n < n4) {
                pdVectorArray[n2].m_data[n] = this.m_coord.m_data[n3++];
                ++n;
            }
            ++n2;
        }
        if (this.m_bUpdateNormals) {
            this.m_surface.makeVertexNormals();
        }
        this.update(this);
    }

    public PgElementSet getDomain() {
        return this.m_domain;
    }

    public void step(int n) {
        this.m_bUseSteps = true;
        this.start();
    }

    public void printGradient() {
        PdVector pdVector = this.m_energy.evalGradient(this.m_coord, null);
        int n = this.m_surface.getDimOfVertices();
        int n2 = this.m_surface.getNumVertices();
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        StringBuffer stringBuffer = new StringBuffer("Gradient of Functional =\n");
        int n3 = Integer.toString(n2).length() + 1;
        int n4 = 0;
        while (n4 < n2) {
            stringBuffer.append("\t [" + PuString.intToString((int)n4, (int)n3) + "] = {");
            stringBuffer.append(String.valueOf(pdVector.getEntry(n4 * n)));
            int n5 = 1;
            while (n5 < n) {
                stringBuffer.append(", " + String.valueOf(pdVector.getEntry(n4 * n + n5)));
                ++n5;
            }
            if (pdVectorArray[n4].hasTag(13)) {
                stringBuffer.append("} Attr = { BND, ... }");
            }
            stringBuffer.append("}\n");
            ++n4;
        }
        PsDebug.message((String)stringBuffer.toString());
    }

    public void showNone() {
        if (this.m_surface != null) {
            this.m_vf = this.m_surface.getVectorField("Vector Field");
            if (this.m_vf != null) {
                this.m_surface.removeVectorField((PgGeometryIf)this.m_vf);
            }
        }
        this.m_vf = null;
        this.m_eVector = null;
        this.m_eValue = null;
        this.m_evSortInd = null;
    }

    public PnEnergyMinimizer() {
        this.m_coord = new PdVector();
        if (this.getClass() == (class$jvx$numeric$PnEnergyMinimizer != null ? class$jvx$numeric$PnEnergyMinimizer : (class$jvx$numeric$PnEnergyMinimizer = PnEnergyMinimizer.class$("jvx.numeric.PnEnergyMinimizer")))) {
            this.init();
        }
    }

    public void enableUpdateDomain(boolean bl) {
        this.m_bUpdateDomain = bl;
    }

    public void setUpdateDomain(boolean bl) {
        if (this.m_bUpdateDomain == bl) {
            return;
        }
        this.m_bUpdateDomain = bl;
        if (bl && this.m_domain != null && this.m_surface != null && this.m_domain != this.m_surface && this.m_domain.getNumVertices() == this.m_surface.getNumVertices() && this.m_domain.getDimOfVertices() == this.m_surface.getDimOfVertices()) {
            this.m_domain.copy((PgGeometry)this.m_surface);
        }
    }

    public void showGradient() {
        PdVector pdVector = this.m_energy.evalGradient(this.m_coord, null);
        int n = this.m_surface.getDimOfVertices();
        int n2 = this.m_surface.getNumVertices();
        if (this.m_vf == null) {
            this.m_vf = new PgVectorField(3);
            this.m_vf.setName("Vector Field");
            this.m_surface.addVectorField(this.m_vf);
        } else {
            this.m_vf = this.m_surface.getVectorField("Vector Field");
        }
        this.m_vf.setGeometry((PgPointSet)this.m_surface);
        PdVector[] pdVectorArray = this.m_vf.getVectors();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                pdVectorArray[n4].m_data[n5] = pdVector.m_data[n3++];
                ++n5;
            }
            ++n4;
        }
    }

    public void setNumLoops(int n) {
        this.m_numLoops = n;
    }

    public void showEigenvector(int n) {
        int n2 = this.m_surface.getDimOfVertices();
        int n3 = this.m_surface.getNumVertices();
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        if (this.m_eVector == null) {
            this.computeEigenvectors();
        }
        this.m_vf = this.m_surface.getVectorField("Vector Field");
        if (this.m_vf == null) {
            this.m_vf = new PgVectorField(3);
            this.m_vf.setName("Vector Field");
            this.m_surface.addVectorField(this.m_vf);
        }
        this.m_vf.setGeometry((PgPointSet)this.m_surface);
        PdVector[] pdVectorArray2 = this.m_vf.getVectors();
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            try {
                if (pdVectorArray[n6].hasTag(13)) {
                    pdVectorArray2[n6].setConstant(0.0);
                } else {
                    n4 = 0;
                    while (n4 < n2) {
                        pdVectorArray2[n6].m_data[n4] = this.m_eVector[this.m_evSortInd[n]].m_data[n5];
                        ++n5;
                        ++n4;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                PsDebug.warning((String)("ArrayIndexOutOfBoundsException, i=" + n6 + ", k=" + n4 + ", ipos=" + n5));
            }
            ++n6;
        }
    }

    public boolean update(Object object) {
        if (this.m_domain != null && this.m_domain == object) {
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void computeEigenvectors() {
        PsDebug.message((String)"computing ...");
        if (this.m_eValue == null) {
            this.m_eValue = new PdVector();
        }
        if (this.m_bHessianIsL2Normalized) {
            this.m_eVector = this.m_energy.getSpectrum(this.m_eValue, this.m_eVector);
            int n = this.m_eValue.getSize();
            this.m_evSortInd = new int[n];
            PuMath.heapsort((int)n, (double[])this.m_eValue.m_data, (int[])this.m_evSortInd);
            return;
        }
        this.m_hessian = this.m_energy.evalHessian(this.m_hessian);
        int n = this.m_hessian.getSize();
        if (n == -1) {
            PsDebug.error((String)"Hessian is non-square matrix", (Object)this.m_hessian);
            return;
        }
        this.m_eValue.setSize(n);
        this.m_evSortInd = new int[n];
        this.m_eVector = PdVector.realloc((PdVector[])this.m_eVector, (int)n, (int)n);
        int n2 = PnJacobi.computeEigenvectors(this.m_hessian, n, this.m_eValue, this.m_eVector);
        PuMath.heapsort((int)n, (double[])this.m_eValue.m_data, (int[])this.m_evSortInd);
    }

    public void printEigenvectors() {
        if (this.m_eVector == null) {
            this.computeEigenvectors();
        }
        PnJacobi.printEigenvectors(this.m_eValue.getSize(), this.m_eValue, this.m_eVector);
    }

    public void start() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_currLoop = 0;
        if (this.m_currLoop >= this.m_numLoops) {
            return;
        }
        this.m_bRunning = true;
        this.m_thread = new Thread((Runnable)this, "JavaView: Energy Minimization");
        this.m_thread.setPriority(5);
        this.m_thread.start();
    }

    public PnEnergy getEnergy() {
        return this.m_energy;
    }

    public void setEnergy(PnEnergy pnEnergy) {
        this.m_energy = pnEnergy;
        if (this.m_surface != null) {
            this.m_energy.setSurface(this.m_domain, this.m_surface);
            this.m_initialEnergy = this.m_energy.eval(this.m_coord);
        }
        this.showNone();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public double minimize() {
        this.start();
        return this.m_finalEnergy;
    }

    public void run() {
        this.m_bStopped = false;
        while (this.m_thread != null && this.m_bRunning) {
            if (this.m_bUseSteps) {
                this.step();
            } else {
                this.minimizeStep();
            }
            ++this.m_currLoop;
            this.update(this);
            if (this.m_currLoop >= this.m_numLoops) {
                this.stop();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.m_bStopped = true;
        this.update(this);
    }

    public void init() {
        super.init();
        this.m_numLoops = 1;
        this.m_initialEnergy = Double.NaN;
        this.m_finalEnergy = Double.NaN;
        this.m_cgEps = 1.0E-10;
        this.showNone();
        this.stop();
    }

    public void printHessian() {
        this.m_hessian = this.m_energy.evalHessian(this.m_hessian);
        PsDebug.message((String)("Hessian of Functional = \n" + this.m_hessian.toString()));
    }

    public boolean isStopped() {
        return this.m_bStopped;
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }
}

