/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.function.PuFunction;
import jv.object.PsDebug;
import jv.vecmath.PdVector;

public class PnRootFinder {
    public static double[] findValue(PuFunction puFunction, double[] dArray, double[] dArray2, double d) {
        int n = dArray.length;
        if (n == 0) {
            PsDebug.warning((String)"vertex dimension is zero, returning first vertex");
            return dArray;
        }
        if (dArray2.length != n) {
            PsDebug.warning((String)"vertices have different dimension, returning first vertex");
            return dArray;
        }
        double[] dArray3 = new double[1];
        puFunction.eval(dArray3, dArray);
        double d2 = dArray3[0] - d;
        if (Math.abs(d2) < 1.0E-10) {
            return (double[])dArray.clone();
        }
        puFunction.eval(dArray3, dArray2);
        double d3 = dArray3[0] - d;
        if (Math.abs(d3) < 1.0E-10) {
            return (double[])dArray2.clone();
        }
        if (d2 * d3 > 0.0) {
            PsDebug.warning((String)"differences between the points function values and the\n\tgiven value have same sign, returning first vertex");
            return dArray;
        }
        double[] dArray4 = (double[])dArray.clone();
        double[] dArray5 = (double[])dArray2.clone();
        double[] dArray6 = new double[n];
        while (true) {
            int n2 = 0;
            while (n2 < n) {
                dArray6[n2] = (dArray4[n2] + dArray5[n2]) / 2.0;
                ++n2;
            }
            puFunction.eval(dArray3, dArray6);
            double d4 = dArray3[0] - d;
            if (Math.abs(d4) < 1.0E-10) {
                return dArray6;
            }
            if (d4 * d2 < 0.0) {
                n2 = 0;
                while (n2 < n) {
                    dArray5[n2] = dArray6[n2];
                    ++n2;
                }
                d3 = d4;
                continue;
            }
            n2 = 0;
            while (n2 < n) {
                dArray4[n2] = dArray6[n2];
                ++n2;
            }
            d2 = d4;
        }
    }

    public static PdVector findRoots(PuFunction puFunction, double d, double d2, int n) {
        double d3 = 1.0E-12;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = PnRootFinder.zbrak(puFunction, d, d2, n, dArray, dArray2, n);
        PdVector pdVector = new PdVector(n2);
        int n3 = 0;
        while (n3 < n2) {
            double d4 = PnRootFinder.zbrent(puFunction, dArray[n3], dArray2[n3], d3);
            pdVector.setEntry(n3, d4);
            ++n3;
        }
        return pdVector;
    }

    public static double zbrent(PuFunction puFunction, double d, double d2, double d3) {
        int n = 100;
        double d4 = 3.0E-12;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = d;
        double d9 = d2;
        double d10 = puFunction.eval(d8);
        double d11 = puFunction.eval(d9);
        if (d11 * d10 > 0.0) {
            PsDebug.warning((String)"root must be bracketed in initial interval.");
            return d - 1.0;
        }
        double d12 = d11;
        int n2 = 0;
        while (n2 < n) {
            if (d11 * d12 > 0.0) {
                d5 = d8;
                d12 = d10;
                d7 = d6 = d9 - d8;
            }
            if (Math.abs(d12) < Math.abs(d11)) {
                d8 = d9;
                d9 = d5;
                d5 = d8;
                d10 = d11;
                d11 = d12;
                d12 = d10;
            }
            double d13 = 2.0 * d4 * Math.abs(d9) + 0.5 * d3;
            double d14 = 0.5 * (d5 - d9);
            if (Math.abs(d14) <= d13 || d11 == 0.0) {
                return d9;
            }
            if (Math.abs(d7) >= d13 && Math.abs(d10) > Math.abs(d11)) {
                double d15;
                double d16;
                double d17;
                double d18 = d11 / d10;
                if (d8 == d5) {
                    d17 = 2.0 * d14 * d18;
                    d16 = 1.0 - d18;
                } else {
                    d16 = d10 / d12;
                    double d19 = d11 / d12;
                    d17 = d18 * (2.0 * d14 * d16 * (d16 - d19) - (d9 - d8) * (d19 - 1.0));
                    d16 = (d16 - 1.0) * (d19 - 1.0) * (d18 - 1.0);
                }
                if (d17 > 0.0) {
                    d16 = -d16;
                }
                d17 = Math.abs(d17);
                double d20 = 3.0 * d14 * d16 - Math.abs(d13 * d16);
                double d21 = d20 < (d15 = Math.abs(d7 * d16)) ? d20 : d15;
                if (2.0 * d17 < d21) {
                    d7 = d6;
                    d6 = d17 / d16;
                } else {
                    d7 = d6 = d14;
                }
            } else {
                d7 = d6 = d14;
            }
            d8 = d9;
            d10 = d11;
            d9 = Math.abs(d6) > d13 ? (d9 += d6) : (d9 += d14 > 0.0 ? Math.abs(d13) : -Math.abs(d13));
            d11 = puFunction.eval(d9);
            ++n2;
        }
        PsDebug.warning((String)"maximum number of iterations exceeded");
        return d - 1.0;
    }

    public static int zbrak(PuFunction puFunction, double d, double d2, int n, double[] dArray, double[] dArray2, int n2) {
        int n3 = n2;
        n2 = 0;
        double d3 = (d2 - d) / (double)n;
        double d4 = d;
        double d5 = puFunction.eval(d4);
        int n4 = 0;
        while (n4 < n) {
            double d6 = puFunction.eval(d4 += d3);
            if (d6 * d5 < 0.0) {
                dArray[n2] = d4 - d3;
                dArray2[n2++] = d4;
            }
            d5 = d6;
            if (n3 == n2) {
                return n2;
            }
            ++n4;
        }
        return n2;
    }

    public static double[] findZero(PuFunction puFunction, double[] dArray, double[] dArray2) {
        return PnRootFinder.findValue(puFunction, dArray, dArray2, 0.0);
    }

    public static double[] zbrac(PuFunction puFunction, double d, double d2) {
        double d3 = 1.6;
        int n = 50;
        double[] dArray = new double[]{d, d2};
        if (d == d2) {
            PsDebug.warning((String)"bad initial interval.");
            return null;
        }
        double d4 = puFunction.eval(d);
        double d5 = puFunction.eval(d2);
        int n2 = 0;
        while (n2 < n) {
            if (d4 * d5 < 0.0) {
                return dArray;
            }
            if (Math.abs(d4) < Math.abs(d5)) {
                dArray[0] = dArray[0] + d3 * (d - d2);
                d4 = puFunction.eval(dArray[0]);
            } else {
                dArray[1] = dArray[1] + d3 * (d2 - d);
                d5 = puFunction.eval(dArray[1]);
            }
            ++n2;
        }
        return null;
    }
}

