/*
 * Decompiled with CFR 0.152.
 */
package third.dol.dressed;

import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.number.PuComplex;
import jv.number.PuComplexP;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PcMatrix;
import jv.vecmath.PdVector;

public class PjDressed
extends PjProject {
    protected PcMatrix m_i;
    protected PcMatrix m_j;
    protected PcMatrix m_k;
    protected PcMatrix[] m_Sk;
    protected PgElementSet m_surface = new PgElementSet(3);
    protected PuInteger m_surfSteps = new PuInteger("Rotation", (PsUpdateIf)this);
    protected PuInteger m_length = new PuInteger("Length", (PsUpdateIf)this);
    protected PuDouble m_timeDiff = new PuDouble("Time intervall", (PsUpdateIf)this);
    protected PuComplex m_l0 = new PuComplex();
    protected PuComplex m_s0 = new PuComplex();
    protected PuComplexP m_l0P = new PuComplexP("l0", (PsUpdateIf)this);
    protected PuComplexP m_s0P = new PuComplexP("s0", (PsUpdateIf)this);
    protected PuDouble m_l0Re;
    protected PuDouble m_l0Im;
    protected PuDouble m_s0Re;
    protected PuDouble m_s0Im;
    private static /* synthetic */ Class class$third$dol$dressed$PjDressed;

    public PdVector quatToR3(PcMatrix pcMatrix) {
        if (pcMatrix == null) {
            return null;
        }
        PdVector pdVector = new PdVector(3);
        pdVector.m_data[0] = pcMatrix.m_data[0][0].im;
        pdVector.m_data[1] = pcMatrix.m_data[1][0].im;
        pdVector.m_data[2] = pcMatrix.m_data[1][0].re;
        return pdVector;
    }

    public void getLine(double d, PuComplex puComplex, PuComplex puComplex2, PgPolygon pgPolygon) {
        int n = pgPolygon.getNumVertices();
        int n2 = -n / 2;
        PcMatrix pcMatrix = new PcMatrix(2);
        int n3 = n2;
        while (n3 < n2 + n) {
            PuComplex puComplex3 = new PuComplex();
            PuComplex puComplex4 = new PuComplex();
            PuComplex puComplex5 = new PuComplex();
            PuComplex puComplex6 = new PuComplex();
            PuComplex puComplex7 = new PuComplex();
            PuComplex puComplex8 = new PuComplex();
            if (n3 != 0) {
                puComplex7.copy(puComplex);
                puComplex7.mult(PuComplex.I);
                puComplex7.add(1.0);
                puComplex5.copy(puComplex7);
                puComplex8.copy(puComplex);
                puComplex8.mult(PuComplex.I);
                puComplex8.sub(1.0);
                puComplex8.mult(-1.0);
                puComplex6.copy(puComplex8);
                int n4 = 1;
                while (n4 < Math.abs(n3)) {
                    puComplex5.mult(puComplex7);
                    puComplex6.mult(puComplex8);
                    ++n4;
                }
                if (n3 < 0) {
                    puComplex5.inv();
                    puComplex6.inv();
                }
            } else {
                puComplex5.set(1.0, 0.0);
                puComplex6.set(1.0, 0.0);
            }
            puComplex8.copy(puComplex);
            puComplex8.mult(puComplex);
            puComplex7.copy(puComplex8);
            puComplex8.add(1.0);
            puComplex7.div(puComplex8);
            puComplex7.mult(-2.0 * d);
            puComplex7.mult(PuComplex.I);
            puComplex7.exp();
            puComplex5.mult(puComplex7);
            puComplex7.inv();
            puComplex6.mult(puComplex7);
            puComplex7.copy(puComplex2);
            puComplex7.mult(PuComplex.conj((PuComplex)puComplex2));
            puComplex7.mult(puComplex6);
            puComplex7.div(puComplex5);
            puComplex7.div(PuComplex.conj((PuComplex)puComplex));
            puComplex3.copy(PuComplex.conj((PuComplex)puComplex5));
            puComplex3.div(PuComplex.conj((PuComplex)puComplex6));
            puComplex3.div(puComplex);
            puComplex3.add(puComplex7);
            puComplex7.copy(puComplex2);
            puComplex7.mult(PuComplex.conj((PuComplex)puComplex2));
            puComplex7.mult(puComplex6);
            puComplex7.div(puComplex5);
            puComplex7.add(PuComplex.div((PuComplex)PuComplex.conj((PuComplex)puComplex5), (PuComplex)PuComplex.conj((PuComplex)puComplex6)));
            puComplex3.div(puComplex7);
            puComplex3.mult(-1.0);
            puComplex4.copy(PuComplex.inv((PuComplex)PuComplex.conj((PuComplex)puComplex)));
            puComplex4.sub(PuComplex.inv((PuComplex)puComplex));
            puComplex7.copy(puComplex2);
            puComplex7.mult(PuComplex.conj((PuComplex)puComplex2));
            puComplex7.mult(puComplex6);
            puComplex7.div(puComplex5);
            puComplex7.add(PuComplex.div((PuComplex)PuComplex.conj((PuComplex)puComplex5), (PuComplex)PuComplex.conj((PuComplex)puComplex6)));
            puComplex4.div(puComplex7);
            puComplex4.mult(PuComplex.conj((PuComplex)puComplex2));
            pcMatrix.m_data[0][0].set(0.0, puComplex3.im + (double)n3);
            pcMatrix.m_data[0][1].copy(puComplex4);
            pcMatrix.m_data[1][0].copy(PuComplex.conj((PuComplex)puComplex4));
            pcMatrix.m_data[1][0].mult(-1.0);
            pcMatrix.m_data[1][1].set(0.0, -puComplex3.im - (double)n3);
            pgPolygon.setVertex(n3 - n2, this.quatToR3(pcMatrix));
            ++n3;
        }
    }

    public PjDressed() {
        super("Dressed Straight Lines");
        this.m_i = new PcMatrix(2);
        this.m_j = new PcMatrix(2);
        this.m_k = new PcMatrix(2);
        this.m_i.setConstant(new PuComplex(0.0, 0.0));
        this.m_i.m_data[0][0].set(0.0, 1.0);
        this.m_i.m_data[1][1].set(0.0, -1.0);
        this.m_j.setConstant(new PuComplex(0.0, 0.0));
        this.m_j.m_data[0][1].set(0.0, 1.0);
        this.m_j.m_data[1][0].set(0.0, 1.0);
        this.m_k.setConstant(new PuComplex(0.0, 0.0));
        this.m_k.m_data[0][1].set(-1.0, 0.0);
        this.m_k.m_data[1][0].set(1.0, 0.0);
        this.m_l0Re = new PuDouble("l0 Re", (PsUpdateIf)this);
        this.m_l0Im = new PuDouble("l0 Im", (PsUpdateIf)this);
        this.m_s0Re = new PuDouble("s0 Re", (PsUpdateIf)this);
        this.m_s0Im = new PuDouble("s0 Im", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$third$dol$dressed$PjDressed != null ? class$third$dol$dressed$PjDressed : (class$third$dol$dressed$PjDressed = PjDressed.class$("third.dol.dressed.PjDressed")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        if (object != null) {
            if (object == this.m_surfSteps) {
                this.computeSurface();
                this.m_surface.update(null);
                return super.update(null);
            }
            if (object == this.m_length) {
                this.computeSurface();
                this.m_surface.update(null);
                return super.update(null);
            }
            if (object == this.m_timeDiff) {
                this.computeSurface();
                this.m_surface.update(null);
                return super.update(null);
            }
            if (object == this.m_l0Re) {
                this.computeSurface();
                this.m_surface.update(null);
                return super.update(null);
            }
            if (object == this.m_l0Im) {
                this.computeSurface();
                this.m_surface.update(null);
                return super.update(null);
            }
            if (object == this.m_s0Re) {
                this.computeSurface();
                this.m_surface.update(null);
                return super.update(null);
            }
            if (object == this.m_s0Im) {
                this.computeSurface();
                this.m_surface.update(null);
                return super.update(null);
            }
            if (object == this.m_s0P) {
                this.computeSurface();
                this.m_surface.update(null);
                return super.update(null);
            }
            if (object == this.m_l0P) {
                this.computeSurface();
                this.m_surface.update(null);
                return super.update(null);
            }
        }
        return super.update(object);
    }

    public void start() {
        super.start();
        this.m_surface.setName("Hashimoto Surface");
        this.addGeometry((PgGeometryIf)this.m_surface);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_l0.set(0.08, -0.4);
        this.m_s0.set(0.5, 1.0);
        this.m_surfSteps.setDefValue(7);
        this.m_surfSteps.setDefBounds(1, 50, 1, 5);
        this.m_surfSteps.init();
        this.m_length.setDefValue(7);
        this.m_length.setDefBounds(1, 50, 1, 5);
        this.m_length.init();
        this.m_timeDiff.setDefValue(1.0);
        this.m_timeDiff.setDefBounds(0.1, 10.0, 0.1, 0.5);
        this.m_timeDiff.init();
        this.m_l0P.getInfoPanel();
        this.m_l0P.setRealBounds(-0.5, 0.5, 0.01, 0.1);
        this.m_l0P.setImagBounds(-0.5, 0.5, 0.01, 0.1);
        this.m_l0P.setRadiusBounds(0.01, 0.7, 0.01, 0.1);
        this.m_l0P.set(this.m_l0);
        this.m_l0P.init();
        this.m_s0P.getInfoPanel();
        this.m_s0P.setRealBounds(-10.0, 10.0, 0.05, 0.2);
        this.m_s0P.setImagBounds(-10.0, 10.0, 0.05, 0.2);
        this.m_s0P.setRadiusBounds(0.01, 10.0, 0.1, 0.5);
        this.m_s0P.setAngleBounds(0.01, 6.28, 0.1, 0.5);
        this.m_s0P.set(this.m_s0);
        this.m_s0P.init();
        this.computeSurface();
    }

    public void computeSurface() {
        PgPolygon pgPolygon = new PgPolygon(3);
        int n = 0;
        int n2 = 2 * this.m_length.getValue() + 1;
        pgPolygon.setNumVertices(n2);
        int n3 = this.m_surfSteps.getValue();
        this.m_surface.setNumVertices(n2 * (n3 + 1));
        double d = this.m_timeDiff.getValue();
        this.m_l0.copy(this.m_l0P.getValue());
        this.m_s0.copy(this.m_s0P.getValue());
        int n4 = 0;
        int n5 = 0;
        do {
            this.getLine((double)n4 * d, this.m_l0, this.m_s0, pgPolygon);
            ++n;
            ++n4;
            int n6 = 0;
            while (n6 < n2) {
                this.m_surface.setVertex(n5, PdVector.copyNew((PdVector)pgPolygon.getVertex(n6 % n2)));
                ++n5;
                ++n6;
            }
        } while (n4 <= n3);
        this.m_surface.makeQuadrConn(n3 + 1, n2);
        this.m_surface.makeQuadrBnd(n3 + 1, n2);
    }
}

