/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.zip.DeflaterOutputStream;
import jdvi.JDviContext;
import jdvi.JDviScribble;
import jdvi.JDviViewerPanel;

public class JDvi
extends Panel
implements JDviContext {
    JDviViewerPanel dvi;
    URL scribbleURL;
    Properties properties = new Properties();
    FileDialog dialog;
    long modificationTime = 0L;
    File dviFile;

    public JDvi() throws FileNotFoundException, IOException {
        File file = new File(System.getProperty("jdvi.propertiesFile", String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "jdviProp"));
        if (file.exists()) {
            System.out.println("loading properties from " + file);
            FileInputStream fileInputStream = new FileInputStream(file);
            this.properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
    }

    public AudioClip getAudioClip(URL uRL) {
        return null;
    }

    public URL getCodeBase() {
        try {
            return new URL("file:" + System.getProperty("user.dir") + System.getProperty("file.separator"));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL getDocumentBase() {
        return this.getCodeBase();
    }

    public Image getImage(URL uRL) {
        Image image = null;
        try {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                Object object = uRLConnection.getContent();
                if (object instanceof ImageProducer) {
                    System.out.println("image producer " + object);
                    image = this.createImage((ImageProducer)object);
                } else if (object instanceof Image) {
                    image = (Image)object;
                }
            }
            catch (MalformedURLException malformedURLException) {
                image = null;
                System.err.println("Image loading: " + malformedURLException);
            }
            catch (IOException iOException) {
                image = null;
                System.err.println("Image loading: " + iOException);
            }
        }
        catch (Throwable throwable) {}
        return image;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String string) {
        return System.getProperty(string, this.properties.getProperty(string));
    }

    public String getProperty(String string, String string2) {
        return System.getProperty(string, this.properties.getProperty(string, string2));
    }

    public void inform(String string) {
        System.out.println("Inform: " + string);
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException {
        System.out.println("home:" + System.getProperty("user.home"));
        JDvi jDvi = new JDvi();
        if (stringArray.length > 2 | stringArray.length < 1) {
            System.err.println("usage: java JDvi dvi_file");
            System.exit(0);
        }
        jDvi.dvi = new JDviViewerPanel(jDvi);
        jDvi.add("Center", jDvi.dvi);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                block3: {
                    if (JDvi.this.dviFile == null || JDvi.this.modificationTime >= JDvi.this.dviFile.lastModified()) break block3;
                    try {
                        JDvi.this.modificationTime = JDvi.this.dviFile.lastModified();
                        JDvi.this.dvi.page.fullsize.flush();
                        JDvi.this.dvi.page.fullsize = null;
                        JDvi.this.dvi.loadDocument(JDvi.this.dvi.page.document.document, JDvi.this.dvi.page.document.document.toString());
                        JDvi.this.dvi.page.repaint();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {}
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                JDvi.this.writeScribbleFile();
                JDvi.this.writeFontCache();
                System.exit(0);
            }
        };
        Frame frame = new Frame("jDvi");
        frame.addWindowListener(windowAdapter);
        frame.add(jDvi);
        ((Component)frame).setSize(600, 500);
        frame.show();
        jDvi.dialog = new FileDialog(frame, "Write ScribbleFile", 1);
        URL uRL = new URL("file:" + System.getProperty("user.dir") + System.getProperty("file.separator"));
        URL uRL2 = new URL(uRL, stringArray[0]);
        String string = uRL2.getFile();
        string = string.endsWith(".dvi") ? String.valueOf(string.substring(0, string.length() - 3)) + "sbl" : String.valueOf(string) + ".sbl";
        string = jDvi.getProperty("jdvi.scribbleFile.name", string);
        jDvi.scribbleURL = new URL(uRL, string);
        if (uRL2.getProtocol().startsWith("file")) {
            jDvi.dviFile = new File(uRL2.getFile());
            jDvi.modificationTime = jDvi.dviFile.lastModified();
        }
        frame.setTitle(uRL2.toString());
        if (stringArray.length < 2) {
            jDvi.dvi.loadDocument(uRL2, uRL2.toString());
        } else {
            jDvi.dvi.loadDocument(uRL2, "file:" + System.getProperty("user.dir") + System.getProperty("file.separator") + stringArray[1]);
        }
        jDvi.readScribbleFile();
        jDvi.repaint();
        jDvi.dvi.gotoPage(0);
    }

    public void readScribbleFile() {
        try {
            InputStream inputStream = this.scribbleURL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            System.out.println("Reading scribble file " + this.scribbleURL);
            int n = 0;
            while (n < this.dvi.getNumberOfPages()) {
                this.dvi.page.scribble[n] = (JDviScribble)objectInputStream.readObject();
                ++n;
            }
            inputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
        }
    }

    public void showDocument(URL uRL) {
        String[] stringArray = new String[]{System.getProperty("jdvi.browser", this.getProperties().getProperty("jdvi.browser", "netscape")), uRL.toExternalForm()};
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void showDocument(URL uRL, String string) {
        try {
            this.showDocument(new URL(uRL, string));
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public void writeFontCache() {
        block3: {
            String string = this.getProperty("jdvi.font.cache");
            if (string == null) break block3;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(fileOutputStream);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(deflaterOutputStream);
                System.out.print("Writing font cache file " + string);
                objectOutputStream.writeObject(this.dvi.page.document.font);
                objectOutputStream.flush();
                deflaterOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
    }

    public void writeScribbleFile() {
        if (this.getProperty("jdvi.scribbleFile.save") == null) {
            return;
        }
        String string = null;
        if (this.scribbleURL.getProtocol().equals("file")) {
            string = this.scribbleURL.getFile();
            this.dialog.setFile(string);
        }
        this.dialog.show();
        if (this.dialog.getFile() != null) {
            string = String.valueOf(this.dialog.getDirectory()) + this.dialog.getFile();
            System.out.println("Choosen:" + this.dialog.getDirectory() + this.dialog.getFile());
            this.dialog.dispose();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                System.out.print("Writing scribble file " + string);
                int n = 0;
                while (n < this.dvi.getNumberOfPages()) {
                    objectOutputStream.writeObject(this.dvi.page.scribble[n]);
                    System.out.print(".");
                    ++n;
                }
                System.out.println(" ");
                objectOutputStream.flush();
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        } else {
            System.out.println("Nothing saved!");
        }
    }
}

