/*
 * Decompiled with CFR 0.152.
 */
package jdvi;

import java.awt.Color;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.InflaterInputStream;
import jdvi.ArrayFile;
import jdvi.JDviColor;
import jdvi.JDviContext;
import jdvi.Page;
import jdvi.font.Font;
import jdvi.font.Glyph;

public class JDviDocument {
    public URL document;
    JDviContext context;
    public static final double a4widthIn = 8.26;
    public static final double a4heightIn = 11.69;
    double paperWidth = 8.26;
    double paperHeight = 11.69;
    ArrayFile file = null;
    int trueDviDpi;
    String fontBase;
    public Font[] font = new Font[256];
    Page[] page;
    Hashtable targetHash = new Hashtable();
    public Color textColor;
    long num;
    long den;
    long mag;
    double scale;
    public int stackDepth;
    Stack scanStack;
    Color scanCc;
    Color scanBg = Color.white;

    public JDviDocument(JDviContext jDviContext, URL uRL, String string, int n) throws IOException {
        this.document = uRL;
        this.fontBase = string;
        this.trueDviDpi = n;
        this.context = jDviContext;
        this.paperWidth = this.getDouble("jdvi.paper.width", 8.26);
        this.paperHeight = this.getDouble("jdvi.paper.height", 11.69);
        if (this.context.getProperty("jdvi.font.alpha", "").equalsIgnoreCase("true")) {
            Glyph.v2 = true;
            System.out.println("using alpha in Bitmap");
        } else {
            System.out.println("using no alpha in Bitmap");
        }
        this.loadDviURL();
        this.parsePre();
        if (this.context != null) {
            String string2 = this.context.getProperty("jdvi.font.cache");
            if (string2 != null) {
                try {
                    URL uRL2 = new URL(this.document, string2);
                    InputStream inputStream = uRL2.openStream();
                    InflaterInputStream inflaterInputStream = new InflaterInputStream(inputStream);
                    ObjectInputStream objectInputStream = new ObjectInputStream(inflaterInputStream);
                    this.font = (Font[])objectInputStream.readObject();
                    inputStream.close();
                    System.out.println("read fonts from cache file.");
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println(classNotFoundException);
                }
            }
        } else {
            System.out.println("context null!.");
        }
        this.parsePost();
    }

    private double getDouble(String string, double d) {
        double d2 = d;
        try {
            try {
                d2 = new Double(this.context.getProperty(string, "xxx"));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Formaterror while parsing " + string + "=" + this.context.getProperty(string) + " as a double using default " + d + " insead");
                d2 = d;
            }
        }
        catch (Throwable throwable) {}
        return d2;
    }

    private void loadDviURL() throws IOException {
        URLConnection uRLConnection = this.document.openConnection();
        uRLConnection.connect();
        int n = uRLConnection.getContentLength();
        InputStream inputStream = uRLConnection.getInputStream();
        this.file = new ArrayFile(n);
        int n2 = 0;
        while (n2 < n) {
            this.file.data[n2] = (byte)inputStream.read();
            ++n2;
        }
    }

    public static double parseDim(String string) {
        double d = -1.0;
        try {
            if (string.endsWith("in")) {
                d = new Double(string.substring(0, string.length() - 2));
            } else if (string.endsWith("pt")) {
                d = new Double(string.substring(0, string.length() - 2)) / 72.27;
            } else if (string.endsWith("bp")) {
                d = new Double(string.substring(0, string.length() - 2)) / 72.0;
            } else if (string.endsWith("pc")) {
                d = new Double(string.substring(0, string.length() - 2)) / 867.24;
            } else if (string.endsWith("cm")) {
                d = new Double(string.substring(0, string.length() - 2)) / 2.5322355;
            } else if (string.endsWith("mm")) {
                d = new Double(string.substring(0, string.length() - 2)) / 0.25322355;
            } else if (string.endsWith("dd")) {
                d = new Double(string.substring(0, string.length() - 2)) / 89470.26;
            } else if (string.endsWith("cc")) {
                d = new Double(string.substring(0, string.length() - 2)) / 1073643.1199999999;
            } else if (string.endsWith("sp")) {
                d = new Double(string.substring(0, string.length() - 2)) / 4736286.72;
            }
        }
        catch (Throwable throwable) {}
        return d;
    }

    private void parsePost() throws EOFException {
        int n;
        this.file.pos = this.file.data.length - 1;
        while (this.file.read() == 223) {
            --this.file.pos;
            --this.file.pos;
        }
        this.file.pos -= 5;
        this.file.pos = (int)this.file.readUnsignedInt();
        System.out.println("This should be 248: " + this.file.read());
        int n2 = (int)this.file.readUnsignedInt();
        this.file.pos += 20;
        this.stackDepth = this.file.readUnsignedShort();
        this.page = new Page[this.file.readUnsignedShort()];
        System.out.println(String.valueOf(this.page.length) + " pages");
        int n3 = this.file.read();
        while (n3 != 249) {
            block0 : switch (n3) {
                case 243: {
                    int n4 = this.file.read();
                    this.file.pos += 4;
                    double d = 0.001 * (double)this.file.readUnsignedInt() * (double)this.mag * (double)this.trueDviDpi / (double)this.file.readUnsignedInt();
                    int n5 = this.file.read();
                    String string = new String(this.file.data, this.file.pos, n5 += this.file.read());
                    this.file.pos += n5;
                    if (this.font[n4] != null && this.font[n4].name.equals(string) && this.font[n4].size == d) break;
                    this.font[n4] = null;
                    n = 0;
                    while (n < 2 && this.font[n4] == null) {
                        String string2 = this.context.getProperty("jdvi.font.nameformat", "%name%.%dpi%pk");
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, "%");
                        String string3 = "";
                        String string4 = null;
                        while (stringTokenizer.hasMoreTokens()) {
                            string4 = stringTokenizer.nextToken();
                            string3 = string4.equals("name") ? String.valueOf(string3) + string : (string4.equals("dpi") ? String.valueOf(string3) + ((int)d + n) : String.valueOf(string3) + string4);
                        }
                        this.font[n4] = Font.loadFont(this.fontBase, string3);
                        if (this.font[n4] == null) {
                            if (n == 1) {
                                this.context.inform("Font " + n4 + ":" + string3 + " not found.");
                            }
                        } else {
                            this.context.inform("Loaded font " + n4 + ":" + string3);
                            this.font[n4].name = string;
                            this.font[n4].size = d;
                            break block0;
                        }
                        ++n;
                    }
                    break;
                }
            }
            n3 = this.file.read();
        }
        n = this.page.length - 1;
        this.textColor = JDviColor.getColor(this.context, "textColor", Color.black);
        while (n2 != -1) {
            this.page[n] = new Page(n2, this.textColor);
            --n;
            this.file.pos = n2 + 41;
            n2 = (int)this.file.readUnsignedInt();
        }
        int n6 = 0;
        while (n6 < this.page.length) {
            this.scanPage(n6);
            ++n6;
        }
    }

    private void parsePre() throws EOFException {
        int n;
        this.file.pos = 0;
        int n2 = this.file.read();
        if (n2 != 247 | (n = this.file.read()) != 2) {
            System.err.println("This semms to be no valid dvi file!");
            return;
        }
        this.num = this.file.readUnsignedInt();
        this.den = this.file.readUnsignedInt();
        this.mag = this.file.readUnsignedInt();
        this.scale = (double)this.mag * (double)this.num / ((double)this.den * 1000.0);
        n = this.file.read();
        byte[] byArray = new byte[n];
        this.file.read(byArray);
        System.out.println("DVI comment: " + new String(byArray));
    }

    private void scanPage(int n) {
        int n2 = 0;
        ArrayFile arrayFile = new ArrayFile(this.file);
        Page page = this.page[n];
        arrayFile.pos = page.pos;
        this.scanStack = (Stack)page.textColors.clone();
        this.scanCc = (Color)this.scanStack.pop();
        page.setBackground(this.scanBg);
        try {
            int n3 = arrayFile.read();
            while (n3 != 140) {
                if (n3 > 127) {
                    switch (n3) {
                        case 128: 
                        case 133: 
                        case 143: 
                        case 148: 
                        case 153: 
                        case 157: 
                        case 162: 
                        case 167: 
                        case 235: {
                            ++arrayFile.pos;
                            break;
                        }
                        case 129: 
                        case 134: 
                        case 144: 
                        case 149: 
                        case 154: 
                        case 158: 
                        case 163: 
                        case 168: 
                        case 236: {
                            arrayFile.pos += 2;
                            break;
                        }
                        case 130: 
                        case 135: 
                        case 145: 
                        case 150: 
                        case 155: 
                        case 159: 
                        case 164: 
                        case 169: 
                        case 237: {
                            arrayFile.pos += 3;
                            break;
                        }
                        case 131: 
                        case 136: 
                        case 146: 
                        case 151: 
                        case 156: 
                        case 160: 
                        case 165: 
                        case 170: 
                        case 238: {
                            arrayFile.pos += 4;
                            break;
                        }
                        case 132: 
                        case 137: {
                            arrayFile.pos += 8;
                            break;
                        }
                        case 239: {
                            n2 = arrayFile.read();
                            this.scanSpecial(new String(arrayFile.data, arrayFile.pos, n2), page, n);
                            arrayFile.pos += n2;
                            break;
                        }
                        case 240: {
                            n2 = arrayFile.readUnsignedShort();
                            this.scanSpecial(new String(arrayFile.data, arrayFile.pos, n2), page, n);
                            arrayFile.pos += n2;
                            break;
                        }
                        case 241: {
                            n2 = arrayFile.read3();
                            this.scanSpecial(new String(arrayFile.data, arrayFile.pos, n2), page, n);
                            arrayFile.pos += n2;
                            break;
                        }
                        case 242: {
                            n2 = arrayFile.readInt();
                            this.scanSpecial(new String(arrayFile.data, arrayFile.pos, n2), page, n);
                            arrayFile.pos += n2;
                            break;
                        }
                        case 246: {
                            ++arrayFile.pos;
                        }
                        case 245: {
                            ++arrayFile.pos;
                        }
                        case 244: {
                            ++arrayFile.pos;
                        }
                        case 243: {
                            arrayFile.pos += 13;
                            n2 = arrayFile.read();
                            arrayFile.pos += (n2 += arrayFile.read());
                            break;
                        }
                        case 247: {
                            System.err.println("Found a preamble in page " + n);
                            break;
                        }
                        case 248: {
                            System.err.println("Found a postamble in page " + n);
                            break;
                        }
                        case 249: {
                            System.err.println("Found a post-post in page " + n);
                            break;
                        }
                        case 139: {
                            page.c0 = arrayFile.readInt();
                            page.c1 = arrayFile.readInt();
                            page.c2 = arrayFile.readInt();
                            page.c3 = arrayFile.readInt();
                            page.c4 = arrayFile.readInt();
                            page.c5 = arrayFile.readInt();
                            page.c6 = arrayFile.readInt();
                            page.c7 = arrayFile.readInt();
                            page.c8 = arrayFile.readInt();
                            page.c9 = arrayFile.readInt();
                            arrayFile.readInt();
                            break;
                        }
                    }
                }
                n3 = arrayFile.read();
            }
        }
        catch (EOFException eOFException) {
            System.err.println(String.valueOf(String.valueOf(eOFException)) + " occured while scanning page " + n);
        }
        this.scanStack.push(this.scanCc);
        if (this.page.length > n + 1) {
            this.page[n + 1].setColorStack(this.scanStack);
        }
    }

    private final void scanSpecial(String string, Page page, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"=<>,");
        String string2 = stringTokenizer.nextToken();
        if (string2.equalsIgnoreCase("background")) {
            page.setBackground(JDviColor.parseColor(this.context, stringTokenizer));
            this.scanBg = page.background;
            return;
        }
        if (string2.startsWith("html")) {
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("a") && (string2 = stringTokenizer.nextToken()).equalsIgnoreCase("name")) {
                String string3 = stringTokenizer.nextToken();
                this.targetHash.put(string3, new Integer(n));
            }
            return;
        }
        if (string2.equalsIgnoreCase("color")) {
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("pop")) {
                this.scanCc = (Color)this.scanStack.pop();
                return;
            }
            if (string2.equalsIgnoreCase("push")) {
                this.scanStack.push(this.scanCc);
                this.scanCc = JDviColor.parseColor(this.context, stringTokenizer);
                return;
            }
        }
        if (string2.equalsIgnoreCase("papersize")) {
            string2 = stringTokenizer.nextToken("=,");
            double d = JDviDocument.parseDim(string2);
            if (d > 0.0) {
                this.paperWidth = d;
                System.out.println("paper width set to " + d + " by special");
            }
            if ((d = JDviDocument.parseDim(string2 = stringTokenizer.nextToken())) > 0.0) {
                this.paperHeight = d;
                System.out.println("paper height set to " + d + " by special");
            }
            return;
        }
    }
}

