/*
 * Decompiled with CFR 0.152.
 */
package jdvi;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.EOFException;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import jdvi.ArrayFile;
import jdvi.HyperRef;
import jdvi.IntStack;
import jdvi.JDviColor;
import jdvi.JDviDocument;
import jdvi.Page;
import jdvi.Specialist;
import jdvi.font.Font;
import jdvi.font.Glyph;

public final class JDviRenderer {
    Specialist specialist;
    JDviDocument document;
    Color currentColor = Color.black;
    Color backgroundColor = Color.white;
    Stack colorStack = new Stack();
    HyperRef currentRef;
    Font[] font;
    ArrayFile file;
    double fontScale = 1.0;
    double K;
    int stackDepth = 1000;

    public JDviRenderer(Specialist specialist, JDviDocument jDviDocument, int n) {
        this.specialist = specialist;
        this.document = jDviDocument;
        this.font = jDviDocument.font;
        this.K = jDviDocument.scale / 2.54 * (double)n / 100000.0;
        this.fontScale = (double)n / (double)jDviDocument.trueDviDpi;
        this.file = new ArrayFile(jDviDocument.file);
    }

    private void callSpecial(Graphics graphics, int n, int n2, String string, int n3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"=");
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.equalsIgnoreCase("color")) {
            stringTokenizer = new StringTokenizer(string);
            string2 = "";
            try {
                string2 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                if (string2.startsWith("pop")) {
                    this.setCurrentColor((Color)this.colorStack.pop());
                    return;
                }
                if (string2.startsWith("push")) {
                    this.colorStack.push(this.getCurrentColor());
                    this.setCurrentColor(JDviColor.parseColor(this.document.context, stringTokenizer));
                    return;
                }
                System.out.println("could not resolve colorspecial:" + string);
                return;
            }
            catch (NoSuchElementException noSuchElementException) {
                System.err.println("Too few tokens in color special.");
                return;
            }
        }
        if (string2.equalsIgnoreCase("background")) {
            return;
        }
        this.specialist.callSpecial(graphics, n, n2, string, n3);
    }

    public void flushFonts() {
        int n = 0;
        while (n < this.font.length) {
            if (this.font[n] != null) {
                this.font[n].flush();
            }
            ++n;
        }
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    public void renderPage(Graphics graphics, int n, int n2, int n3) throws EOFException {
        Page page = this.document.page[n3];
        this.file.pos = page.pos;
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null) {
            graphics.setColor(page.background);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
        graphics.setColor(Color.black);
        this.colorStack = (Stack)this.document.page[n3].textColors.clone();
        this.setCurrentColor((Color)this.colorStack.pop());
        int n4 = -1;
        IntStack intStack = new IntStack(this.stackDepth, 0);
        IntStack intStack2 = new IntStack(this.stackDepth, 0);
        IntStack intStack3 = new IntStack(this.stackDepth, 0);
        IntStack intStack4 = new IntStack(this.stackDepth, 0);
        IntStack intStack5 = new IntStack(this.stackDepth, 0);
        IntStack intStack6 = new IntStack(this.stackDepth, 0);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.file.read();
        while (n8 != 140) {
            if (n8 < 132) {
                if (n8 < 128) {
                    n5 = n8;
                } else if (n8 == 128) {
                    n5 = this.file.read();
                } else if (n8 == 129) {
                    n5 = 0xFF & this.file.readUnsignedShort();
                } else if (n8 == 130) {
                    n5 = 0xFF & this.file.read3();
                } else if (n8 == 131) {
                    n5 = 0xFF & this.file.readInt();
                }
                try {
                    Glyph glyph = this.font[n4].chars[n5];
                    glyph.draw(graphics, this.currentColor, n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value), this.fontScale);
                    if (this.currentRef != null) {
                        this.currentRef.union(glyph.getBBox(n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value), this.fontScale));
                    }
                    intStack.value += (int)((double)glyph.tfm * this.font[n4].conv_fac / this.K * this.fontScale);
                }
                catch (NullPointerException nullPointerException) {
                    System.err.println("Font " + n4 + " char " + n5 + " does not exist!");
                }
            } else {
                switch (n8) {
                    case 132: {
                        int n9;
                        n6 = this.file.readInt();
                        n7 = this.file.readInt();
                        if (n6 > 0 & n7 > 0) {
                            int n10 = this.toPixels(n7);
                            if (n10 == 0) {
                                n10 = 1;
                            }
                            if ((n9 = this.toPixels(n6)) == 0) {
                                n9 = 1;
                            }
                            graphics.setColor(this.currentColor);
                            graphics.fillRect(n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value - n6), n10, n9);
                        }
                        intStack.value += n7;
                        break;
                    }
                    case 133: {
                        n5 = this.file.read();
                        try {
                            Glyph glyph = this.font[n4].chars[n5];
                            glyph.draw(graphics, this.currentColor, n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value), this.fontScale);
                            if (this.currentRef == null) break;
                            this.currentRef.union(glyph.getBBox(n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value), this.fontScale));
                        }
                        catch (NullPointerException nullPointerException) {
                            System.err.println("Font " + n4 + " char " + n5 + " does not exist!");
                        }
                        break;
                    }
                    case 134: {
                        n5 = 0xFF & this.file.readUnsignedShort();
                        try {
                            Glyph glyph = this.font[n4].chars[n5];
                            glyph.draw(graphics, this.currentColor, n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value), this.fontScale);
                            if (this.currentRef == null) break;
                            this.currentRef.union(glyph.getBBox(n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value), this.fontScale));
                        }
                        catch (NullPointerException nullPointerException) {
                            System.err.println("Font " + n4 + " char " + n5 + " does not exist!");
                        }
                        break;
                    }
                    case 135: {
                        n5 = 0xFF & this.file.read3();
                        try {
                            Glyph glyph = this.font[n4].chars[n5];
                            glyph.draw(graphics, this.currentColor, n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value), this.fontScale);
                            if (this.currentRef == null) break;
                            this.currentRef.union(glyph.getBBox(n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value), this.fontScale));
                        }
                        catch (NullPointerException nullPointerException) {
                            System.err.println("Font " + n4 + " char " + n5 + " does not exist!");
                        }
                        break;
                    }
                    case 136: {
                        n5 = 0xFF & this.file.readInt();
                        try {
                            Glyph glyph = this.font[n4].chars[n5];
                            glyph.draw(graphics, this.currentColor, n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value), this.fontScale);
                            if (this.currentRef == null) break;
                            this.currentRef.union(glyph.getBBox(n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value), this.fontScale));
                        }
                        catch (NullPointerException nullPointerException) {
                            System.err.println("Font " + n4 + " char " + n5 + " does not exist!");
                        }
                        break;
                    }
                    case 137: {
                        int n9;
                        n6 = this.file.readInt();
                        n7 = this.file.readInt();
                        if (!(n6 > 0 & n7 > 0)) break;
                        int n11 = this.toPixels(n7);
                        if (n11 == 0) {
                            n11 = 1;
                        }
                        if ((n9 = this.toPixels(n6)) == 0) {
                            n9 = 1;
                        }
                        graphics.setColor(this.currentColor);
                        graphics.fillRect(n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value - n6), n11, n9);
                        break;
                    }
                    case 139: {
                        page.c0 = this.file.readInt();
                        page.c1 = this.file.readInt();
                        page.c2 = this.file.readInt();
                        page.c3 = this.file.readInt();
                        page.c4 = this.file.readInt();
                        page.c5 = this.file.readInt();
                        page.c6 = this.file.readInt();
                        page.c7 = this.file.readInt();
                        page.c8 = this.file.readInt();
                        page.c9 = this.file.readInt();
                        this.file.readInt();
                        break;
                    }
                    case 141: {
                        intStack.push();
                        intStack2.push();
                        intStack3.push();
                        intStack4.push();
                        intStack5.push();
                        intStack6.push();
                        break;
                    }
                    case 142: {
                        intStack.pop();
                        intStack2.pop();
                        intStack3.pop();
                        intStack4.pop();
                        intStack5.pop();
                        intStack6.pop();
                        break;
                    }
                    case 143: {
                        intStack.value += this.file.readSigned();
                        break;
                    }
                    case 144: {
                        intStack.value += this.file.readSignedShort();
                        break;
                    }
                    case 145: {
                        intStack.value += this.file.readSigned3();
                        break;
                    }
                    case 146: {
                        intStack.value += this.file.readInt();
                        break;
                    }
                    case 147: {
                        intStack.value += intStack3.value;
                        break;
                    }
                    case 148: {
                        intStack3.value = this.file.readSigned();
                        intStack.value += intStack3.value;
                        break;
                    }
                    case 149: {
                        intStack3.value = this.file.readSignedShort();
                        intStack.value += intStack3.value;
                        break;
                    }
                    case 150: {
                        intStack3.value = this.file.readSigned3();
                        intStack.value += intStack3.value;
                        break;
                    }
                    case 151: {
                        intStack3.value = this.file.readInt();
                        intStack.value += intStack3.value;
                        break;
                    }
                    case 152: {
                        intStack.value += intStack4.value;
                        break;
                    }
                    case 153: {
                        intStack4.value = this.file.readSigned();
                        intStack.value += intStack4.value;
                        break;
                    }
                    case 154: {
                        intStack4.value = this.file.readSignedShort();
                        intStack.value += intStack4.value;
                        break;
                    }
                    case 155: {
                        intStack4.value = this.file.readSigned3();
                        intStack.value += intStack4.value;
                        break;
                    }
                    case 156: {
                        intStack4.value = this.file.readInt();
                        intStack.value += intStack4.value;
                        break;
                    }
                    case 157: {
                        intStack2.value += this.file.readSigned();
                        break;
                    }
                    case 158: {
                        intStack2.value += this.file.readSignedShort();
                        break;
                    }
                    case 159: {
                        intStack2.value += this.file.readSigned3();
                        break;
                    }
                    case 160: {
                        intStack2.value += this.file.readInt();
                        break;
                    }
                    case 161: {
                        intStack2.value += intStack5.value;
                        break;
                    }
                    case 162: {
                        intStack5.value = this.file.readSigned();
                        intStack2.value += intStack5.value;
                        break;
                    }
                    case 163: {
                        intStack5.value = this.file.readSignedShort();
                        intStack2.value += intStack5.value;
                        break;
                    }
                    case 164: {
                        intStack5.value = this.file.readSigned3();
                        intStack2.value += intStack5.value;
                        break;
                    }
                    case 165: {
                        intStack5.value = this.file.readInt();
                        intStack2.value += intStack5.value;
                        break;
                    }
                    case 166: {
                        intStack2.value += intStack6.value;
                        break;
                    }
                    case 167: {
                        intStack6.value = this.file.readSigned();
                        intStack2.value += intStack6.value;
                        break;
                    }
                    case 168: {
                        intStack6.value = this.file.readSignedShort();
                        intStack2.value += intStack6.value;
                        break;
                    }
                    case 169: {
                        intStack6.value = this.file.readSigned3();
                        intStack2.value += intStack6.value;
                        break;
                    }
                    case 170: {
                        intStack6.value = this.file.readInt();
                        intStack2.value += intStack6.value;
                        break;
                    }
                    case 235: {
                        n4 = this.file.read();
                        break;
                    }
                    case 236: {
                        n4 = this.file.readUnsignedShort();
                        break;
                    }
                    case 237: {
                        n4 = this.file.read3();
                        break;
                    }
                    case 238: {
                        n4 = this.file.readInt();
                        break;
                    }
                    case 239: {
                        n5 = this.file.read();
                        this.callSpecial(graphics, n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value), new String(this.file.data, this.file.pos, n5), this.file.pos);
                        this.file.pos += n5;
                        break;
                    }
                    case 240: {
                        n5 = this.file.readUnsignedShort();
                        this.callSpecial(graphics, n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value), new String(this.file.data, this.file.pos, n5), this.file.pos);
                        this.file.pos += n5;
                        break;
                    }
                    case 241: {
                        n5 = this.file.read3();
                        this.callSpecial(graphics, n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value), new String(this.file.data, this.file.pos, n5), this.file.pos);
                        this.file.pos += n5;
                        break;
                    }
                    case 242: {
                        n5 = this.file.readInt();
                        this.callSpecial(graphics, n + this.toPixels(intStack.value), n2 + this.toPixels(intStack2.value), new String(this.file.data, this.file.pos, n5), this.file.pos);
                        this.file.pos += n5;
                        break;
                    }
                    case 246: {
                        ++this.file.pos;
                    }
                    case 245: {
                        ++this.file.pos;
                    }
                    case 244: {
                        ++this.file.pos;
                    }
                    case 243: {
                        this.file.pos += 13;
                        n5 = this.file.read();
                        this.file.pos += (n5 += this.file.read());
                        break;
                    }
                    case 247: {
                        System.err.println("found a pre command in page " + page);
                        break;
                    }
                    case 248: {
                        System.err.println("found a post command in page " + page);
                        break;
                    }
                    case 249: {
                        System.err.println("found a post_post command in page " + page);
                        break;
                    }
                    default: {
                        if (n8 > 170 & n8 < 235) {
                            n4 = n8 - 171;
                            break;
                        }
                        System.err.println("Verry strange head " + n8);
                    }
                    case 138: 
                }
            }
            n8 = this.file.read();
        }
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public void setCurrentColor(Color color) {
        this.currentColor = color;
    }

    public void setCurrentRef(HyperRef hyperRef) {
        this.currentRef = hyperRef;
    }

    public void setDpi(int n) {
        this.K = this.document.scale / 2.54 * (double)n / 100000.0;
        this.fontScale = (double)n / (double)this.document.trueDviDpi;
    }

    public void setStackDepth(int n) {
        this.stackDepth = n;
    }

    private int toPixels(int n) {
        return (this.K * (double)n > 0.0 ? 1 : -1) * (int)(Math.abs(this.K * (double)n) + 0.5);
    }
}

