/*
 * Decompiled with CFR 0.152.
 */
package jdvi.font;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import jdvi.font.Bitmap;
import jdvi.font.Bitmap2;
import jdvi.font.NybbleInputStream;

public final class Glyph
implements Serializable {
    public int cc;
    public int tfm;
    public int w;
    public int h;
    public int hoff;
    public int voff;
    public int dm;
    public int dx;
    public int dy = 0;
    public Bitmap bmp;
    public double imScale = 0.0;
    public Color currentColor;
    public transient Image scaledImage;
    public static final boolean BLACK = true;
    public static final boolean WHITE = false;
    private static int repeat_count = 0;
    public static boolean v2 = false;

    public void draw(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.bmp.getImage(), n - this.hoff, n2 - this.voff, null);
    }

    public void draw(Graphics graphics, Color color, int n, int n2, double d) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = null;
        if (rectangle != null) {
            rectangle2 = new Rectangle(n - (int)((double)this.hoff * d + 0.5), n2 - (int)((double)this.voff * d + 0.5), (int)((double)this.w * d + 0.5), (int)((double)this.h * d + 0.5));
        }
        if (rectangle == null || rectangle.intersects(rectangle2)) {
            if (this.imScale != d || color != this.currentColor) {
                if (this.scaledImage != null) {
                    this.scaledImage.flush();
                }
                this.scaledImage = d == 1.0 ? this.bmp.getImage(color) : this.bmp.getScaledImage(this.hoff, this.voff, d, color);
                this.currentColor = color;
                this.imScale = d;
            }
            graphics.drawImage(this.scaledImage, n - (int)((double)this.hoff * d + 1.0), n2 - (int)((double)this.voff * d + 1.0), null);
        }
    }

    protected void finalize() throws Throwable {
        this.flush();
        super.finalize();
    }

    public void flush() {
        this.imScale = -1.0;
        this.scaledImage = null;
    }

    public Rectangle getBBox(int n, int n2, double d) {
        if (d == this.imScale) {
            return new Rectangle(n - (int)((double)this.hoff * d + 0.5), n2 - (int)((double)this.voff * d + 0.5), this.scaledImage.getWidth(null), this.scaledImage.getHeight(null));
        }
        return new Rectangle(n - (int)((double)this.hoff * d + 0.5), n2 - (int)((double)this.voff * d + 0.5), (int)((double)this.w * d + 0.5), (int)((double)this.h * d + 0.5));
    }

    public Image getImage() {
        return this.bmp.getImage();
    }

    private static int packed_num(NybbleInputStream nybbleInputStream, int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        n2 = nybbleInputStream.readNybble();
        if (n2 == 0) {
            do {
                n3 = nybbleInputStream.readNybble();
                ++n2;
            } while (n3 == 0);
            while (n2 > 0) {
                n3 = n3 * 16 + nybbleInputStream.readNybble();
                --n2;
            }
            return n3 - 15 + (13 - n) * 16 + n;
        }
        if (n2 <= n) {
            return n2;
        }
        if (n2 < 14) {
            return (n2 - n - 1) * 16 + nybbleInputStream.readNybble() + n + 1;
        }
        if (repeat_count != 0) {
            System.err.println("Second repeat count!");
        }
        repeat_count = 1;
        if (n2 == 14) {
            repeat_count = Glyph.packed_num(nybbleInputStream, n);
        }
        return Glyph.packed_num(nybbleInputStream, n);
    }

    /*
     * Unable to fully structure code
     */
    public static Glyph readGlyph(NybbleInputStream var0, int var1_1) throws IOException {
        block19: {
            var2_2 = new Glyph();
            if ((var1_1 & 7) > 3) {
                if ((var1_1 & 7) == 7) {
                    var2_2.cc = (int)var0.readUnsignedInt();
                    var2_2.tfm = var0.readInt();
                    var2_2.dx = (int)var0.readUnsignedInt();
                    var2_2.dy = (int)var0.readUnsignedInt();
                    var2_2.w = (int)var0.readUnsignedInt();
                    var2_2.h = (int)var0.readUnsignedInt();
                    var2_2.hoff = var0.readInt();
                    var2_2.voff = var0.readInt();
                    var2_2.dm = var2_2.dx / 65536;
                } else {
                    var2_2.cc = var0.read();
                    var2_2.tfm = var0.read3();
                    var2_2.dm = var0.readUnsignedShort();
                    var2_2.w = var0.readUnsignedShort();
                    var2_2.h = var0.readUnsignedShort();
                    var2_2.hoff = var0.readSignedShort();
                    var2_2.voff = var0.readSignedShort();
                }
            } else {
                var2_2.cc = var0.read();
                var2_2.tfm = var0.read3();
                var2_2.dm = var0.read();
                var2_2.w = var0.read();
                var2_2.h = var0.read();
                var2_2.hoff = (byte)var0.read();
                var2_2.voff = (byte)var0.read();
            }
            var2_2.bmp = Glyph.v2 != false ? new Bitmap2(var2_2.w, var2_2.h) : new Bitmap(var2_2.w, var2_2.h);
            var3_3 = (var1_1 & 8) == 8;
            var5_4 = (var1_1 & 240) / 16;
            var6_5 = 0;
            var7_6 = 0;
            var8_7 = 0;
            var9_8 = 0;
            Glyph.repeat_count = 0;
            var10_9 = var3_3;
            if (var5_4 >= 14) ** GOTO lbl98
            var6_5 = 0;
            var7_6 = 0;
            while (var7_6 < var2_2.h) {
                var4_10 = var2_2.w * var7_6;
                while (var6_5 < var2_2.w) {
                    var8_7 = Glyph.packed_num(var0, var5_4);
                    var10_9 = var3_3;
                    if (var3_3) {
                        var3_3 = false;
                        var9_8 = var6_5;
                        while (var9_8 < (var2_2.w < var6_5 + var8_7 ? var2_2.w : var6_5 + var8_7)) {
                            var2_2.bmp.set(var4_10 + var9_8, var10_9);
                            ++var9_8;
                        }
                    } else {
                        var3_3 = true;
                    }
                    var6_5 += var8_7;
                }
                var8_7 = var6_5 - var2_2.w;
                ++var7_6;
                while (Glyph.repeat_count > 0) {
                    var9_8 = 0;
                    while (var9_8 < var2_2.w) {
                        var2_2.bmp.set(var9_8 + var2_2.w * var7_6, var2_2.bmp.get(var9_8 + var2_2.w * (var7_6 - 1)));
                        ++var9_8;
                    }
                    ++var7_6;
                    --Glyph.repeat_count;
                }
                while (var8_7 > var2_2.w) {
                    var4_10 = var7_6 * var2_2.w;
                    var9_8 = 0;
                    while (var9_8 < var2_2.w) {
                        var2_2.bmp.set(var9_8 + var4_10, var10_9);
                        ++var9_8;
                    }
                    var8_7 -= var2_2.w;
                    ++var7_6;
                }
                var4_10 = var2_2.w * var7_6;
                if (var8_7 > 0 & var3_3 == false) {
                    var9_8 = 0;
                    while (var9_8 < var8_7) {
                        var2_2.bmp.set(var9_8 + var4_10, var10_9);
                        ++var9_8;
                    }
                }
                var6_5 = var8_7;
            }
            break block19;
lbl-1000:
            // 1 sources

            {
                var8_7 = 128;
                var9_8 = var0.read();
                while (var8_7 > 0) {
                    if ((var9_8 & var8_7) != 0) {
                        var2_2.bmp.set(var6_5 + var2_2.w * var7_6, true);
                    }
                    if (++var6_5 == var2_2.w) {
                        var6_5 = 0;
                        ++var7_6;
                    }
                    var8_7 /= 2;
                }
lbl98:
                // 2 sources

                ** while (var7_6 < var2_2.h)
            }
        }
        return var2_2;
    }
}

