/*
 * Decompiled with CFR 0.152.
 */
package jdvi.font;

import java.io.IOException;
import java.io.InputStream;

public final class NybbleInputStream
extends InputStream {
    int nybbleMask;
    InputStream stream;

    public NybbleInputStream(InputStream inputStream) {
        this.stream = inputStream;
    }

    public int available() throws IOException {
        return this.stream.available();
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public synchronized void mark(int n) {
        this.stream.mark(n);
    }

    public boolean markSupported() {
        return this.stream.markSupported();
    }

    public int read() throws IOException {
        this.nybbleMask = 240;
        return this.stream.read();
    }

    public int read3() throws IOException {
        int n = this.read();
        n = n << 8 | this.read();
        n = n << 8 | this.read();
        return n;
    }

    public int read4() throws IOException {
        int n = this.read();
        n = n << 8 | this.read();
        n = n << 8 | this.read();
        n = n << 8 | this.read();
        return n;
    }

    public int readInt() throws IOException {
        int n = this.read();
        n = n << 8 | this.read();
        n = n << 8 | this.read();
        n = n << 8 | this.read();
        return n;
    }

    public int readNybble() throws IOException {
        if (this.nybbleMask > 15) {
            int n = this.stream.read();
            this.nybbleMask = n & 0xF;
            return (n & 0xF0) / 16;
        }
        int n = this.nybbleMask;
        this.nybbleMask = 16;
        return n;
    }

    public int readSigned3() throws IOException {
        int n = this.read();
        n = n << 8 | this.read();
        n = n << 8 | this.read();
        return n;
    }

    public short readSignedShort() throws IOException {
        int n = this.read();
        n = n << 8 | this.read();
        return (short)n;
    }

    public long readUnsignedInt() throws IOException {
        long l = this.read();
        l = l << 8 | (long)this.read();
        l = l << 8 | (long)this.read();
        l = l << 8 | (long)this.read();
        return l;
    }

    public int readUnsignedShort() throws IOException {
        int n = this.read();
        n = n << 8 | this.read();
        return n;
    }

    public synchronized void reset() throws IOException {
        this.stream.reset();
    }
}

