(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6592,        216]*)
(*NotebookOutlinePosition[      9809,        307]*)
(*  CellTagsIndexPosition[      9716,        300]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Events from a ",
  StyleBox["JavaView",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " Slider\n",
  StyleBox["\tby Konrad Polthier",
    FontSize->16]
}], "Chapter",
  CellGroupingRules->"SectionGrouping",
  TextAlignment->Left],

Cell[TextData[{
  "When the JavaView display is opened, drag the slider to modify the radius \
of the torus. The update events of the slider are caught by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to recompute the radius of the torus immediately."
}], "Text"],

Cell["\<\
This notebook demonstrates the update listener class \
\"jvx.math.MathUpdateListener\" of JavaView. This listener operates \
asynchronously by starting another thread for the event handling. This avoids \
delays during the rotation and user perceiption of the ongoing event \
handling.\
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Load Java runtime into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and load JavaView."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\n", 
    \(\(viewer = InstallJavaView[];\)\)}], "Input",
  CellLabel->"In[1]:="],

Cell["\<\
Get the active JavaView 3d-display to show a sample geometry.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(disp = viewer@getDisplay[];\)\)], "Input",
  CellLabel->"In[3]:="],

Cell["Create a sample geometry.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(geom\  = \ 
        JavaNew["\<jv.geom.PgElementSet\>", 3];\)\), "\[IndentingNewLine]", 
    \(\(geom@setName["\<Dynamic Torus\>"];\)\), "\[IndentingNewLine]", 
    \(\(geom@computeTorus[10, 10, 2. , 1. ];\)\)}], "Input",
  CellLabel->"In[4]:="],

Cell["Show sample geometry in JavaView display.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(JavaView[geom]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "jv.geom.PgElementSet"] \[RightGuillemet]\),
      JLink`Objects`JavaObject87818241]], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell[TextData[{
  "Show the slider panel directly inside the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display. Alternatively, a another frame could be created to contain the \
slider."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell["\<\
slider = JavaNew[\"jv.number.PuInteger\", \"Radius\", Null];
sliderIP = slider@getInfoPanel[];
frame = disp@getFrame[];
frame@add[\"South\", sliderIP];
frame@validate[];\
\>", "Input",
  CellLabel->"In[8]:=",
  PageWidth->WindowWidth,
  ShowSpecialCharacters->False],

Cell["\<\
This function will be called when the slider is modified. The argument evt is \
the slider object which is then queried for its current value. Here we \
interpret the value as radius of a torus geometry. When the torus is \
recomputed, the method geom@update[geom] ensure that the display and other \
panels depending on the torus are updated.
Replace the bottom of this method with your own calculations.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    RowBox[{
      StyleBox[\(evalSlider[evt_, message_]\),
        "InlineInput"], 
      StyleBox[":=",
        "InlineInput"], 
      StyleBox["\[IndentingNewLine]",
        "InlineInput"], 
      StyleBox["\t",
        "InlineInput"], 
      RowBox[{
        StyleBox["JavaBlock",
          "InlineInput"], 
        StyleBox["[",
          "InlineInput"], 
        StyleBox["\[IndentingNewLine]",
          "InlineInput"], "\t\t", 
        StyleBox[\(\(val = evt@getValue[];\)\[IndentingNewLine]
          \t\t\(geom@computeTorus[10, 10, val, 1. ];\)\[IndentingNewLine]
          \t\t\(geom@update[geom];\)\[IndentingNewLine]
          \t\tReleaseObject[evt]\),
          "InlineInput"], 
        StyleBox["\[IndentingNewLine]",
          "InlineInput"], 
        StyleBox["\t",
          "InlineInput"], 
        StyleBox["]",
          "InlineInput"]}]}]], "Input",
  CellLabel->"In[13]:="],

Cell["Register a listener of update events of the slider.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(listener = 
        JavaNew["\<jvx.math.MathUpdateListener\>"];\)\), \
"\[IndentingNewLine]", 
    \(\(listener@
        setHandler["\<update\>", "\<evalSlider\>"];\)\), \
"\[IndentingNewLine]", 
    \(\(slider@addUpdateListener[listener];\)\)}], "Input",
  CellLabel->"In[14]:="],

Cell["\<\
Share the kernel to allow further interaction with the slider and display. \
After this call, change the value of the slider and see the torus changing in \
size.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(ShareKernel[]\)], "Input",
  CellLabel->"In[17]:="],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[17]="]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 723}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{703, 686},
WindowMargins->{{138, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {"Konrad Polthier"}], "PageHeader"]}, {Cell[ 
        TextData[ {"The ", 
          StyleBox[ "JavaView", FontSlant -> "Italic"], " Packages"}], 
        "PageHeader"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}, {Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"PrintingMargins"->{{57.375, 57.375}, {57.375, 57.375}},
"PrintCellBrackets"->True,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FacingPages"->True},
CellLabelAutoDelete->False,
Magnification->1.25,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.1.3"->{
    Cell[2611, 79, 170, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[2912, 92, 123, 3, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3129, 101, 79, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3482, 111, 95, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3887, 127, 249, 7, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4418, 147, 467, 8, 120, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[5801, 187, 105, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6215, 200, 224, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}]},
  "3.5"->{
    Cell[2611, 79, 170, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[2912, 92, 123, 3, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3129, 101, 79, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3482, 111, 95, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3887, 127, 249, 7, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4418, 147, 467, 8, 120, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[5801, 187, 105, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6215, 200, 224, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.1.3", 8356, 262},
  {"3.5", 9029, 279}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 278, 10, 98, "Chapter",
  CellGroupingRules->"SectionGrouping"],
Cell[1998, 61, 276, 6, 48, "Text"],
Cell[2277, 69, 309, 6, 67, "Text"],

Cell[CellGroupData[{
Cell[2611, 79, 170, 6, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[2784, 87, 125, 3, 54, "Input"],
Cell[2912, 92, 123, 3, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[3038, 97, 88, 2, 33, "Input"],
Cell[3129, 101, 79, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[3211, 104, 268, 5, 75, "Input"],
Cell[3482, 111, 95, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[3602, 116, 71, 2, 33, "Input"],
Cell[3676, 120, 196, 4, 27, "Output"]
}, Open  ]],
Cell[3887, 127, 249, 7, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[4139, 136, 276, 9, 128, "Input"],
Cell[4418, 147, 467, 8, 120, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[4888, 157, 910, 28, 159, "Input"],
Cell[5801, 187, 105, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[5909, 190, 303, 8, 75, "Input"],
Cell[6215, 200, 224, 5, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[6442, 207, 71, 2, 33, "Input"],
Cell[6516, 211, 60, 2, 27, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

