#!/usr/bin/perl
use integer;
require 'getopts.pl';
$opt_s = 1;
do Getopts('s:');

print STDOUT "--->makeGifs:\n";
while($line=<STDIN>) {
    if($line=~/PSfile="([a-zA-Z0-9\.\/]*)" llx=([-0-9]*) lly=([-0-9]*) urx=([-0-9]*) ury=([-0-9]*) rwi=([-0-9]*)  dpi=([0-9]*).*/i) {
	$psfile = $1;
	$llx = $2;
	$lly=$3;
	$urx=$4;
	$ury=$5;
	$rwi=$6;
	$dpi=$7/$opt_s;
	#print STDOUT "read $1,$2,$3,$4,$5,$6,$7\n";
	print "--->Make gif for $1...";
	$pstrans = "$llx neg $lly neg translate";
	$1=~/([a-zA-Z0-9\.\/]*)(\.ps|\.eps)/i;
	$ppmname=$1.".ppm";
	$gifname=$1.".gif";
	
	if(!(-e $gifname)) {   # do nothing if the gif file already exists.
	    
	    $xsize=($urx - $llx) * $dpi/72;
	    $ysize=($ury - $lly) * $dpi/72;
	    
	    system "echo $pstrans > tmp.perl.tmp";
	    system "cat $psfile >> tmp.perl.tmp";
	    system "echo \"showpage\n\n\" >> tmp.perl.tmp";
	    system "echo \"\" |gs -sDEVICE=ppm -sOutputFile=$ppmname -g${xsize}x${ysize} -r${dpi}x${dpi} -q -dBATCH - tmp.perl.tmp";
	    system "rm tmp.perl.tmp";
	    system "ppmtogif $ppmname > $gifname";
	    system "rm $ppmname";

	    #exec "echo $pstrans `cat $psfile` \"\n showpage \n quit\n\"";

	    print STDOUT "write $gifname\n";
	}
	else {
	    print "nothing to do.\n";
	}
    } else {
	#print STDOUT "no match";
	print STDOUT "$line";
    }
}

print STDOUT "makeGifs done\n";
#PSfile="flower2.ps" llx=0 lly=0 urx=299 ury=138 rwi=2990  dpi=300
#PSfile="./curveCMC/elemDual.ps" llx=0 lly=0 urx=449 ury=110 rwi=4490  dpi=300
