################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version 0.94A from 4/09/01. You can find more information at 
#       http://www.zpr.uni-koeln.de/CATBox
#
#	file:   FordFulkerson.pro
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#
#       Copyright (C) 1998-2000, ZAIK/ZPR, Universitt zu Kln
#       
#       All rights reserved. Do not distribute
#	
#
#       This file is version $Revision: 1.12 $ 
#                       from $Date: 2000/09/14 15:11:54 $
#             last change by $Author: pattberg $.
#
#
################################################################################

#### Options #################################################

breakpoints = [24,28]
interactive = [16,17]
graphDisplays = 2
about = """<HTML>
<HEAD>
<TITLE>Maximal Flow - FordFulkerson</TITLE>
</HEAD>
<body>
<b>Name:</b>
<br>Ford-Fulkerson Maximum Flow / Minimum Cut Algorithm
<p><b>Purpose:</b>
<br>Calculates a maximum flow from node s to node t
<p><b>Description:</b>
<br>The algorithm increases the flow by finding augmenting paths. It displays the residual network after each step.
Also, a minimum cut is shown at the end.
<p><b>Prerequisites:</b>
<br>Capacitated, directed graph
<p><b>Legend:</b></p>
Edges
<ul>
<li><IMG SRC="Icons/black.gif" HEIGHT=10 WIDTH=30 ALIGN=MIDDLE> Edge without flow</li>
<li><IMG SRC="Icons/bledge.gif" HEIGHT=10 WIDTH=30 ALIGN=MIDDLE> Edge with flow</li>
</ul>
Edges (Residual Graph)
<ul>
<li><IMG SRC="Icons/red.gif" HEIGHT=10 WIDTH=30 ALIGN=MIDDLE> Shortest Path</li>
</ul>
<p><br><b>Reference:</b>
<br>CATBox Book, page _CATBOXBOOK_
</body>
</HTML>
"""

#### Wrapper #################################################


class BlinkingEdges(BlinkingContainerWrapper):

    def __init__(self, theAnimator, l):
	BlinkingContainerWrapper.__init__(self, theAnimator, l, "black")

    def __getitem__(self, i):
	if i < len(self.list):
	    item = self.list[i]
            self.Animator.BlinkEdge(item[0],item[1],"gray")
 	    return item
        else:
            raise IndexError

#### Graph management ########################################

import copy
R = copy.deepcopy(G)
self.OpenSecondaryGraph(R, stripPath(self.graphFileName) + " (residual)",
			WeightedGraphInformer(R,"residual capacity"))
RA = self.GUI.secondaryGraphDisplay
G.CalculateWidthFromWeight(0.7)
A.ShowGraph(G, stripPath(self.graphFileName))

#### Variables ###############################################

s       = 1         # first vertex is source
t       = G.Order() # last vertex is sink
true    = 1
maximal = 0
flow   = FlowWrapper(G,A,R,RA,G.edgeWeights[0],R.edgeWeights[0])

cap         = lambda e: flow.cap[e]
res         = lambda e: flow.res[e]
ForwardEdge = lambda u,v,g=G: g.QEdge(u,v)

def pickCallback(A,RA,v,type):

    if type == "s":
        A.SetVertexAnnotation(v,type,"green")
        flow.excess[v] = gInfinity        
        RA.SetVertexColor(v,"green")
    else:
        A.SetVertexAnnotation(v,type,"red")
        flow.excess[v] = -gInfinity
        RA.SetVertexColor(v,"red")
    return

pickCallbackSource = lambda v, type="s", a=A,ra=RA: pickCallback(a,ra,v,type)
PickSource         = lambda f=pickCallbackSource: self.PickVertex(1,None,f)
pickCallbackSink   = lambda v, type="t", a=A,ra=RA: pickCallback(a,ra,v,type)
PickSink           = lambda f=pickCallbackSink: self.PickVertex(G.Order(),None,f)

#### Internal functions ######################################

def _MinResCap(Path, R, RA):
    min = gInfinity
    u   = 0
    v   = 0
    for i in Path:
        if res(i) < min:
            min = res(i)
            u = i[0]
            v = i[1]

    RA.SetEdgeColor(u,v,"#FFAAAA") # Light the cheapest edge

    if R.edgeWeights[0].QInteger():
        RA.graphInformer.SetDefaultInfo("delta = %d"%min)
        RA.UpdateInfo("delta = %d"%min)
    else:
        RA.graphInformer.SetDefaultInfo("delta = %f"%min)
        RA.UpdateInfo("delta = %f"%min)

    return min


def _ShowCut(A,R,s):
    Q = Queue() # Component S of s is green, component T of t is red 
    C = [s]     # edges between S and T are yellow

    pred = {}
    for v in R.vertices:
	pred[v] = None	
    Q.Append(s)

    while Q.IsNotEmpty():
	v = Q.Top()
	for w in R.Neighborhood(v):
	    if pred[w] == None and w != s:
		pred[w] = v
		Q.Append(w)
		C.append(w)

    A.SetAllVerticesColor("red")

    for v in C:
        A.SetVertexColor(v,"green")
	for w in G.Neighborhood(v):
	    if not w in C:
		A.SetEdgeColor(v,w,"yellow")

    return None

#### Lambdas #################################################

ShortestPath    = lambda s,t,r=R,ra=RA:shortestPath(r,ra,s,t)
Neighborhood    = lambda v,r=R: r.Neighborhood(v)
ShowCut         = lambda s,a=A,r=R: _ShowCut(a,r,s)
MinResCap       = lambda p,ra=RA,r=R: _MinResCap(p,r,ra)
Edges           = lambda r, ra=RA: BlinkingEdges(ra,r)

#### Internal initialisation #################################

A.SetAllVerticesColor("grey")
RA.SetAllVerticesColor("grey")

A.RegisterGraphInformer(FlowGraphInformer(G,flow))
RA.RegisterGraphInformer(ResidualGraphInformer(R,flow))
