(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    103379,       3123]*)
(*NotebookOutlinePosition[    120274,       3532]*)
(*  CellTagsIndexPosition[    119936,       3518]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "The ",
  StyleBox["JavaView",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " Packages for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\n",
  StyleBox["\tby Konrad Polthier\n\t",
    FontSize->16],
  StyleBox["(User's Guide, Draft 0.9, 22.04.01)",
    FontSize->16,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Chapter",
  CellGroupingRules->"SectionGrouping",
  TextAlignment->Left],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " is an interactive geometry viewer and a visualization toolkit. Its main \
focus is to supply visualization tools simultaneously for local applications \
as well as interactive online publications. These notes describe how to use \
",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " as a viewer for ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "graphics either as an external viewer using the JavaView`RunThrough` \
package, or fully integrated with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " via J/Link using the JavaView`JLink` package."
}], "Text"],

Cell[TextData[{
  "J/Link is a recent development of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by Todd Gayley allowing realtime interaction between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and Java programs. It is a great achievement for the seemless integration \
of mathematical software, and I am very excited about the diversity of its \
applications."
}], "Text"],

Cell[TextData[{
  "The two ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " packages JavaView`RunThrough` and JavaView`JLink` extend ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with interactive 3D visualization functionality and the integration of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics into online publications. The main focus here lies on the \
package JavaView`JLink` which provides two simple commands for viewing \
graphics by making use of the 2-way connection between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " provided by J/Link. The simpler package JavaView`RunThrough` has utility \
commands to export and view ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics in the classical way via files; it does not need a J/Link \
installation."
}], "Text"],

Cell[TextData[{
  "Note, the commands in both packages are provided as a convenience to \
simplify calling ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  ". For example, experts may directly access the ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " classes and methods using J/Link as described in more detail in the \
notebook ",
  ButtonBox["Applications.nb",
    ButtonData:>{"Applications.nb", None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell[TextData[{
  "These tutorial paragraphs are user's notes and provide the first steps to \
use ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " as 3D viewer of ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "graphics. The basic ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " keyboard shortcuts are listed at the end of this document."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Requirements", "Section"],

Cell[TextData[{
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " requires a Java runtime that is version 1.1 or later. Microsoft Windows \
95/98/NT/2000 users usually have a valid Java 1.1 installation if they use \
Internet Explorer 4.01 or later. Apple Macintosh users must have the \
Macintosh Java Runtime 2.1, but preferrable the very latest release. \nThe ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " package ",
  StyleBox["JavaView`RunThrough`",
    FontWeight->"Bold"],
  " runs with any standard installation of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3.0 and later (we have not tested earlier versions). ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " is invoked with the command RunJavaView[g]. This package does not need to \
install J/Link.\nThe ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " package ",
  StyleBox["JavaView`JLink`",
    FontWeight->"Bold"],
  " integrates ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " with ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "using J/Link. This package requires ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0 and J/Link to be installed. Note, the J/Link manual says that J/Link \
also works fine with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3.0 but it is not officially supported. J/Link is an add-on package \
available for free at ",
  ButtonBox["http://www.wolfram.com",
    ButtonData:>{"www.wolfram.com", None},
    ButtonStyle->"Hyperlink"],
  " and must be installed in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installation. The newest version of ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " can always be obtained from ",
  ButtonBox["http://www.wolfram.com/solutions/mathlink/jlink",
    ButtonData:>{
      URL[ "http://www.wolfram.com/solutions/mathlink/jlink"], None},
    ButtonStyle->"Hyperlink"],
  ". J/Link requires the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " files which are part of the official ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distribution. Microsoft Windows 95/98/NT/2000 users require the MathLink \
files that are included with Mathematica 4 or later. Users with Mathematica \
3.0 should contact the J/Link manual for additional instructions."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Installing ",
  StyleBox["JavaView",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]]
}], "Section"],

Cell[TextData[{
  "The ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " base system consists of two Java archives javaview.jar and jvx.jar which \
must be downloaded from the homepage ",
  ButtonBox["http://www.javaview.de",
    ButtonData:>{"www.javaview.de", None},
    ButtonStyle->"Hyperlink"],
  " and made accessible to the Java runtime. Optionally, some models, \
localization files, and a tutorial directory with source code for Java \
programming may be downloaded."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Installation of ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " archives for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ":"
}], "MathCaption"],

Cell["1. Goto http://www.javaview.de/.", "NumberedEquation"],

Cell["2. Goto menu \"Download\".", "NumberedEquation"],

Cell["\<\
3. Download the archive \"jv_math.zip\" to a temporary place, say c:\\tmp.\
\>", "NumberedEquation"],

Cell["\<\
4. Uncompress the archive to a new directory of your choice, say c:\\tmp. \
This will generate a new directory c:\\tmp\\JavaView.\
\>", "NumberedEquation"],

Cell[TextData[{
  "5. Move the whole directory c:\\tmp\\JavaView to <path to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dir>\\AddOns\\Applications."
}], "NumberedEquation"],

Cell[TextData[{
  "The directory <path to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dir>\\AddOns\\Applications\\JavaView\\Java will then contain the",
  StyleBox[" ",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " jar-archives. J/Link will locate the",
  StyleBox[" ",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " jar-archives automatically, i.e. there is no need to worry about \
classpath settings as long as J/Link is used."
}], "Text"]
}, Open  ]],

Cell[TextData[{
  "Note on uncompression: on MS Windows you may use the program ",
  StyleBox["winzip",
    FontSlant->"Italic"],
  ". On Unix, use the shell command \"unzip -U javaview.zip\" where the \
argument -U ensures that decompression works case sensitive on file names."
}], "Text"],

Cell[TextData[{
  "Note, there exists an optional tiny lite version ",
  StyleBox["jvLite",
    FontSlant->"Italic"],
  " of ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " which is optimized for fast startup and small size (about 90KB). This \
version includes the viewer, animations and a number of file loaders such as \
a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " viewer, but it does not include the control window, dialogs, or more \
sophisticated geometry classes. ",
  StyleBox["jvLite",
    FontSlant->"Italic"],
  " is intended to run as applet in Html pages showing precomputed geometries \
inside web pages. For example, ",
  StyleBox["jvLite",
    FontSlant->"Italic"],
  " is used in the digital journal ",
  StyleBox["Electronic Geometry Models",
    FontSlant->"Italic"],
  " at http://www.eg-models.de/."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Additional Note when running ",
    FontWeight->"Bold"],
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  StyleBox[" via RunThrough",
    FontWeight->"Bold"]
}], "Subsection"],

Cell[TextData[{
  "The package JavaView`RunThrough` runs ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " without J/Link by invoking an executable file \"javaview\". This can be \
accomplished in different ways:"
}], "Text"],

Cell[TextData[{
  "As the preferred way on MS Windows, we provide an executable version \
javaview.exe for windows computers which can be downloaded in a separate \
archive. Move this executable in your path, for example, by copying it into \
the windows directory (c:\\windows or c:\\winnt). Then ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " may be invoked either from the DOS prompt to view models, or from inside \
",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "using RunJavaView[g], or ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " may be associated with geometry file extensions such as *.mgs using the \
Windows file association mechanism."
}], "Text"],

Cell[TextData[{
  "An alternative method is the usage of a shell skript or batch file called \
\"javaview\" or \"javaview.bat\". Either file must be in the path such that \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is able to find and launch ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " from within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Sample skript and batch files are provided in <path to JavaView \
dir>\\bin both for Unix and MS Windows. Further, you need to edit the \
classpath in these files such that the ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " archives are found by the virtual machine."
}], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Using JavaView`RunThrough`", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can launch external programs using the RunThrough[] command and feed them \
with data via the pipe mechanism. For example, this allows to launch the ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " executable respectively the ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " shell command and pass a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics object or animation to ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  ". ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " then starts reading the data from stdin."
}], "Text",
  CellTags->{"S2.1.3", "3.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["RunJavaView",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox["g",
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
            "invoke", " ", "JavaView", " ", "as", " ", "external", " ", 
              "program", " ", "to", " ", "view", " ", "a", " ", "Mathematica",
               " ", 
              RowBox[{"graphics", "."}]}]},
          {
            RowBox[{
              StyleBox["RunJavaView",
                FontFamily->"Courier"], 
              StyleBox["[",
                FontFamily->"Courier"], 
              RowBox[{"{", 
                RowBox[{"g1", ",", " ", "g2", ",", " ", "..."}], " ", "}"}], 
              StyleBox["]",
                FontFamily->"Courier"]}], 
            RowBox[{
            "invoke", " ", "JavaView", " ", "as", " ", "external", " ", 
              "program", " ", "to", " ", "view", " ", "several", " ", 
              "Mathematica", " ", "graphics", " ", 
              RowBox[{"together", "."}]}]},
          {
            RowBox[{
              StyleBox["RunJavaView",
                FontFamily->"Courier"], 
              StyleBox["[",
                FontFamily->"Courier"], 
              StyleBox[
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"g1", ",", " ", "g2", ",", " ", "..."}], " ", 
                    "}"}], ",", " ", 
                  RowBox[{"Animate", "->", "True"}]}],
                FontSlant->"Italic"], 
              StyleBox["]",
                FontFamily->"Courier",
                FontSlant->"Italic"]}], 
            RowBox[{
              RowBox[{
              "invoke", " ", "JavaView", " ", "as", " ", "external", " ", 
                "program", " ", "to", " ", "view", " ", "an", " ", 
                "animation", " ", "with", " ", "the", " ", "keyframes", " ", 
                StyleBox["g1",
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontSlant->"Italic"], 
              StyleBox[
                RowBox[{
                  RowBox[{"g2", " ", "..."}], " ", "."}],
                FontSlant->"Italic"]}]},
          {
            RowBox[{
              StyleBox["WriteMgs",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{"g", ",", " ", "file"}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
              "save", " ", "a", " ", "Mathematica", " ", "graphics", " ", 
                "to", " ", "a", " ", "file", " ", "on", " ", "the", " ", 
                "local", " ", "hard", " ", 
                RowBox[{"disc", "."}]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["WriteMgs",
                FontFamily->"Courier"], 
              StyleBox["[",
                FontFamily->"Courier"], 
              StyleBox[
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"g1", ",", " ", "g2", ",", " ", "..."}], " ", 
                    "}"}], ",", " ", "file"}],
                FontSlant->"Italic"], 
              StyleBox["]",
                FontFamily->"Courier"]}], 
            RowBox[{
            "save", " ", "several", " ", "graphics", " ", "to", " ", "one", 
              " ", "file", " ", "on", " ", "the", " ", "local", " ", "hard", 
              " ", 
              RowBox[{"disc", "."}]}]},
          {
            RowBox[{
              StyleBox["WriteAnim",
                FontFamily->"Courier"], 
              StyleBox["[",
                FontFamily->"Courier"], 
              StyleBox[
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"g1", ",", " ", "g2", ",", " ", "..."}], " ", 
                    "}"}], ",", " ", "file"}],
                FontSlant->"Italic"], 
              StyleBox["]",
                FontFamily->"Courier",
                FontColor->GrayLevel[0]]}], 
            RowBox[{
            "save", " ", "a", " ", "list", " ", "of", " ", "graphics", " ", 
              "as", " ", "animation", " ", "keyframes", " ", "to", " ", "a", 
              " ", "file", " ", "on", " ", "the", " ", "local", " ", "hard", 
              " ", 
              RowBox[{"disc", "."}]}]},
          {
            RowBox[{
              StyleBox["WriteHtml",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                RowBox[{"g", ",", " ", "file"}],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
              "create", " ", "an", " ", "Html", " ", "page", " ", "which", 
                " ", "displays", " ", "the", " ", "Mathematica", " ", 
                "graphics", " ", "in", " ", "a", " ", "JavaView", " ", 
                RowBox[{"applet", "."}]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["FormatGraphics",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["g",
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
            "internal", " ", "helper", " ", "routine", " ", "to", " ", 
              "format", " ", "a", " ", "Mathematica", " ", "graphics", " ", 
              "into", " ", "a", " ", 
              RowBox[{"string", "."}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}},
  CellTags->{"Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],

Cell[TextData[{
  "Invoking ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " via RunThrough."
}], "Caption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[TextData[{
  "A drawback of using RunThrough is the missing feedback ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is able to obtain from user interaction in ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  ". Further, on some operating systems the RunThrough[] command blocks the \
kernel until ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " exists.\nWe provide the RunThrough mechanism because of its simplicity \
but encourage advanced users to use our J/Link-based package JavaView`JLink`. \
The commands in the package JavaView`RunThrough` are available in the package \
JavaView`JLink` too."
}], "Text",
  CellTags->{"S2.1.3", "3.4"}],

Cell["Load the package JavaView`RunThrough`. ", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    RowBox[{"<<", "JavaView`RunThrough`"}]], "Input",
  CellLabel->"In[1]:="],

Cell["Show a sample dodecahedron in a JavaView display. ", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    RowBox[{"<<", "Graphics`Polyhedra`"}], "\n", 
    RowBox[{
      RowBox[{"dode", "=", " ", 
        RowBox[{"Graphics3D", "[", 
          RowBox[{"Dodecahedron", "[", "]"}], "]"}]}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{"RunJavaView", "[", "dode", "]"}]}], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Notation:S4", "Notation:S4.3"}],

Cell["Show a sample animation in a JavaView display. ", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    RowBox[{"anim", " ", "=", " ", 
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
          RowBox[{"ParametricPlot3D", "[", 
            RowBox[{
              RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      RowBox[{"Cos", "[", "t", "]"}], "*", 
                      RowBox[{"Cos", "[", "x", "]"}], "*", 
                      RowBox[{"Cosh", "[", "y", "]"}]}], "+", 
                    RowBox[{
                      RowBox[{"Sin", "[", "t", "]"}], "*", 
                      RowBox[{"Sin", "[", "x", "]"}], "*", 
                      RowBox[{"Sinh", "[", "y", "]"}]}]}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{
                    RowBox[{
                      RowBox[{"-", 
                        RowBox[{"Cos", "[", "t", "]"}]}], "*", 
                      RowBox[{"Sin", "[", "x", "]"}], "*", 
                      RowBox[{"Cosh", "[", "y", "]"}]}], "+", 
                    RowBox[{
                      RowBox[{"Sin", "[", "t", "]"}], "*", 
                      RowBox[{"Cos", "[", "x", "]"}], "*", 
                      RowBox[{"Sinh", "[", "y", "]"}]}]}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{
                    RowBox[{
                      RowBox[{"Cos", "[", "t", "]"}], "*", "y"}], "+", 
                    RowBox[{
                      RowBox[{"Sin", "[", "t", "]"}], "*", "x"}]}]}], "}"}], 
              ",", 
              RowBox[{"{", 
                RowBox[{"x", ",", 
                  RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
              RowBox[{"{", 
                RowBox[{"y", ",", 
                  RowBox[{
                    RowBox[{"-", "Pi"}], "/", "2"}], ",", 
                  RowBox[{"Pi", "/", "2"}]}], "}"}], ",", "\n", "\t\t", 
              RowBox[{"AspectRatio", "->", "Automatic"}], ",", " ", 
              RowBox[{"Axes", "\[Rule]", "None"}], ",", 
              RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
              RowBox[{"PlotPoints", " ", "->", " ", 
                RowBox[{"{", 
                  RowBox[{"13", ",", "7"}], "}"}]}], ",", "\n", "\t\t", 
              RowBox[{"PlotRange", "->", 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"{", 
                      RowBox[{
                        RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}], ",", 
                    RowBox[{"{", 
                      RowBox[{
                        RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}], ",", 
                    RowBox[{"{", 
                      RowBox[{
                        RowBox[{"-", "4."}], ",", "4."}], "}"}]}], "}"}]}]}], 
            "]"}], ",", 
          RowBox[{"{", 
            RowBox[{"t", ",", "0.", ",", 
              RowBox[{"Pi", "/", "2."}], ",", 
              RowBox[{"Pi", "/", "12."}]}], "}"}]}], 
        "]"}]}], "\[IndentingNewLine]", 
    RowBox[{"RunJavaView", "[", 
      RowBox[{"anim", ",", 
        RowBox[{"Animatable", "\[Rule]", "True"}]}], "]"}]}], "Input",
  CellLabel->"In[2]:="],

Cell[CellGroupData[{

Cell["Command RunJavaView[g]", "Subsection"],

Cell[TextData[{
  "The command RunJavaView[g] launches",
  StyleBox[" ",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " to display a Mathematica graphics object. The graphics object may be of \
type Graphics, Graphics3D, SurfaceGraphics, and others. \nRunJavaView[g] \
invokes the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command RunThrough[] which launches \"javaview\" as external process. \
Therefore, on windows the executable 'javaview.exe', respectively, on Unix \
the shell file 'javaview' must be in the path such that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is able to find it. Further, the command RunJavaView[] converts a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics into InputForm and replaces the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " specific floating point representation of numbers with conventional C \
form to simplify the parsing process in ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  ".\nOn some operating systems, this command blocks further execution of the \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel until ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " exits. In this case, during the life time of the ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " process the kernel is waiting for ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " to exit."
}], "Text"],

Cell[TextData[{
  "Create a sample ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics and invoke ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " for display. "
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"g", " ", "=", " ", 
        RowBox[{"Plot3D", "[", 
          RowBox[{
            RowBox[{"Sin", "[", 
              RowBox[{"x", "*", " ", "y"}], "]"}], ",", " ", 
            RowBox[{"{", 
              RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", " ", 
            RowBox[{"{", 
              RowBox[{"y", ",", " ", "0", ",", "Pi"}], "}"}]}], "]"}]}], 
      ";"}]], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"Notation:S4", "Notation:S4.3"}],

Cell[BoxData[
    RowBox[{"RunJavaView", "[", "g", "]"}]], "Input",
  CellLabel->"In[8]:="],

Cell[TextData[{
  "Experts may directly use the RunThrough[] command but should ensure that \
the number representation in the graphics object are correctly formatted. ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " requires data in InputForm."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"RunThrough", "[", 
        RowBox[{"\"\<javaview\>\"", ",", 
          RowBox[{"InputForm", "[", 
            RowBox[{
              RowBox[{"N", "[", "g", "]"}], "/.", 
              RowBox[{"x_Real", "\[RuleDelayed]", 
                RowBox[{"CForm", "[", 
                  RowBox[{"Chop", "[", "x", "]"}], "]"}]}]}], "]"}]}], "]"}], 
      ";"}]], "Input",
  CellLabel->"In[4]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Command WriteMgs[g, file]", "Subsection"],

Cell[TextData[{
  "WriteMgs[g,file] saves a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics in the given file, which may later be viewed with ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " using the shell command 'javaview file'. The filename may specify a file \
relative to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " or may be an absolute path. The command uses FormatGraphics[g] to convert \
the graphics object into a formatted string.\nThe saved file may later be \
viewed from command line using 'javaview myDode.mgs', loaded into ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " from the import menu, or submitted to a geometry archive such as the \
Electronic Geometry Models at ",
  ButtonBox["http://www.eg-models.de",
    ButtonData:>{
      URL[ "http://www.eg-models.de"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell["\<\
Definition of command WriteMgs[g, file] included in JavaView`RunThrough`. \
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell["\<\
WriteMgs[g_, filename_String] := 
  Module[{strm = OpenWrite[filename, PageWidth -> Infinity]}, 
   WriteString[strm, FormatGraphics[g]]; Close[strm]]\
\>", "Input",
  CellLabel->"In[12]:=",
  Evaluatable->False],

Cell["Saving a sample graphics into an ascii file. ", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    RowBox[{"WriteMgs", "[", 
      RowBox[{"dode", ",", "\"\<myDode.mgs\>\""}], "]"}]], "Input",
  CellLabel->"In[10]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Command WriteAnim[{g1, g2, ... },file]", "Subsection"],

Cell[TextData[{
  "WriteAnim[{g1, g2, ... },file] saves a list of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics in the given file, which may later be viewed with ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " using the shell command 'javaview file'. The filename may specify a file \
relative to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " or may be an absolute path. The command uses FormatGraphics[g] to convert \
the graphics objects into a formatted string.\nThe saved file may later be \
viewed from command line using 'javaview myAnim.mgs', loaded into ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " from the import menu, or submitted to a geometry archive such as the \
Electronic Geometry Models at ",
  ButtonBox["http://www.eg-models.de",
    ButtonData:>{
      URL[ "http://www.eg-models.de"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell["\<\
Definition of command WriteAnim[{g1, g2, ... }] included in \
JavaView`RunThrough`. \
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell["\<\
WriteAnim[g_, filename_String] := 
  Module[{strm = OpenWrite[filename, PageWidth -> Infinity]}, 
   WriteString[strm, \"ShowAnimation[\"]; WriteString[strm, 
     FormatGraphics[g]]; WriteString[strm, \"]\"]; Close[strm]]\
\>", "Input",
  CellLabel->"In[12]:=",
  Evaluatable->False],

Cell["Saving a graphics list as animation into an ascii file. ", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    RowBox[{"WriteAnim", "[", 
      RowBox[{"anim", ",", "\"\<myAnim.mgs\>\""}], "]"}]], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    RowBox[{"testAnim", "=", 
      RowBox[{"Read", "[", "\"\<myAnim.mgs\>\"", "]"}]}]], "Input",
  CellLabel->"In[10]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Command WriteHtml[g,file]", "Subsection"],

Cell[TextData[{
  "WriteHtml[g,file] creates a default Html page showing the Mathematica \
graphics as interactive ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " applet. The method uses FormatGraphics[g] to avoid very long lines which \
are anoying to web designers who postprocess the file. The filename may \
specify a file relative to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " or may be an absolute path.\nNote, the applet contains no codebase \
setting. Either the ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " archives must be included in the classpath or manually added in a \
codebase directive of this applet."
}], "Text"],

Cell[BoxData[
    RowBox[{"WriteHtml", "[", 
      RowBox[{"dode", ",", "\"\<myDode.html\>\""}], "]"}]], "Input",
  CellLabel->"In[11]:="]
}, Open  ]],

Cell[TextData[{
  "The commands presented in this section are rather simple but very \
convenient in the daily use of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " if J/Link is not available, or if no feedback from JavaView is needed. \
The following section gives a glimps of the tight integration J/Link offers \
for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Using JavaView`JLink`", "Section"],

Cell[TextData[{
  "J/Link is a powerful add-on package to enable the tight integration \
between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  ". In this section we introduce two simple commands to easily setup an \
initialial connection, and then explore in more detail the interaction \
possibilities. "
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              RowBox[{"InstallJavaView", "[", "]"}],
              "MR",
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            RowBox[{
              RowBox[{Cell[TextData[{
                  "launch the Java runtime and prepare it for use from ",
                  StyleBox["Mathematica",
                    FontSlant->"Italic"]
                }], "Text",
                  CellTags->"jlug:5.2.2.1"], ".", " ", "Create"}], " ", "a", 
              " ", 
              StyleBox["JavaView",
                FontWeight->"Bold",
                FontSlant->"Italic",
                FontColor->RGBColor[0, 0.250004, 0.500008]], " ", "viewer", 
              " ", "manager", " ", "and", " ", "preload", " ", "some", " ", 
              "static", " ", 
              RowBox[{"classes", "."}]}]},
          {
            StyleBox[
              RowBox[{
                StyleBox["JavaView",
                  "MR",
                  FontSlant->"Plain",
                  FontVariations->{"CompatibilityType"->0}], 
                StyleBox["[",
                  "MR"], 
                StyleBox[
                  FormBox["g",
                    "TraditionalForm"],
                  "TI"], 
                StyleBox["]",
                  "MR"]}],
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            RowBox[{
            "show", " ", "a", " ", "Mathematica", " ", "graphics", " ", "in", 
              " ", "a", " ", 
              StyleBox["JavaView",
                FontWeight->"Bold",
                FontSlant->"Italic",
                FontColor->RGBColor[0, 0.250004, 0.500008]], " ", 
              RowBox[{"display", ".", " ", "The"}], " ", "same", " ", 
              "command", " ", "accepts", " ", 
              StyleBox["JavaView",
                FontWeight->"Bold",
                FontSlant->"Italic",
                FontColor->RGBColor[0, 0.250004, 0.500008]], " ", 
              "geometries", " ", 
              RowBox[{"too", "."}]}]},
          {
            StyleBox[
              RowBox[{
                StyleBox["JavaView",
                  FontFamily->"Courier",
                  FontSlant->"Plain",
                  FontVariations->{"CompatibilityType"->0}], 
                StyleBox["[",
                  FontFamily->"Courier"], 
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{"g1", ",", " ", "g2", ",", " ", "..."}], "}"}],
                  FontSlant->"Italic"], 
                StyleBox["]",
                  FontFamily->"Courier"]}],
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            RowBox[{
            "show", " ", "several", " ", "Mathematica", " ", "graphics", " ", 
              "together", " ", "in", " ", "one", " ", 
              StyleBox["JavaView",
                FontWeight->"Bold",
                FontSlant->"Italic",
                FontColor->RGBColor[0, 0.250004, 0.500008]], " ", 
              RowBox[{"display", "."}]}]},
          {
            RowBox[{
              StyleBox["JavaView",
                FontFamily->"Courier",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontColor->GrayLevel[0],
                FontVariations->{"Underline"->False,
                "StrikeThrough"->False,
                "CompatibilityType"->0}], 
              StyleBox["[",
                FontFamily->"Courier",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontColor->GrayLevel[0],
                FontVariations->{"Underline"->False,
                "StrikeThrough"->False}], 
              StyleBox[
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{"g1", ",", "g2", ",", "..."}], "}"}], ",", 
                  RowBox[{"Animatable", "\[Rule]", "True"}]}],
                FontFamily->"Courier New",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Italic",
                FontColor->GrayLevel[0],
                FontVariations->{"Underline"->False,
                "StrikeThrough"->False}], 
              StyleBox["]",
                FontFamily->"Courier",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontColor->GrayLevel[0],
                FontVariations->{"Underline"->False,
                "StrikeThrough"->False}]}], 
            RowBox[{
              RowBox[{
              "show", " ", "an", " ", "animation", " ", "with", " ", "the", 
                " ", "keyframes", " ", "g1"}], ",", " ", 
              RowBox[{"g2", " ", "in", " ", "a", " ", "JavaView", " ", 
                RowBox[{"display", "."}]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  TextAlignment->Left,
  TextJustification->0,
  GridBoxOptions->{ColumnAlignments->{Right, Left}},
  CellTags->{"Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],

Cell[TextData[{
  "Start ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " using J/Link and display ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics."
}], "Caption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[TextData[{
  "J/Link is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " add-on package which must be loaded before using ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  ". The package JavaView`JLink` loads J/Link with a default configuration. \
If a user wishes to set different options he is free to load and configure \
J/Link before loading ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  ". Loading of JavaView`JLink` does not modify the previous configuration of \
J/Link since the J/Link-command InstallJava[] does nothing on its second and \
later invocations."
}], "Text"],

Cell[TextData[{
  "InstallJavaView[] creates a ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " viewer manager and must be called prior to the first usage of \
JavaView[g]. The command also pre-loads some ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " classes to simplify later access to static methods and constants. Its \
return value is the ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " viewer manager which is an instance of the class jv.viewer.PvViewer, and \
which may be queried, for example, for the current display."
}], "Text"],

Cell[TextData[{
  "Load the JavaView`JLink` package including the J/Link package of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    RowBox[{"<<", "JavaView`JLink`"}]], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Notation:S4", "Notation:S4.3"}],

Cell[TextData[{
  "Launch the Java runtime and prepare it for use with",
  " ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  ". We catch the returned viewer for later use. Subsequent calls will return \
the same viewer instance."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"viewer", " ", "=", " ", 
        RowBox[{"InstallJavaView", "[", "]"}]}], ";"}]], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Notation:S4", "Notation:S4.3"}],

Cell[TextData[{
  "The package JavaView`JLink` automatically loads the package ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " package JLink. By default, the command InstallJavaView[] loads the \
Microsoft Java machine as follows."
}], "Text",
  CellTags->{"S2.1.3", "3.5"}],

Cell["\<\
Needs[\"JLink`\"]
InstallJava[CommandLine->wjview, MicrosoftJava->True];\
\>", "Input",
  CellLabel->"In[1]:=",
  Evaluatable->False],

Cell["\<\
If you intend to use a different virtual machine, for example, Sun Jdk 1.3, \
then use the following command since InstallJavaView[] has the same options \
as JLink`InstallJava[]:\
\>", "Text",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"viewer", " ", "=", " ", 
        RowBox[{"InstallJava", "[", 
          RowBox[{
            RowBox[{"CommandLine", "\[Rule]", "java"}], ",", 
            RowBox[{"MicrosoftJava", "\[Rule]", "False"}]}], "]"}]}], 
      ";"}]], "Input",
  CellLabel->"In[9]:="],

Cell[TextData[{
  "Now we are ready to display the first geometry via the J/Link connection. \
The command JavaView[g] displays a Mathematica graphics g in ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  ". The first invocation of the command JavaView[g] will open a ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " display.\nThe graphics may be of type Graphics, Graphics3D, \
SurfaceGraphics, and others. The Mathematica specific floating point \
representation used in the graphics is replaced with conventional C form to \
simplify the parsing process in ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  ".\nIn contrast to the command 'RunJavaView[g]' discussed in the previous \
section this JLink connection to ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008],
    Background->None],
  " does not block the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel. Instead, it allows a realtime exchange of interactive data."
}], "Text"],

Cell[TextData[{
  "Create a sample geometry and view it in a ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " display."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    RowBox[{"<<", "Graphics`Polyhedra`"}], "\n", 
    RowBox[{
      RowBox[{"dode", "=", " ", 
        RowBox[{"Graphics3D", "[", 
          RowBox[{"Dodecahedron", "[", "]"}], "]"}]}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{"JavaView", "[", "dode", "]"}]}], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"Notation:S4", "Notation:S4.3"}],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        RowBox[{
        "\[LeftGuillemet]JavaObject", "[", "\<\"jv.geom.PgElementSet\"\>", 
          "]"}], "\[RightGuillemet]"}],
      JLink`Objects`JavaObject69140481]], "Output",
  CellLabel->"Out[8]="],

Cell[TextData[{
  "In some sense, the command JavaView may be used instead of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command Show[]."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    RowBox[{"Show", "[", "dode", "]"}]], "Input",
  CellLabel->"In[6]:="],

Cell["Try another sample geometry and modify the camera settings.", \
"MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"g", "=", 
        RowBox[{"Plot3D", "[", 
          RowBox[{
            RowBox[{"Sin", "[", 
              RowBox[{"x", "*", " ", "y"}], "]"}], ",", " ", 
            RowBox[{"{", 
              RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", " ", 
            RowBox[{"{", 
              RowBox[{"y", ",", " ", "0", ",", "Pi"}], "}"}], ",", " ", 
            RowBox[{"ViewCenter", "->", 
              RowBox[{"{", 
                RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", " ", 
            RowBox[{"ViewVertical", "\[Rule]", 
              RowBox[{"{", 
                RowBox[{"1", ",", "0", ",", "0"}], "}"}]}]}], "]"}]}], 
      ";"}]], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    RowBox[{"JavaView", "[", "g", "]"}]], "Input",
  CellLabel->"In[8]:="]
}, Open  ]],

Cell[TextData[{
  "Another invocation of JavaView[g] replaces the previous geometry. This is \
done intentionally to simplify the use of the JavaView[g] command although ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " is able to handle a whole scenery of geometries and animations."
}], "Text"],

Cell[TextData[{
  "View another geometry in ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " which replaces the previous one. This time we catch the returned ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " geometry."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"geom", "=", 
      RowBox[{"JavaView", "[", 
        RowBox[{"Graphics3D", "[", 
          RowBox[{"Icosahedron", "[", "]"}], "]"}], "]"}]}]], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        RowBox[{
        "\[LeftGuillemet]JavaObject", "[", "\<\"jv.geom.PgElementSet\"\>", 
          "]"}], "\[RightGuillemet]"}],
      JLink`Objects`JavaObject89325569]], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " geometry can now be modified from within this notebook. Note, changes to \
a geometry are visible in the display only after sending an update to the \
geometry."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    RowBox[{"geom", "@", 
      RowBox[{"setNumElements", "[", "5", "]"}]}]], "Input",
  CellLabel->"In[7]:="],

Cell["\<\
The geometry has changed in JavaView, but the display still shows the old \
version.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"geom", "@", 
      RowBox[{"getNumElements", "[", "]"}]}]], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData["5"], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell["\<\
Initiate an update of the geometry which will inform all update listeners \
about changes. In effect, the display will redraw the new version of the \
geometry.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"geom", "@", 
      RowBox[{"update", "[", "geom", "]"}]}]], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData["True"], "Output",
  CellLabel->"Out[9]="]
}, Open  ]]
}, Closed]],

Cell[TextData[{
  "Note, the above return value of the command JavaView[] is a real ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " object, and not a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics. The command JavaView[] accepts a ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " geometry as argument too."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"JavaView", "[", "geom", "]"}]], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        RowBox[{
        "\[LeftGuillemet]JavaObject", "[", "\<\"jv.geom.PgElementSet\"\>", 
          "]"}], "\[RightGuillemet]"}],
      JLink`Objects`JavaObject89325569]], "Output",
  CellLabel->"Out[11]="]
}, Open  ]],

Cell[TextData[{
  "The return value of JavaView[g] is the geometry class used in ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  ". The type of the geometry class depends on the source material obtained \
from the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics. Typically the geometry is an instance of jv.geom.PgElementSet \
for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " polygons and other surface primitives or it is an instance of \
jv.geom.PgPolygonSet for lines, circle, etc. The ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " documentation contains information about the functionality of these \
geometry classes and the set of visualization tools operating on them. Using \
J/Link it is now possible to inspect the geometry classes, modify their \
material and appearence in the viewer, change the geometry, or return data to \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["\<\
The syntax of the invocation of Java methods is explained in detail in the \
J/Link manual. For convenience, a summary is included in these note. \
\>", "Text"],

Cell[TextData[{
  "Query the geometry for its combinatorial structure, like number of \
vertices, edges, or elements. The name 'element' is used in ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " for a face similar to the notation in finite element numerics."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"geom", "@", 
      RowBox[{"getNumElements", "[", "]"}]}]], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData["5"], "Output",
  CellLabel->"Out[12]="],

Cell["\<\
Query the geometry for geometric properties like surface area or enclosed \
volume.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"geom", "@", 
      RowBox[{"getVolume", "[", "]"}]}]], "Input",
  CellLabel->"In[13]:="],

Cell[BoxData["1.0300566479164919`"], "Output",
  CellLabel->"Out[13]="]
}, Open  ]],

Cell[TextData[{
  "Modify the appearance and material properties. Note, whenever the geometry \
is changed in ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " by a command from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " then its update method be called to invoke a redraw of the ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " display."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    RowBox[{
      RowBox[{"geom", "@", 
        RowBox[{"showVertices", "[", "True", "]"}]}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{"geom", "@", 
      RowBox[{"update", "[", "geom", "]"}]}]}], "Input",
  CellLabel->"In[14]:="],

Cell[BoxData["True"], "Output",
  CellLabel->"Out[15]="]
}, Open  ]],

Cell["\<\
Change orientation and calculate other geometric data like vertex normals.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    RowBox[{
      RowBox[{"geom", "@", 
        RowBox[{"flipOrientation", "[", "]"}]}], ";"}], "\[IndentingNewLine]",
   
    RowBox[{
      RowBox[{"geom", "@", 
        RowBox[{"makeVertexNormals", "[", "]"}]}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{"geom", "@", 
        RowBox[{"showVertexNormals", "[", "True", "]"}]}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{"geom", "@", 
      RowBox[{"update", "[", "geom", "]"}]}]}], "Input",
  CellLabel->"In[16]:="],

Cell[BoxData["True"], "Output",
  CellLabel->"Out[19]="]
}, Open  ]],

Cell[TextData[{
  "On first sight, the vertex normals do not appear as expected but show up \
as a bunch of vectors at each vertex. The reason is that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lists the vertex coordinates for each polygon separately. Since this may \
be intentionally, ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " keeps this duplicate vertices. In computational mathematics such a \
behaviour is usually avoided since duplicate vertices and edges lead to \
ambiguous neighboorhood relations between adjacent elements and to additional \
degrees of freedom in the numerical mesh."
}], "Text"],

Cell["\<\
The existence of duplicate vertices is easily detected by showing item \
labels, or by keeping the p-key pressed while dragging a vertex in the \
display.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    RowBox[{
      RowBox[{"geom", "@", 
        RowBox[{"showIndices", "[", "True", "]"}]}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{"geom", "@", 
      RowBox[{"update", "[", "geom", "]"}]}]}], "Input",
  CellLabel->"In[20]:="],

Cell[BoxData["True"], "Output",
  CellLabel->"Out[21]="]
}, Open  ]],

Cell[TextData[{
  "Therefore, we provide tools to convert the geometry in a 'good' mesh by \
identifying vertices and building a neighbourhood between adjacent elements. \
Toolbox classes like PwCleanMesh are located in the extension package jvx of \
",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  "."
}], "Text"],

Cell["\<\
Identify vertices whose vertex coordinates are equal (or within a small \
distance). The method returns the number of removed vertices. Note, the \
vertex normals are not refreshed automatically.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    RowBox[{
      RowBox[{"LoadClass", "[", "\"\<jvx.geom.PwCleanMesh\>\"", "]"}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{"PwCleanMesh`identifyVertices", "[", 
      RowBox[{"geom", ",", "0."}], "]"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{"geom", "@", 
        RowBox[{"makeVertexNormals", "[", "]"}]}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{"geom", "@", 
        RowBox[{"update", "[", "geom", "]"}]}], ";"}]}], "Input",
  CellLabel->"In[22]:="],

Cell[BoxData["54"], "Output",
  CellLabel->"Out[23]="]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
  "Some of the commands issued above can also be invoked from the control \
window of ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  ". Click inside a display with the right mouse button and select the item \
'Control Panel' from the popup menu."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["J/Link Basics", "Section"],

Cell["Launching J/Link", "Subsection"],

Cell["\<\
The first step is to load the J/Link package file. If you have installed \
J/Link as described in the Installation chapter of the J/Link manual, you \
will be able to load the package:\
\>", "Text"],

Cell["Load J/Link and launch Java runtime.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    RowBox[{
      RowBox[{"<<", "JLink`"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
        RowBox[{
          RowBox[{"InstallJava", "[", 
            RowBox[{"CommandLine", "->", "\"\<java\>\""}], "]"}], ";"}], " ", 
        "*)"}]}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{"InstallJava", "[", 
        RowBox[{
          RowBox[{"CommandLine", "->", "\"\<wjview\>\""}], ",", " ", 
          RowBox[{"MicrosoftJava", "->", "True"}]}], "]"}], ";"}]}], "Input",
  CellLabel->"In[1]:="],

Cell["\<\
The command InstallJava launches the Java runtime which may be selected by \
providing additional options. Remember, in J/Link version 1.01 the archive \
rmi.zip is required if the Microsoft virtual machine is used.
InstallJava can be called more than once in a session. On every call after \
the first, it does nothing. Thus, it is safe to call InstallJava in any \
program you write, without considering whether the user has already called \
it. Only one Java runtime will ever be in use.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              RowBox[{"<<", "JLink`"}],
              "MR",
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            StyleBox[
              RowBox[{"load", " ", "the", " ", 
                RowBox[{"J", "/", "Link"}], " ", "package"}],
              "Text"]},
          {
            StyleBox[
              RowBox[{"InstallJava", "[", "]"}],
              "MR",
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            StyleBox[
              RowBox[{
                RowBox[{
                "launch", " ", "the", " ", "Java", " ", "runtime", " ", "and",
                   " ", "prepare", " ", "it", " ", "for", " ", "use", " ", 
                  "from"}], "\n", "Mathematica"}],
              "Text"]},
          {
            StyleBox[
              RowBox[{
                StyleBox["UninstallJava",
                  FontFamily->"Courier New",
                  FontSize->12,
                  FontWeight->"Plain",
                  FontSlant->"Plain",
                  FontColor->GrayLevel[0],
                  FontVariations->{"Underline"->False,
                  "StrikeThrough"->False}], "[", "]"}],
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            RowBox[{"quit", " ", "the", " ", "Java", " ", "runtime"}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}},
  CellTags->{"Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],

Cell["Launching J/Link and Java.", "Caption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell["Creating Java Objects", "Subsection"],

Cell["\<\
To instantiate Java objects, use the JavaNew[] function. The first argument \
to JavaNew is the object\[CloseCurlyQuote]s class, specified either as a \
JavaClass expression returned from LoadClass or as a string giving the \
fully-qualified class name (i.e., having the full package prefix with all the \
periods). If you wish to supply any arguments to the \
object\[CloseCurlyQuote]s constructor, they follow as a sequence after the \
class.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              RowBox[{
                StyleBox["JavaNew",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox[
                    FormBox["classname",
                      "TraditionalForm"],
                    "TI"], ",", " ", "arg1", ",", " ", "..."}], 
                StyleBox["]",
                  "MR"]}],
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            RowBox[{
              RowBox[{
              "construct", " ", "a", " ", "new", " ", "object", " ", "of", 
                " ", "the", " ", "specified", " ", "class", " ", "and", " ", 
                "return"}], "\n", 
              RowBox[{"it", " ", "to", " ", "Mathematica"}]}]},
          {
            StyleBox[
              RowBox[{
                StyleBox["LoadClass",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox[
                  FormBox["classname",
                    "TraditionalForm"],
                  "TI"], 
                StyleBox["]",
                  "MR"]}],
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            StyleBox[
              RowBox[{
              "load", " ", "the", " ", "specified", " ", "class", " ", "into",
                 " ", "Java", " ", "and", " ", "Mathematica"}],
              "Text"]},
          {
            StyleBox[
              RowBox[{
                StyleBox["ReleaseObject",
                  FontFamily->"Courier New",
                  FontSize->12,
                  FontWeight->"Plain",
                  FontSlant->"Plain",
                  FontColor->GrayLevel[0],
                  FontVariations->{"Underline"->False,
                  "StrikeThrough"->False}], "[", 
                StyleBox["obj",
                  FontSlant->"Italic"], "]"}],
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            RowBox[{
            "let", " ", "Java", " ", "know", " ", "that", " ", "you", " ", 
              "are", " ", "done", " ", "using", " ", 
              StyleBox["obj",
                FontSlant->"Italic"], " ", "in", " ", "Mathematica"}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}},
  CellTags->{"Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],

Cell["Creating Java classes in Mathematica.", "Caption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[TextData[{
  "Now we create a linear algebra vector in ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " which mainly consists of an array of double values. The initial length of \
the array may be given as constructor argument. Double and integer vectors \
are the base classes used in all geometry classes of ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  "."
}], "Text"],

Cell["Create a new vector with different constructors.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    RowBox[{"vec0", "=", 
      RowBox[{
      "JavaNew", "[", "\"\<jv.vecmath.PdVector\>\"", 
        "]"}]}], "\[IndentingNewLine]", 
    RowBox[{"vec3", "=", 
      RowBox[{"JavaNew", "[", 
        RowBox[{"\"\<jv.vecmath.PdVector\>\"", ",", "3"}], "]"}]}]}], "Input",\

  CellLabel->"In[3]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        RowBox[{
        "\[LeftGuillemet]JavaObject", "[", "\<\"jv.vecmath.PdVector\"\>", 
          "]"}], "\[RightGuillemet]"}],
      JLink`Objects`JavaObject51183617]], "Output",
  CellLabel->"Out[3]="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        RowBox[{
        "\[LeftGuillemet]JavaObject", "[", "\<\"jv.vecmath.PdVector\"\>", 
          "]"}], "\[RightGuillemet]"}],
      JLink`Objects`JavaObject51511297]], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell["We check the length of the return vectors.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    RowBox[{"vec0", "@", 
      RowBox[{"getSize", "[", "]"}]}], "\[IndentingNewLine]", 
    RowBox[{"vec3", "@", 
      RowBox[{"getSize", "[", "]"}]}]}], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData["0"], "Output",
  CellLabel->"Out[5]="],

Cell[BoxData["3"], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[BoxData[
    RowBox[{"vec3", "@", 
      RowBox[{"setEntry", "[", 
        RowBox[{"2", ",", " ", "17."}], "]"}]}]], "Input",
  CellLabel->"In[7]:="],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"vec3", "@", 
      RowBox[{"getEntries", "[", "]"}]}]], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "17.`"}], "}"}]], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  "The return value from JavaNew[] can be considered as a reference to the \
Java object, although it is a strange expression internally that will be \
referred to as JavaObject expression. JavaNew[] is not the only way to get a \
reference to a Java object in Mathematica. Many methods and fields return \
objects. Such objects can be used in the same way as ones you explicitly \
construct with ",
  StyleBox["JavaNew",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  "."
}], "Text"],

Cell["Naming Conventions", "Subsection"],

Cell[TextData[{
  "J/Link strictly follows the rules of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming language. This has certain implications how Java is \
accessed."
}], "Text"],

Cell["\<\
Access to public fields and methods follows the same rules as in Java with a \
slight difference in notation. Instead of '.' J/Link uses '@' for non-static \
respectively '`' for static fields and methods. Further, argument brackets [] \
are used instead of ().\
\>", "Text"],

Cell["\<\
Note, there is an issue with underscores used in method and variable names. \
They must be replaced by a capital 'U' unless the name appears inside of a \
string.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["Java",
              "MR",
              FontVariations->{"Underline"->True}], 
            StyleBox["Mathematica",
              FontVariations->{"Underline"->True}]},
          {
            StyleBox[
              RowBox[{
                RowBox[{
                  RowBox[{"obj", ".", "methodName"}], 
                  RowBox[{"(", "args", ")"}]}], ";"}],
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            StyleBox[
              RowBox[{
                RowBox[{"obj", "@", 
                  RowBox[{"methodName", "[", "args", "]"}]}], ";"}],
              "Text",
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}]},
          {
            StyleBox[
              RowBox[{
                RowBox[{
                  RowBox[{"MyClass", ".", "staticMethod"}], 
                  RowBox[{"(", "args", ")"}]}], ";"}],
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            StyleBox[
              RowBox[{
                RowBox[{"MyClass`staticMethod", "[", "args", "]"}], ";"}],
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}]},
          {
            StyleBox[
              RowBox[{"MyClass", ".", "UNDER_SCORE"}],
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            StyleBox["MyClass`UNDERUSCORE",
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}},
  CellTags->{"Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],

Cell["Naming conventions used by J/Link.", "Caption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[TextData[{
  "Before accessing a static variables the class must be loaded once. The \
InstallJavaView[] command of the ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " pre-loads some basic ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " classes but we repeat the loading here for completeness."
}], "Text"],

Cell["\<\
Load static classes prior to access of static variables. Notice the 'U'.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    RowBox[{
      RowBox[{"LoadClass", "[", "\"\<jv.object.PsObject\>\"", "]"}], 
      ";"}], "\[IndentingNewLine]", "PsObject`ISUSELECTED"}], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData["1"], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
  "Arrays in Java and Lists in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Subsection"],

Cell[TextData[{
  "The level of exchange of larger data between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and Java is usually done on the basis of arrays in Java and lists in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as their counterparts.\nThe vector classes PdVector and PiVector used in \
JavaView have the functionality of double respectively integer arrays of \
arbitrary size. Basically, they contain a data fields 'double [] data' \
respectively 'int [] data'."
}], "Text"],

Cell[TextData[{
  "Here we call some basic linear algebra methods. Java objects in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " behave like usual Java instances."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    RowBox[{
      RowBox[{"vec0", "@", 
        RowBox[{"setSize", "[", "3", "]"}]}], ";"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{"vec0", "@", 
        RowBox[{"setConstant", "[", "1.", "]"}]}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{"vec3", "@", 
        RowBox[{"add", "[", "vec0", "]"}]}], ";"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        RowBox[{"vec3", "@", 
          RowBox[{"setEntry", "[", 
            RowBox[{"0", ",", "17"}], "]"}]}], ";"}], " ", 
      RowBox[{"(*", " ", 
        RowBox[{
        "JavaView", " ", "converts", " ", "argument", " ", "to", " ", 
          RowBox[{"double", "."}]}], " ", "*)"}]}]}], "Input",
  CellLabel->"In[11]:="],

Cell[TextData[{
  "Note, Java arrays start with index 0 while ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lists start at index 1. This is essential when converting between Java \
arrays and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lists."
}], "Text"],

Cell[TextData[{
  "The content of the vector can be converted back and forth to a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"v", " ", "=", " ", 
      RowBox[{"vec3", "@", 
        RowBox[{"getEntries", "[", "]"}]}]}]], "Input",
  CellLabel->"In[15]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"17.`", ",", "1.`", ",", "18.`"}], "}"}]], "Output",
  CellLabel->"Out[15]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    RowBox[{
      RowBox[{
        RowBox[{"v", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "=", "19."}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{"vec3", "@", 
        RowBox[{"set", "[", "v", "]"}]}], ";"}], "\[IndentingNewLine]", 
    RowBox[{"vec3", "@", 
      RowBox[{"getEntries", "[", "]"}]}]}], "Input",
  CellLabel->"In[16]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"17.`", ",", "19.`", ",", "18.`"}], "}"}]], "Output",
  CellLabel->"Out[18]="]
}, Open  ]],

Cell["\<\
Create a new vector which is initialized with the data of the existing vector \
v.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"kh", "=", 
      RowBox[{"JavaNew", "[", 
        RowBox[{"\"\<jv.vecmath.PdVector\>\"", ",", " ", "v"}], 
        "]"}]}]], "Input",
  CellLabel->"In[19]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        RowBox[{
        "\[LeftGuillemet]JavaObject", "[", "\<\"jv.vecmath.PdVector\"\>", 
          "]"}], "\[RightGuillemet]"}],
      JLink`Objects`JavaObject45219841]], "Output",
  CellLabel->"Out[19]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"kh", "@", 
      RowBox[{"getEntries", "[", "]"}]}]], "Input",
  CellLabel->"In[20]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"17.`", ",", "19.`", ",", "18.`"}], "}"}]], "Output",
  CellLabel->"Out[20]="]
}, Open  ]],

Cell["Create a new empty surface.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    RowBox[{"torus", " ", "=", " ", 
      RowBox[{"JavaNew", "[", 
        RowBox[{"\"\<jv.geom.PgElementSet\>\"", ",", " ", "3"}], 
        "]"}]}], "\n", 
    RowBox[{
      RowBox[{"torus", "@", 
        RowBox[{"setName", "[", "\"\<fancy torus\>\"", "]"}]}], 
      ";"}]}], "Input",
  CellLabel->"In[22]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        RowBox[{
        "\[LeftGuillemet]JavaObject", "[", "\<\"jv.geom.PgElementSet\"\>", 
          "]"}], "\[RightGuillemet]"}],
      JLink`Objects`JavaObject44564481]], "Output",
  CellLabel->"Out[22]="]
}, Open  ]],

Cell["\<\
Use a helper routine to create a torus over a 10*10 grid and radii 2 and 1.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"torus", "@", 
        RowBox[{"computeTorus", "[", 
          RowBox[{"10", ",", " ", "10", ",", " ", "2.", ",", " ", "1."}], 
          "]"}]}], ";"}]], "Input",
  CellLabel->"In[24]:="],

Cell["\<\
Here we are just accessing the 16th vertex of the torus. Note, array counting \
starts at 0 in Java.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"torus", "@", 
      RowBox[{
        RowBox[{"getVertex", "[", "16", "]"}], "@", 
        RowBox[{"getEntries", "[", "]"}]}]}]], "Input",
  CellLabel->"In[25]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
      "1.9151111077974454`", ",", "1.6069690242163484`", ",", 
        "0.8660254037844384`"}], "}"}]], "Output",
  CellLabel->"Out[25]="]
}, Open  ]],

Cell[TextData[{
  "Note, J/Link converts a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list to an array of doubles only if ALL entries are floating point \
numbers."
}], "Text"],

Cell["\<\
If the list v contains an integer then the setting fails since J/Link does \
not find the Java method. \
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    RowBox[{
      RowBox[{
        RowBox[{"v", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "=", "19"}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        RowBox[{"vec3", "@", 
          RowBox[{"set", "[", "v", "]"}]}], ";"}], " ", 
      RowBox[{"(*", " ", 
        RowBox[{"!", 
          RowBox[{"!", 
            RowBox[{"!", " ", 
              RowBox[{"v", " ", "contains", " ", "an", " ", "integer", " ", 
                RowBox[{"component", "."}]}]}]}]}], " ", "*)"}]}]}], "Input",
  CellLabel->"In[19]:="],

Cell[BoxData[
    RowBox[{"vec3", "@", 
      RowBox[{"set", "[", 
        RowBox[{"17.", ",", "19", ",", "1."}], "]"}]}]], "Input",
  CellLabel->"In[23]:="]
}, Open  ]],

Cell[TextData[{
  "When transferring large arrays of geometric data back and forth between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " it is time to read the section on performance issues in the J/Link \
manual."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Basics of the ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " Display"
}], "Section"],

Cell[TextData[{
  "The best introduction to the features of ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " and the interaction with its display is to browse through the \
demonstrations given at the ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " homepage ",
  ButtonBox["http://www.javaview.de/",
    ButtonData:>{
      URL[ "http://www.javaview.de"], None},
    ButtonStyle->"Hyperlink"],
  ". Here we provide a basic reference list."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " display always has a major interaction mode in which you can either \
rotate, scale, or translate a geometry. You press a shortcut key to switch to \
another mode temporarily. When releasing the key, the previous major mode is \
re-installed.\nNote, selecting an interaction mode with the popup menu \
switches the major mode."
}], "Text",
  CellDingbat->None],

Cell["\<\
Each display opens a popup menu by clicking with the right mouse. This is a \
convenient shortcut for a few basic tasks avoiding to know keyboard shortcuts \
or to open the control window. For example, to switch the interaction mode \
(without using keyboard shortcut), access to help dialog (without using \
control window), open another display (without using control window), or open \
the control window. \
\>", "Text"],

Cell[TextData[{
  "Popup menu in any ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " display using right-mouse click."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[TextData[{
  "You can always get a listing of available keyboard shortcuts by opening \
the popup menu in any ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " display and select the Help menu item. Here is a list of most commands. \
While focus over the display keep either of the following keys pressed while \
dragging with the mouse."
}], "Text",
  CellDingbat->None],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["Transformation",
              "MR",
              FontWeight->"Bold"], 
            StyleBox["\[Placeholder]",
              FontWeight->"Bold"]},
          {"o", 
            RowBox[{"Rotation", " ", "mode", " ", 
              RowBox[{"(", 
                StyleBox[
                  RowBox[{
                    StyleBox["O",
                      FontWeight->"Bold"], "rbit"}]], ")"}]}]},
          {"s", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["S",
                    FontWeight->"Bold"], "caling"}]], " ", "mode"}]},
          {"t", 
            RowBox[{"xy", "-", 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["T",
                      FontWeight->"Bold"], "ranslation"}]], " ", "mode"}]}]},
          {"z", 
            RowBox[{
              StyleBox["Z",
                FontWeight->"Bold"], "-", 
              RowBox[{"Translation", " ", "mode"}]}]},
          {"f", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["F",
                    FontWeight->"Bold"], "it"}]], " ", "geometry", " ", "to", 
              " ", "fill", " ", "display"}]},
          {"c", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["C",
                    FontWeight->"Bold"], "enter"}]], " ", "geometry", " ", 
              "in", " ", "display"}]},
          {"x", 
            RowBox[{
            "Drag", " ", "rectangle", " ", "to", " ", "zoom", " ", "in"}]},
          {"r", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["R",
                    FontWeight->"Bold"], "eset"}]], " ", "display", " ", 
              "and", " ", "camera"}]},
          {
            StyleBox["Display",
              FontWeight->"Bold"], 
            StyleBox["\[Placeholder]",
              FontWeight->"Bold"]},
          {"w", 
            RowBox[{
              RowBox[{"Start", " ", "auto"}], "-", 
              RowBox[{"rotation", " ", "of", " ", "geometry"}]}]},
          {"q", 
            RowBox[{
              RowBox[{"Stop", " ", "auto"}], "-", "rotation"}]},
          {
            StyleBox["Modelling",
              FontWeight->"Bold"], 
            StyleBox["\[Placeholder]",
              FontWeight->"Bold"]},
          {"p", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["P",
                    FontWeight->"Bold"], "ick"}]], " ", "a", " ", "vertex", 
              " ", "and", " ", "drag", " ", "it"}]},
          {"i", 
            RowBox[{"Pick", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["I",
                    FontWeight->"Bold"], "nital"}]], " ", "points", " ", "in",
               " ", "some", " ", "applets"}]},
          {"m", 
            RowBox[{"Drag", " ", "rectangle", " ", "to", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["M",
                    FontWeight->"Bold"], "ark"}]], " ", "vertices", " ", 
              "inside"}]},
          {"u", 
            RowBox[{"Drag", " ", "rectangle", " ", "to", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["U",
                    FontWeight->"Bold"], "nmark"}]], " ", "vertices", " ", 
              "inside"}]},
          {"a", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["A",
                    FontWeight->"Bold"], "dd"}]], " ", "vertex", " ", "to", 
              " ", "current", " ", "geometry", " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"enable", " ", "'"}], "show", " ", 
                  RowBox[{"vertices", "'"}]}], ")"}]}]},
          {"d", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["D",
                        FontWeight->"Bold"], "uplicate"}]], " ", "geometry", 
                  " ", "by", " ", "reflection", " ", "depending", " ", "on", 
                  " ", "the", " ", "number", " ", "of", " ", "marked", " ", 
                  RowBox[{"vertices", ":", " ", 
                    RowBox[{"1", " ", "vertex"}]}]}], " ", "=", " ", 
                RowBox[{"inversion", " ", "in", " ", "point"}]}], ",", " ", 
              RowBox[{
                RowBox[{"2", " ", "vertices"}], " ", "=", " ", 
                RowBox[{
                "180", " ", "rotation", " ", "around", " ", "line"}]}], ",", 
              " ", 
              RowBox[{
                RowBox[{"3", " ", "vertices"}], " ", "=", " ", 
                RowBox[{"mirror", " ", "reflection", " ", "in", " ", 
                  RowBox[{"plane", "."}]}]}]}]},
          {
            StyleBox[
              RowBox[{"Display", " ", "Flags"}],
              FontWeight->"Bold"], 
            StyleBox[
              RowBox[{"(", 
                RowBox[{"toggle", " ", 
                  RowBox[{"on", "/", "off"}]}], ")"}],
              FontWeight->"Bold"]},
          {
            RowBox[{"Shift", "-", "a"}], 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["A",
                    FontWeight->"Bold"], "ura"}]], " ", "around", " ", 
              "edges", " ", 
              RowBox[{"(", 
                RowBox[{"switch", " ", "off", " ", "elements"}], ")"}]}]},
          {
            RowBox[{"Shift", "-", "b"}], 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["B",
                    FontWeight->"Bold"], "ounding"}]], " ", "box", " ", "of", 
              " ", "current", " ", "geometry"}]},
          {
            RowBox[{"Shift", "-", "c"}], 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["C",
                    FontWeight->"Bold"], "enter"}]], " ", "of", " ", 
              "current", " ", "geometry", " ", 
              RowBox[{"(", "pending", ")"}]}]},
          {
            RowBox[{"Shift", "-", "d"}], 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["D",
                    FontWeight->"Bold"], "epthcue"}]], " ", "fading", " ", 
              "of", " ", "items", " ", "farer", " ", "away"}]},
          {
            RowBox[{"Shift", "-", "f"}], 
            RowBox[{"Coordinate", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["F",
                    FontWeight->"Bold"], "rame"}]]}]},
          {
            RowBox[{"Shift", "-", "g"}], 
            RowBox[{"xy", "-", 
              StyleBox[
                RowBox[{
                  StyleBox["G",
                    FontWeight->"Bold"], "rid"}]]}]},
          {
            RowBox[{"Shift", "-", "h"}], 
            RowBox[{
              RowBox[{"Information", " ", "at", " ", "mouse", " ", "cursor"}],
               ",", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["H",
                    FontWeight->"Bold"], "ighlight"}]]}]},
          {
            RowBox[{"Shift", "-", "i"}], 
            RowBox[{"Background", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["I",
                    FontWeight->"Bold"], "mage"}]]}]},
          {
            RowBox[{"Shift", "-", "l"}], 
            RowBox[{
              StyleBox[
                RowBox[{"Border", 
                  StyleBox["l",
                    FontWeight->"Bold"], "ine"}]], " ", "around", " ", 
              "display"}]},
          {
            RowBox[{"Shift", "-", "p"}], 
            RowBox[{
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["P",
                      FontWeight->"Bold"], "ainter"}]], "'"}], "s", " ", 
              "algorithm", " ", "for", " ", "depthsort"}]},
          {
            RowBox[{"Shift", "-", "r"}], 
            RowBox[{
              RowBox[{"Backface", " ", "culling"}], ",", " ", 
              RowBox[{"show", " ", 
                StyleBox[
                  RowBox[{
                    StyleBox["R",
                      FontWeight->"Bold"], "ear"}]], " ", "elements"}]}]},
          {
            RowBox[{"Shift", "-", "x"}], 
            RowBox[{"Coordinate", " ", 
              StyleBox[
                RowBox[{"A", 
                  StyleBox["x",
                    FontWeight->"Bold"], "es"}]], " ", "around", " ", 
              "scene"}]},
          {
            StyleBox["Selecting",
              FontWeight->"Bold"], 
            StyleBox["\[Placeholder]",
              FontWeight->"Bold"]},
          {
            RowBox[{"Ctrl", "-", 
              RowBox[{"left", " ", "mouse"}]}], 
            RowBox[{"Pick", " ", "geometry", " ", "to", " ", "select", " ", 
              RowBox[{"it", ".", " ", 
                RowBox[{"(", 
                  RowBox[{"see", " ", "below"}], ")"}]}]}]},
          {
            RowBox[{"Ctrl", "-", "tab"}], 
            RowBox[{
            "Cycle", " ", "through", " ", "the", " ", "registered", " ", 
              "geometries", " ", "of", " ", "a", " ", 
              RowBox[{"scene", "."}]}]},
          {
            RowBox[{"Backspace", "-", 
              RowBox[{"left", " ", "mouse"}]}], 
            RowBox[{"Pick", " ", "geometry", " ", "to", " ", "delete", " ", 
              RowBox[{"it", "."}]}]},
          {
            StyleBox["Panels",
              FontWeight->"Bold"], 
            StyleBox["\[Placeholder]",
              FontWeight->"Bold"]},
          {
            RowBox[{"Ctrl", "-", 
              RowBox[{"s", " ", "or", " ", "F1"}]}], 
            RowBox[{
            "Open", " ", "control", " ", "window", " ", "with", " ", 
              "default", " ", "panel"}]},
          {"F2", 
            RowBox[{"Close", " ", "control", " ", "window"}]},
          {
            RowBox[{"Ctrl", "-", "a"}], 
            RowBox[{"Show", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["A",
                    FontWeight->"Bold"], "nimation"}]], " ", "Control", " ", 
              "Panel", " ", 
              RowBox[{"(", 
                RowBox[{"if", " ", "project", " ", "allows"}], ")"}]}]},
          {
            RowBox[{"Ctrl", "-", "c"}], 
            RowBox[{
              RowBox[{"Show", " ", 
                StyleBox[
                  RowBox[{
                    StyleBox["C",
                      FontWeight->"Bold"], "amera"}]], " ", "panel"}], ",", 
              " ", 
              RowBox[{"info", " ", "panel", " ", "of", " ", "camera"}]}]},
          {
            RowBox[{"Ctrl", "-", "d"}], 
            RowBox[{
              RowBox[{"Show", " ", 
                StyleBox[
                  RowBox[{
                    StyleBox["D",
                      FontWeight->"Bold"], "ebug"}]], " ", "console"}], ",", 
              " ", 
              RowBox[{
                RowBox[{
                  StyleBox["JavaView",
                    FontWeight->"Bold",
                    FontSlant->"Italic",
                    FontColor->RGBColor[0, 0.250004, 0.500008]], "'"}], "s", 
                " ", "console"}]}]},
          {
            RowBox[{"Ctrl", "-", "i"}], 
            RowBox[{"Show", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["I",
                    FontWeight->"Bold"], "nfo"}]], " ", "panel", " ", "of", 
              " ", "geometry"}]},
          {
            RowBox[{"Ctrl", "-", "m"}], 
            RowBox[{"Show", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["M",
                    FontWeight->"Bold"], "aterial"}]], " ", "panel", " ", 
              "of", " ", "geometry"}]},
          {
            RowBox[{"Ctrl", "-", "o"}], 
            RowBox[{"Show", " ", "file", " ", 
              StyleBox[
                RowBox[{
                  StyleBox["O",
                    FontWeight->"Bold"], "pen"}]], " ", "dialog", " ", "for", 
              " ", "geometry", " ", "import"}]},
          {
            RowBox[{"Ctrl", "-", "v"}], 
            RowBox[{
              RowBox[{"Show", " ", 
                StyleBox[
                  RowBox[{
                    StyleBox["V",
                      FontWeight->"Bold"], "iewer"}]], " ", "panel"}], ",", 
              " ", 
              RowBox[{"info", " ", "panel", " ", "of", " ", "display"}]}]},
          {"\[Placeholder]", "\[Placeholder]"},
          {
            StyleBox["System",
              FontWeight->"Bold"], "\[Placeholder]"},
          {
            RowBox[{"Right", " ", "mouse"}], 
            RowBox[{"Open", " ", "popup", " ", "menu"}]},
          {
            RowBox[{"Ctrl", "-", "Shift", "-", "x"}], 
            RowBox[{"Immediate", " ", 
              StyleBox[
                RowBox[{"e", 
                  StyleBox["X",
                    FontWeight->"Bold"], "it"}]], " ", "of", " ", "a", " ", 
              StyleBox["JavaView",
                FontWeight->"Bold",
                FontSlant->"Italic",
                FontColor->RGBColor[0, 0.250004, 0.500008]], " ", 
              "application"}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}},
  CellTags->{"Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],

Cell[TextData[{
  "Keyboard shortcuts in ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " display (an excerpt). "
}], "Caption",
  CellTags->"S1.3.9"],

Cell["Different camera views, different display settings.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[TextData[{
  "Each ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " display maintains its own settings. If you like to have different views \
on the same scene then just open another display and select your preferred \
camera and display settings."
}], "Text"],

Cell["\<\
Different displays may also show a different set of geometries. But if a \
geometry is shared by displays, then it has the same shape and material in \
all displays. Therefore, if you have four displays with top, front, right, \
perspective view, then moving a vertex in either display will move the vertex \
in the other views too as you expect.\
\>", "Text"],

Cell["\<\
The control panel always views the camera and display panel of the currently \
active display. The current display is selected by moving the mouse over it. \
If there are many displays then this automatic selection might be annoying \
but it ensures that keyboard events are received by the display with mouse \
focus as expected (so we know about this problem).\
\>", "Text"],

Cell["Current geometry of a display.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[TextData[{
  "Each ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " display is able to display a scene with many geometries. One of these \
geometries is the active geometry. For example, you can pick vertices only of \
the active geometry."
}], "Text",
  CellDingbat->None],

Cell["\<\
Note, the control panel shows the info and material panel of the current \
geometry.\
\>", "Text",
  CellDingbat->None],

Cell["\<\
The current geometry may be selected in different ways:
1. Using keyboard shortcut Ctrl-tab or Ctrl-left mouse. This does not allow \
to select special geometries like the coordinate frame, xy-grid or bounding \
box.
2. On the display panel select the active geometry. Here it is allowed to \
select special geometries too, and, for example, modify their appearance \
using their info/material/control panels.
3. Via method call disp@selectGeometry[geom].\
\>", "Text",
  CellDingbat->None],

Cell["Control Panel", "Subsection"],

Cell[TextData[{
  "The control window contains a set of panels to inspect the current \
geometry object, modify its material properties, select different camera type \
and to configure the active display.\nThe control panel may be opened in \
different ways:\n1. Click inside a display with the right mouse button and \
select the item 'Control Panel' from the popup menu.\n2. Ask the viewer \
manager to show the control panel, see below.\n3. If ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " is called from the command line as in the RunJavaView[g] command then \
command line arguments may be specified like 'javaview panel=material \
control=show myDode.mgs' additional to a possible geometry file.\n4. If ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " runs inside an applet the applet parameters can be used to configure the \
initial setup like '<param name=config value=show>'."
}], "Text"],

Cell[TextData[{
  "Show the control window to inspect and configure the ",
  StyleBox["JavaView",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " scene. Here we make use of the viewer obtained from command \
InstallJavaView[] and the automatic preloading of the interface class \
PsViewerIf."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", " ", 
        RowBox[{
        "If", " ", "you", " ", "did", " ", "not", " ", "keep", " ", "your", 
          " ", 
          StyleBox["JavaView",
            FontSlant->"Italic",
            FontColor->RGBColor[0, 0.250004, 0.500008]], " ", "link", " ", 
          "from", " ", "a", " ", "session", " ", "above", " ", "then", " ", 
          "generate", " ", "a", " ", "new", " ", 
          RowBox[{"one", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"<<", "JavaView`JLink`"}]}], "\[IndentingNewLine]", 
    RowBox[{"viewer", " ", "=", " ", 
      RowBox[{"InstallJavaView", "[", "]"}]}]}], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"Notation:S4", "Notation:S4.3"}],

Cell[BoxData[{
    RowBox[{
      RowBox[{"viewer", "@", 
        RowBox[{"showPanel", "[", "PsViewerIf`CAMERA", "]"}]}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{"viewer", "@", 
      RowBox[{"showDialog", "[", "PsViewerIf`CONTROL", "]"}]}]}], "Input",
  CellLabel->"In[7]:="],

Cell[TextData[{
  "Java has some problems in bringing windows to the front, so the control \
panel might be hidden behind other windows. J/Link provides a special frame \
subclass to bring windows in front of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " but the current version of the viewer manager creates an own specialized \
frame."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Acknowledgements", "Section"],

Cell[TextData[{
  "Although this text consists of informal notes, I would like use the \
opportunity to include thanks to Paul Wellin and Tom Wickham-Jones from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for pointing my attention to J/Link and providing a development edition \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", and to Todd Gayley who designed the marvellous J/Link package and \
answered my numerous questions. In many aspects, J/Link is this perfect \
interface to allow true interactive, high level cooperation of mathematical \
software which I was looking for a long time."
}], "Text"],

Cell[TextData[{
  "JavaView is software written by Konrad Polthier, Samy Khadem-Al-Charieh, \
Eike Preu\[SZ], Ulrich Reitebuch. Other contributors are listed in the About \
menu of JavaView. The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics parser in JavaView is written by Ulrich Reitebuch."
}], "Text"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 723}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{863, 682},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {"Konrad Polthier"}], "PageHeader"]}, {Cell[ 
        TextData[ {"The ", 
          StyleBox[ "JavaView", FontSlant -> "Italic"], " Packages"}], 
        "PageHeader"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, Cell[ 
        TextData[ {""}], "PageFooter"], Inherited}, {Inherited, Cell[ 
        TextData[ {""}], "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"PrintingMargins"->{{42.625, 42.625}, {43.625, 43.625}},
"PrintCellBrackets"->True,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ShortBoxForm"->False},
InputAliases->{
  "pattwrap"->TagBox[ 
      "\[Placeholder]", NotationPatternTag, TagStyle -> 
        "NotationPatternWrapperStyle"], 
    "madeboxeswrap"->TagBox[ 
      "\[Placeholder]", NotationMadeBoxesTag, TagStyle -> 
        "NotationMadeBoxesWrapperStyle"], "apply"->RowBox[ {
        RowBox[ {"\[Placeholder]", " ", 
          OverscriptBox[ "\[LongRightArrow]", 
            RowBox[ {" ", "Apply", " "}]], " ", "\[Placeholder]"}], " "}], 
    "notation"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", " ",
           
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "notation>"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongRightArrow]", " ", 
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "notation<"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongLeftArrow]", " ", 
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "symb"->RowBox[ {"Symbolize", "[", 
        TagBox[ 
        "\[Placeholder]", NotationBoxTag, TagStyle -> 
          "NotationTemplateStyle"], "]"}], 
    "infixnotation"->RowBox[ {"InfixNotation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], ",", "\[Placeholder]"}], "]"}], 
    "addia"->RowBox[ {"AddInputAlias", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], ",", "\[Placeholder]"}], "]"}], 
    "pattwraper"->TagBox[ 
      "\[Placeholder]", NotationPatternTag, TagStyle -> 
        "NotationPatternWrapperStyle"], 
    "madeboxeswraper"->TagBox[ 
      "\[Placeholder]", NotationMadeBoxesTag, TagStyle -> 
        "NotationMadeBoxesWrapperStyle"]},
SpellingDictionaries->{"CorrectWords"->{
  "typset", "gplus", 
    "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]", 
    "foo"}},
FontSlant->"Plain",
FontColor->GrayLevel[0],
Magnification->1.25,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.1.3"->{
    Cell[14349, 449, 890, 27, 69, "Text",
      CellTags->{"S2.1.3", "3.4"}],
    Cell[21452, 650, 816, 20, 96, "Text",
      CellTags->{"S2.1.3", "3.4"}],
    Cell[22271, 672, 93, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[22461, 679, 104, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[22938, 693, 101, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[28118, 825, 306, 11, 37, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[29018, 857, 374, 9, 56, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[30949, 915, 136, 3, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[31313, 928, 99, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[32714, 970, 146, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[33160, 985, 110, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[43242, 1271, 194, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[43574, 1284, 357, 10, 56, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[44139, 1303, 285, 7, 48, "Text",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[44573, 1319, 234, 5, 48, "Text",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[46377, 1369, 248, 8, 37, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[47280, 1401, 207, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[47580, 1413, 115, 2, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[48906, 1452, 425, 13, 56, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[49858, 1488, 362, 10, 56, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[50350, 1505, 146, 4, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[50710, 1522, 222, 5, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[51161, 1541, 536, 16, 44, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[53373, 1610, 389, 9, 56, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[53966, 1631, 145, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[54340, 1648, 561, 17, 57, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[55255, 1682, 136, 3, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[56715, 1727, 216, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[57679, 1761, 257, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[59236, 1814, 90, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[66841, 2017, 102, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[67819, 2052, 96, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[73407, 2223, 134, 3, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[74467, 2259, 226, 6, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[75720, 2300, 197, 6, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[76783, 2343, 144, 4, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[77693, 2381, 81, 1, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[78406, 2407, 137, 3, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[78778, 2420, 162, 4, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[79552, 2451, 165, 4, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[82635, 2552, 248, 8, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[97137, 2957, 105, 1, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[98354, 2987, 84, 1, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[100537, 3044, 396, 10, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}]},
  "3.4"->{
    Cell[14349, 449, 890, 27, 69, "Text",
      CellTags->{"S2.1.3", "3.4"}],
    Cell[21452, 650, 816, 20, 96, "Text",
      CellTags->{"S2.1.3", "3.4"}]},
  "Notation:S1"->{
    Cell[15242, 478, 5971, 160, 287, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[21216, 640, 233, 8, 19, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[35680, 1069, 5709, 144, 189, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[41392, 1215, 308, 11, 19, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[60372, 1842, 2154, 56, 119, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[62529, 1900, 91, 1, 19, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[63140, 1915, 3055, 81, 119, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[66198, 1998, 102, 1, 19, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[69987, 2127, 2841, 76, 70, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[72831, 2205, 99, 1, 70, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[83343, 2575, 13559, 370, 70, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}]},
  "Notation:S1.1"->{
    Cell[15242, 478, 5971, 160, 287, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[21216, 640, 233, 8, 19, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[35680, 1069, 5709, 144, 189, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[41392, 1215, 308, 11, 19, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[60372, 1842, 2154, 56, 119, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[62529, 1900, 91, 1, 19, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[63140, 1915, 3055, 81, 119, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[66198, 1998, 102, 1, 19, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[69987, 2127, 2841, 76, 70, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[72831, 2205, 99, 1, 70, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[83343, 2575, 13559, 370, 70, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}]},
  "Notation:Definition:Notation"->{
    Cell[15242, 478, 5971, 160, 287, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[35680, 1069, 5709, 144, 189, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[60372, 1842, 2154, 56, 119, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[63140, 1915, 3055, 81, 119, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[69987, 2127, 2841, 76, 70, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[83343, 2575, 13559, 370, 70, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}]},
  "3.5"->{
    Cell[22271, 672, 93, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[22461, 679, 104, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[22938, 693, 101, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[28118, 825, 306, 11, 37, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[29018, 857, 374, 9, 56, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[30949, 915, 136, 3, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[31313, 928, 99, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[32714, 970, 146, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[33160, 985, 110, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[43242, 1271, 194, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[43574, 1284, 357, 10, 56, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[44139, 1303, 285, 7, 48, "Text",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[44573, 1319, 234, 5, 48, "Text",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[46377, 1369, 248, 8, 37, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[47280, 1401, 207, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[47580, 1413, 115, 2, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[48906, 1452, 425, 13, 56, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[49858, 1488, 362, 10, 56, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[50350, 1505, 146, 4, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[50710, 1522, 222, 5, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[51161, 1541, 536, 16, 44, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[53373, 1610, 389, 9, 56, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[53966, 1631, 145, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[54340, 1648, 561, 17, 57, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[55255, 1682, 136, 3, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[56715, 1727, 216, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[57679, 1761, 257, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[59236, 1814, 90, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[66841, 2017, 102, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[67819, 2052, 96, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[73407, 2223, 134, 3, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[74467, 2259, 226, 6, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[75720, 2300, 197, 6, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[76783, 2343, 144, 4, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[77693, 2381, 81, 1, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[78406, 2407, 137, 3, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[78778, 2420, 162, 4, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[79552, 2451, 165, 4, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[82635, 2552, 248, 8, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[97137, 2957, 105, 1, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[98354, 2987, 84, 1, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[100537, 3044, 396, 10, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}]},
  "Notation:S4"->{
    Cell[22568, 682, 367, 9, 75, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[28427, 838, 494, 13, 33, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[43439, 1279, 132, 3, 33, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[43934, 1296, 202, 5, 33, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[46650, 1381, 364, 9, 75, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[100936, 3056, 734, 16, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}]},
  "Notation:S4.3"->{
    Cell[22568, 682, 367, 9, 75, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[28427, 838, 494, 13, 33, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[43439, 1279, 132, 3, 33, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[43934, 1296, 202, 5, 33, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[46650, 1381, 364, 9, 75, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[100936, 3056, 734, 16, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}]},
  "S1.3.9"->{
    Cell[96905, 2947, 229, 8, 70, "Caption",
      CellTags->"S1.3.9"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.1.3", 107587, 3229},
  {"3.4", 111304, 3318},
  {"Notation:S1", 111480, 3323},
  {"Notation:S1.1", 112845, 3352},
  {"Notation:Definition:Notation", 114225, 3381},
  {"3.5", 115102, 3400},
  {"Notation:S4", 118671, 3485},
  {"Notation:S4.3", 119258, 3498},
  {"S1.3.9", 119838, 3511}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 477, 17, 124, "Chapter",
  CellGroupingRules->"SectionGrouping"],

Cell[CellGroupData[{
Cell[2219, 70, 797, 21, 88, "Text"],
Cell[3019, 93, 403, 10, 70, "Text"],
Cell[3425, 105, 1046, 28, 70, "Text"],
Cell[4474, 135, 613, 18, 70, "Text"],
Cell[5090, 155, 521, 16, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[5648, 176, 31, 0, 59, "Section"],
Cell[5682, 178, 2678, 73, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[8397, 256, 143, 5, 59, "Section"],
Cell[8543, 263, 566, 14, 70, "Text"],

Cell[CellGroupData[{
Cell[9134, 281, 255, 10, 70, "MathCaption"],
Cell[9392, 293, 60, 0, 70, "NumberedEquation"],
Cell[9455, 295, 54, 0, 70, "NumberedEquation"],
Cell[9512, 297, 110, 2, 70, "NumberedEquation"],
Cell[9625, 301, 165, 3, 70, "NumberedEquation"],
Cell[9793, 306, 188, 5, 70, "NumberedEquation"],
Cell[9984, 313, 762, 22, 70, "Text"]
}, Open  ]],
Cell[10761, 338, 291, 6, 70, "Text"],
Cell[11055, 346, 929, 26, 70, "Text"],

Cell[CellGroupData[{
Cell[12009, 376, 277, 9, 70, "Subsection"],
Cell[12289, 387, 303, 8, 70, "Text"],
Cell[12595, 397, 835, 20, 70, "Text"],
Cell[13433, 419, 819, 22, 70, "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[14301, 447, 45, 0, 59, "Section"],
Cell[14349, 449, 890, 27, 69, "Text",
  CellTags->{"S2.1.3", "3.4"}],
Cell[15242, 478, 5971, 160, 287, "DefinitionBox",
  CellTags->{
  "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
Cell[21216, 640, 233, 8, 19, "Caption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[21452, 650, 816, 20, 96, "Text",
  CellTags->{"S2.1.3", "3.4"}],
Cell[22271, 672, 93, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[22367, 675, 91, 2, 33, "Input"],
Cell[22461, 679, 104, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[22568, 682, 367, 9, 75, "Input",
  CellTags->{"Notation:S4", "Notation:S4.3"}],
Cell[22938, 693, 101, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[23042, 696, 3144, 70, 180, "Input"],

Cell[CellGroupData[{
Cell[26211, 770, 44, 0, 56, "Subsection"],
Cell[26258, 772, 1857, 51, 181, "Text"],
Cell[28118, 825, 306, 11, 37, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[28427, 838, 494, 13, 33, "Input",
  CellTags->{"Notation:S4", "Notation:S4.3"}],
Cell[28924, 853, 91, 2, 33, "Input"],
Cell[29018, 857, 374, 9, 56, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[29395, 868, 427, 11, 33, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29859, 884, 47, 0, 56, "Subsection"],
Cell[29909, 886, 1037, 27, 114, "Text"],
Cell[30949, 915, 136, 3, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[31088, 920, 222, 6, 82, "Input",
  Evaluatable->False],
Cell[31313, 928, 99, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[31415, 931, 136, 3, 33, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31588, 939, 60, 0, 56, "Subsection"],
Cell[31651, 941, 1060, 27, 114, "Text"],
Cell[32714, 970, 146, 4, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[32863, 976, 294, 7, 105, "Input",
  Evaluatable->False],
Cell[33160, 985, 110, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[33273, 988, 136, 3, 33, "Input"],
Cell[33412, 993, 136, 3, 33, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33585, 1001, 47, 0, 56, "Subsection"],
Cell[33635, 1003, 810, 20, 114, "Text"],
Cell[34448, 1025, 138, 3, 33, "Input"]
}, Open  ]],
Cell[34601, 1031, 536, 16, 68, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[35174, 1052, 40, 0, 59, "Section"],
Cell[35217, 1054, 460, 13, 49, "Text"],
Cell[35680, 1069, 5709, 144, 189, "DefinitionBox",
  CellTags->{
  "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
Cell[41392, 1215, 308, 11, 19, "Caption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[41703, 1228, 754, 19, 88, "Text"],
Cell[42460, 1249, 779, 20, 69, "Text"],
Cell[43242, 1271, 194, 6, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[43439, 1279, 132, 3, 33, "Input",
  CellTags->{"Notation:S4", "Notation:S4.3"}],
Cell[43574, 1284, 357, 10, 56, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[43934, 1296, 202, 5, 33, "Input",
  CellTags->{"Notation:S4", "Notation:S4.3"}],
Cell[44139, 1303, 285, 7, 48, "Text",
  CellTags->{"S2.1.3", "3.5"}],
Cell[44427, 1312, 143, 5, 59, "Input",
  Evaluatable->False],
Cell[44573, 1319, 234, 5, 48, "Text",
  CellTags->{"S2.1.3", "3.5"}],
Cell[44810, 1326, 302, 8, 33, "Input"],
Cell[45115, 1336, 1259, 31, 142, "Text"],
Cell[46377, 1369, 248, 8, 37, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[46650, 1381, 364, 9, 75, "Input",
  CellTags->{"Notation:S4", "Notation:S4.3"}],
Cell[47017, 1392, 260, 7, 27, "Output"],
Cell[47280, 1401, 207, 6, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[47490, 1409, 87, 2, 33, "Input"],
Cell[47580, 1413, 115, 2, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[47698, 1417, 725, 18, 54, "Input"],
Cell[48426, 1437, 88, 2, 33, "Input"]
}, Open  ]],
Cell[48529, 1442, 374, 8, 49, "Text"],
Cell[48906, 1452, 425, 13, 56, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[49356, 1469, 202, 5, 33, "Input"],
Cell[49561, 1476, 260, 7, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49858, 1488, 362, 10, 56, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[50223, 1500, 124, 3, 70, "Input"],
Cell[50350, 1505, 146, 4, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[50521, 1513, 119, 3, 70, "Input"],
Cell[50643, 1518, 52, 1, 70, "Output"]
}, Open  ]],
Cell[50710, 1522, 222, 5, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[50957, 1531, 119, 3, 70, "Input"],
Cell[51079, 1536, 55, 1, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[51161, 1541, 536, 16, 44, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[51722, 1561, 92, 2, 33, "Input"],
Cell[51817, 1565, 261, 7, 27, "Output"]
}, Open  ]],
Cell[52093, 1575, 1104, 28, 107, "Text"],
Cell[53200, 1605, 170, 3, 48, "Text"],
Cell[53373, 1610, 389, 9, 56, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[53787, 1623, 120, 3, 33, "Input"],
Cell[53910, 1628, 53, 1, 27, "Output"],
Cell[53966, 1631, 145, 4, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[54136, 1639, 115, 3, 33, "Input"],
Cell[54254, 1644, 71, 1, 27, "Output"]
}, Open  ]],
Cell[54340, 1648, 561, 17, 57, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[54926, 1669, 255, 7, 54, "Input"],
Cell[55184, 1678, 56, 1, 27, "Output"]
}, Open  ]],
Cell[55255, 1682, 136, 3, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[55416, 1689, 514, 15, 96, "Input"],
Cell[55933, 1706, 56, 1, 27, "Output"]
}, Open  ]],
Cell[56004, 1710, 708, 15, 87, "Text"],
Cell[56715, 1727, 216, 5, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[56956, 1736, 254, 7, 54, "Input"],
Cell[57213, 1745, 56, 1, 27, "Output"]
}, Open  ]],
Cell[57284, 1749, 392, 10, 49, "Text"],
Cell[57679, 1761, 257, 5, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[57961, 1770, 514, 13, 96, "Input"],
Cell[58478, 1785, 54, 1, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[58559, 1790, 353, 9, 49, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[58949, 1804, 32, 0, 77, "Section"],
Cell[58984, 1806, 38, 0, 56, "Subsection"],
Cell[59025, 1808, 208, 4, 48, "Text"],
Cell[59236, 1814, 90, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[59329, 1817, 523, 13, 75, "Input"],
Cell[59855, 1832, 514, 8, 94, "Text"],
Cell[60372, 1842, 2154, 56, 119, "DefinitionBox",
  CellTags->{
  "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
Cell[62529, 1900, 91, 1, 19, "Caption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[62623, 1903, 43, 0, 56, "Subsection"],
Cell[62669, 1905, 468, 8, 67, "Text"],
Cell[63140, 1915, 3055, 81, 119, "DefinitionBox",
  CellTags->{
  "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
Cell[66198, 1998, 102, 1, 19, "Caption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[66303, 2001, 535, 14, 50, "Text"],
Cell[66841, 2017, 102, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[66968, 2022, 312, 9, 54, "Input"],
Cell[67283, 2033, 259, 7, 27, "Output"],
Cell[67545, 2042, 259, 7, 27, "Output"]
}, Open  ]],
Cell[67819, 2052, 96, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[67940, 2057, 203, 5, 54, "Input"],
Cell[68146, 2064, 52, 1, 27, "Output"],
Cell[68201, 2067, 52, 1, 27, "Output"]
}, Open  ]],
Cell[68268, 2071, 154, 4, 33, "Input"],

Cell[CellGroupData[{
Cell[68447, 2079, 115, 3, 33, "Input"],
Cell[68565, 2084, 121, 3, 27, "Output"]
}, Open  ]],
Cell[68701, 2090, 553, 12, 68, "Text"],
Cell[69257, 2104, 40, 0, 56, "Subsection"],
Cell[69300, 2106, 207, 6, 29, "Text"],
Cell[69510, 2114, 285, 5, 48, "Text"],
Cell[69798, 2121, 186, 4, 70, "Text"],
Cell[69987, 2127, 2841, 76, 70, "DefinitionBox",
  CellTags->{
  "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
Cell[72831, 2205, 99, 1, 70, "Caption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[72933, 2208, 471, 13, 70, "Text"],
Cell[73407, 2223, 134, 3, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[73566, 2230, 192, 4, 70, "Input"],
Cell[73761, 2236, 53, 1, 70, "Output"]
}, Open  ]],
Cell[73829, 2240, 118, 4, 70, "Subsection"],
Cell[73950, 2246, 514, 11, 70, "Text"],
Cell[74467, 2259, 226, 6, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[74696, 2267, 735, 20, 70, "Input"],
Cell[75434, 2289, 283, 9, 70, "Text"],
Cell[75720, 2300, 197, 6, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[75942, 2310, 155, 4, 70, "Input"],
Cell[76100, 2316, 123, 3, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76260, 2324, 381, 11, 70, "Input"],
Cell[76644, 2337, 124, 3, 70, "Output"]
}, Open  ]],
Cell[76783, 2343, 144, 4, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[76952, 2351, 185, 5, 70, "Input"],
Cell[77140, 2358, 260, 7, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77437, 2370, 114, 3, 70, "Input"],
Cell[77554, 2375, 124, 3, 70, "Output"]
}, Open  ]],
Cell[77693, 2381, 81, 1, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[77799, 2386, 328, 9, 70, "Input"],
Cell[78130, 2397, 261, 7, 70, "Output"]
}, Open  ]],
Cell[78406, 2407, 137, 3, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[78546, 2412, 229, 6, 70, "Input"],
Cell[78778, 2420, 162, 4, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[78965, 2428, 189, 5, 70, "Input"],
Cell[79157, 2435, 185, 5, 70, "Output"]
}, Open  ]],
Cell[79357, 2443, 192, 6, 70, "Text"],
Cell[79552, 2451, 165, 4, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[79742, 2459, 560, 16, 70, "Input"],
Cell[80305, 2477, 157, 4, 70, "Input"]
}, Open  ]],
Cell[80477, 2484, 371, 11, 70, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[80885, 2500, 184, 7, 70, "Section"],
Cell[81072, 2509, 610, 18, 70, "Text"],
Cell[81685, 2529, 511, 12, 70, "Text"],
Cell[82199, 2543, 433, 7, 70, "Text"],
Cell[82635, 2552, 248, 8, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[82886, 2562, 454, 11, 70, "Text"],
Cell[83343, 2575, 13559, 370, 70, "DefinitionBox",
  CellTags->{
  "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
Cell[96905, 2947, 229, 8, 70, "Caption",
  CellTags->"S1.3.9"],
Cell[97137, 2957, 105, 1, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[97245, 2960, 344, 9, 70, "Text"],
Cell[97592, 2971, 370, 6, 70, "Text"],
Cell[97965, 2979, 386, 6, 70, "Text"],
Cell[98354, 2987, 84, 1, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[98441, 2990, 358, 10, 70, "Text"],
Cell[98802, 3002, 129, 4, 70, "Text"],
Cell[98934, 3008, 500, 10, 70, "Text"],
Cell[99437, 3020, 35, 0, 70, "Subsection"],
Cell[99475, 3022, 1059, 20, 70, "Text"],
Cell[100537, 3044, 396, 10, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[100936, 3056, 734, 16, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.3"}],
Cell[101673, 3074, 286, 7, 70, "Input"],
Cell[101962, 3083, 362, 8, 70, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[102361, 3096, 35, 0, 70, "Section"],
Cell[102399, 3098, 635, 13, 70, "Text"],
Cell[103037, 3113, 326, 7, 70, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

