package vgp.tutor.eventCamera;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;

/**
 * Info panel of ode demonstration with text field to edit ode expression.
 * 
 * @author		Konrad Polthier
 * @version		25.07.00, 1.00 revised (kp) <br>
 *					25.07.00, 1.00 created (kp)
 */
public class PjEventCamera_IP extends PjProject_IP implements ActionListener {
	protected	PjEventCamera			m_pjEvent;

	protected	Button					m_bReset;

	public PjEventCamera_IP() {
		super();
		if (getClass() == PjEventCamera_IP.class)
			init();
	}
	public void init() {
		super.init();
		addTitle("");

		// draw a separator
		addLine(1);

		// buttons at bottom
		Panel m_pBottomButtons = new Panel();
		m_pBottomButtons.setLayout(new FlowLayout(FlowLayout.CENTER));
		add(m_pBottomButtons);
		m_bReset = new Button("Reset");
		m_bReset.addActionListener(this);
		m_pBottomButtons.add(m_bReset);
	}
	/**
	 * Set parent of panel which supplies the data inspected by the panel.
	 */
	public void setParent(PsUpdateIf parent) {
		super.setParent(parent);
		m_pjEvent = (PjEventCamera)parent;
	}
	/**
	 * Update the panel whenever the parent has changed somewhere else.
	 * Method is invoked from the parent or its superclasses.
	 */
	public boolean update(Object event) {
		if (PsDebug.NOTIFY) PsDebug.notify("PjEventCamera_IP.update: isShowing = "+isShowing());
		if (m_pjEvent == event) {
			setTitle("Showing: "+m_pjEvent.getName());
			return true;
		}
		return super.update(event);
	}
	/**
	 * Handle action events invoked from buttons, menu items, text fields.
	 */
	public void actionPerformed(ActionEvent event) {
		if (m_pjEvent==null)
			return;
		Object source = event.getSource();
		if (source == m_bReset) {
			m_pjEvent.init();
		}
	}
}

