package vgp.tutor.fractal;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;

/**
 * Control panel for loading and resetting surface texture.
 * 
 * @author		Konrad Polthier
 * @version		26.09.99, 1.00 revised (kp) <br>
 *					26.09.99, 1.00 created (kp) 
 */
public class PjFractalImage_IP extends PjProject_IP implements ActionListener { 
	protected	PjFractalImage			m_pjTexture;
	protected	PsPanel					m_pSlider;
	protected	Button					m_bReset;

	public PjFractalImage_IP() {
		super();
		if (getClass() == PjFractalImage_IP.class)
			init();
	}
	public void init() {
		super.init();
		addTitle("");

		// draw a separator
		addLine(1);

		m_pSlider = new PsPanel();
		{
			Label lHints = new Label("Hint: Mark/unmark region to zoom into image");
			m_pSlider.add(lHints);
			lHints = new Label("Press 'm' while dragging the region");
			m_pSlider.add(lHints);
		}
		add(m_pSlider);

		// buttons at bottom
		Panel m_pBottomButtons = new Panel();
		m_pBottomButtons.setLayout(new FlowLayout(FlowLayout.CENTER));
		add(m_pBottomButtons);
		m_bReset = new Button("Reset");
		m_bReset.addActionListener(this);
		m_pBottomButtons.add(m_bReset);
	}
	/**
	 * Set parent of panel which supplies the data inspected by the panel.
	 */
	public void setParent(PsUpdateIf parent) {
		super.setParent(parent);
		m_pjTexture = (PjFractalImage)parent;
		m_pSlider.add(m_pjTexture.m_maxNumIter.getInfoPanel());
		m_pSlider.add(m_pjTexture.m_coarseness.getInfoPanel());
	}
	/**
	 * Update the panel whenever the parent has changed somewhere else.
	 * Method is invoked from the parent or its superclasses.
	 */
	public boolean update(Object event) {
		if (PsDebug.NOTIFY) PsDebug.notify("PjFractalImage_IP.update: isShowing = "+isShowing());
		if (m_pjTexture == event) {
			setTitle("Info of "+m_pjTexture.getName());
			return true;
		}
		return super.update(event);
	}
	/**
	 * Handle action events invoked from buttons, menu items, text fields.
	 */
	public void actionPerformed(ActionEvent event) {
		if (m_pjTexture==null)
			return;
		Object source = event.getSource();
		if (source == m_bReset) {
			m_pjTexture.init();
			m_pjTexture.start();
			m_pjTexture.update(this);
		}
	}
}

