package vgp.tutor.lsystem;

/**
 * Generate a tree with a context-free L-system.
 * 
 * @author		Konrad Polthier
 * @version		16.02.00, 1.00 revised (kp)<br>
 *					16.02.00, 1.00 created (kp)
 */
public class LSystem {
	/** Set of available characters. */
	protected	char []		alphabet = {'F', '+', '-', '[', ']'};
	/** Initial configuration of L-system. */
	protected	String		axiom		= "F";
	/**
	 * Production rule of each character of the alphabet. There
	 * must exist one rule per character.
	 */
	protected	String []	rule		= {"F[+F]F[-F]F", "+", "-", "[", "]"};
	/** Container to hold the current state of the L-system. */
	protected	String		tree		= "";
	/**
	 * Generate the tree by applying the rules until the
	 * description has a given length.
	 * @param	maxLength		maximal length of tree until we continue to iterate.
	 */
	public void iterate(int maxLength) {
		tree = new String(axiom);
		while (tree.length() < maxLength) {
			int len = tree.length();
			StringBuffer newTree = new StringBuffer("");
			for (int i=0; i<len; i++) {
				char c = tree.charAt(i);
				for (int j=0; j<alphabet.length; j++) {
					if (c == alphabet[j])
						newTree.append(rule[j]);
				}
			}
			tree = newTree.toString();
		}
	}
	/**
	 * Make the current state of the L-system available, e.g. for
	 * interpreting the string using turtle graphics commands.
	 */
	public String getTree() {
		return tree;
	}
}
