package vgp.tutor.pick;

import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.project.PvPickEvent;
import jv.project.PjProject;
import jv.vecmath.PdVector;
import jvx.geom.PgTube;

/**
 * Project demonstrates the mechanism to pick points on surfaces and handle the callback.
 * 
 * @see			jv.project.PvPickEvent
 * @author		Konrad Polthier
 * @version		10.06.99, 1.01 revised (kp).<br>
 *					10.06.99, 1.00 created (kp)
 */
public class PjPickEvent extends PjProject {
	protected	boolean				m_bShowTorus;
	protected	boolean				m_bShowTube;
	protected	PgElementSet		m_torus;
	protected	PgTube				m_tube;
	protected	PgPolygon			m_knot;

	public PjPickEvent() {
		super("Pick Event");
		PsDebug.setNotify(true);
		m_torus = new PgElementSet(3);
		m_torus.setName("Torus");
		m_knot = new PgPolygon(3);
		m_knot.setName("Curve on Surface");
		m_tube = new PgTube(3);
		m_tube.setName("Tube around Curve");
		m_tube.setPolygon(m_knot);

		if (getClass() == PjPickEvent.class)
			init();
	}
	public void init() {
		super.init();
		m_bShowTorus	= true;
		m_bShowTube		= true;

		m_torus.showElements(false);
		m_torus.computeTorus(10, 10, 2., 1.);
		m_torus.makeQuadrBnd(10, 10);
		m_torus.close();

		m_knot.init();

		m_tube.setDefThickness(0.2);
		m_tube.init();
		m_tube.setPolygon(m_knot);
		m_tube.generateTube();
	}
	public void start() {
		if (PsDebug.NOTIFY) PsDebug.notify("PjPickEvent.start: ");
		addGeometry(m_torus);
		addGeometry(m_knot);
		addGeometry(m_tube);
		selectGeometry(m_torus);
		super.start();
	}
	/**
	 * Update the class whenever a child has changed.
	 * Method is usually invoked from the children.
	 */
	public boolean update(Object event) {
		if (PsDebug.NOTIFY) PsDebug.notify("PjPickEvent.update: called");
		if (event == m_tube) {
			if (PsDebug.NOTIFY) PsDebug.notify("PjPickEvent.update: called with event==m_tube");
			return super.update(null);
		} else if (event == m_knot) {
			if (PsDebug.NOTIFY) PsDebug.notify("PjPickEvent.update: called with event==m_knot");
			return m_tube.update(m_knot);
		}
		return super.update(event);
	}
	public void pickInitial(PvPickEvent pos) {
		if (PsDebug.NOTIFY) PsDebug.notify("PjPickEvent.pickVertex() called");
		int num = m_knot.getNumVertices();
		if (num > 0) {
			PdVector prev = m_knot.getVertex(num-1);
			if (PdVector.sqrDist(prev, pos.getVertex()) < m_torus.getDiameter()/100.)
				return;
		}
		m_knot.addVertex(pos.getVertex());
		m_knot.update(m_knot);
	}
}

