//package jvTim;

import java.applet.Applet;
import java.awt.*;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.*;
import jv.geom.PgElementSet;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.loader.PjMathView;
import jv.loader.PvDisplayLoader;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.*;
import jv.objectGui.GuiStackLayout;
import jv.project.PvDisplayIf;
import jv.project.PgGeometryIf;
import jv.project.PvPickListenerIf;
import jv.viewer.PvViewer;

/**
 * Applet runs javaview with possibility to load geometry models for display.
 * Many projects are pre-installed and may be invoked via menu FILE->NEW PROJECT.
 * <p>
 * If Mathematica Graphics is piped through stdin then javaview
 * converts the inputstream to a geometry objects and displays it.
 * 
 * @see			jv.viewer.PvViewer
 * @author		Konrad Polthier
 * @version		24.11.00, 1.00 revised (kp) <br>
 *					24.11.00, 1.00 created (kp) Taken from current version of javaview.java
 */
public class jvTim extends Applet implements Runnable {
	/** Frame if run standalone, null if run as applet. */
	protected	Frame						m_frame			= null;
	/** 3D-viewer window for graphics output and which is embedded into the applet. */
	protected	PvViewer					m_viewer;
	/** Default display of viewer allows registration of pick listeners. */
	protected	PvDisplayIf				m_disp;

	/** Message string drawn in applet while loading. Modify string with drawMessage(). */
	private		String					m_drawString	= "Initializing ...";
	/** Method added to have better access in J/Link, temporarily. */
	public		PvViewer getViewer() { return m_viewer; }
	/** Interface of applet to inform about author, version, and copyright */
	public String getAppletInfo() {
		return "Name: "		+ this.getClass().getName()+ "\r\n" +
				 "Author: "		+ "Konrad Polthier\r\n" +
				 "Version: "	+ "3.00\r\n" +
				 "Applet/Application for loading most JavaView projects,\r\n" +
				 "and optional Mathematica/Maple/DXF/etc parsing" + "\r\n";
	}
	/**
	 * Create thread that configures and initializes the viewer, loads system and user projects.
	 */
	private Thread thread = null;
	public void init() {
		if (m_frame == null)
			repaint();
		drawMessage("Loading viewer ...");
		m_viewer = new PvViewer(this, m_frame);			// at first initalize the viewer

		thread = new Thread(this, "JavaView: inititialize applet");
		thread.setPriority(Thread.NORM_PRIORITY);
		thread.start();
	}
	
	/**
	 * Configure and initialize the viewer, load system and user projects.
	 * If a geometry model is given as applet parameter or command line argument
	 * then geometry is loaded. Depending on other parameters a panel for browsing
	 * geometry files may be shown close to the display.
	 * <p>
	 * This method may not be called before applet.init().
	 */
	public synchronized void run() {
		if (m_viewer == null) {
			PsDebug.error("must call init() before invoking this method, viewer not instantiated.");
			return;
		}
		String model = null;
		// Toolkit tk = Toolkit.getDefaultToolkit();
		// PsDebug.message("Screen size = "+tk.getScreenSize());

		String codeBase = m_viewer.getParameter("CodeBase");
		if (!(codeBase==null || codeBase.equals(""))) {
			PsDebug.message("encountered external parameter: codebase = "+codeBase);
			PsConfig.setCodeBase(codeBase);
		}

		// Get default display from viewer
		m_disp = m_viewer.getDisplay();
		String dispFile = m_viewer.getParameter("displayFile");
		if (dispFile != null) {
			PvDisplayOption [] dispOption = PvDisplayLoader.read(PsConfig.getCodeBase()+dispFile);
			if (dispOption==null || dispOption.length==0) {
				if (PsDebug.WARNING) PsDebug.warning("reading of display configuration failed, file = "+dispFile);
			} else
				dispOption[0].configure(m_disp);
		}

		// Flag whether specific project is loaded. If false then load default project.
		boolean bDefaultProject = true;
		model = m_viewer.getParameter("Model");
		if (model != null) {
			// Check whether command line argument contains a model.
			PjImportModel prj = new PjImportModel();
			m_viewer.addProject(prj);
			m_viewer.selectProject(prj.getName());
			drawMessage("Loading "+model+" ...");
			// If applet, then use codeBase, if application then use absolut path in local filesystem.
			if (!PsConfig.isApplication()) {
				prj.setFileName(PsConfig.getCodeBase()+model);
				// File is loaded in start() method of project.
				// prj.load(PsConfig.getCodeBase()+model);
				if ("Show".equalsIgnoreCase(getParameter("ProjectPanel"))) {
					if ("Small".equalsIgnoreCase(getParameter("ProjectPanelType"))) {
						prj.setTypeOfInfoPanel(PjImportModel.SMALL_INFO_PANEL);
						setLayout(new BorderLayout());
						add("Center", (Component)m_disp);
						add("South", m_viewer.getPanel(PsViewerIf.PROJECT));
					} else {
						setLayout(new GuiStackLayout(GuiStackLayout.HORIZONTAL));
						add("FILL WIDE*5", (Component)m_disp);
						add("FILL WIDE*4", m_viewer.getPanel(PsViewerIf.PROJECT));
					}
					// Choose initial panel in control window (must press F1 inside the applet)
					m_viewer.showPanel(PsViewerIf.MATERIAL);
				} else {
					setLayout(new BorderLayout());
					add("Center", (Component)m_disp);
				}
			} else {
				// if loading successful, change title of display
				prj.setFileName(model);
				if (prj.load(model) == true)
					PsConfig.getFrame().setTitle(model);
				{
					// HACK: Following call prevents PjImportModel to load model
					// again when its start() method is called.
					prj.setFileName(null);
				}
				setLayout(new BorderLayout());
				add("Center", (Component)m_disp);
			}
			bDefaultProject = false;
		} else if (m_frame!=null && m_viewer.getParameter("File")!=null) {
			// Read Mathematica graphics from stdin.
			BufferedReader bufReader = new BufferedReader(new InputStreamReader(System.in));
			try {
				if (bufReader.ready()) {
					PsDebug.message("Mathematica ready at stdin.");
					PjMathView project = new PjMathView("Import project for Mathematica");
					project.setBufferedReader(bufReader);
					if (project.read()==true) {
						m_viewer.addProject(project);
						m_viewer.selectProject(project.getName());
						setLayout(new BorderLayout());
						add("Center", (Component)m_disp);
						bDefaultProject = false;
					}
				}
			} catch (IOException ex) {
				PsDebug.warning("exception = "+ex.toString());
				PsDebug.message("failed reading Mathematica from stdin.");
			}
		}
		// Load model from a string parameter in the applet of the Html page.
		if ((model=m_viewer.getParameter("mathematica")) != null) {
			if (PsDebug.NOTIFY) PsDebug.notify("Mathematica graphics string encountered = "+model);
			PgGeometryIf [] geomArr = PgLoader.load(null, model, "mgs");
			if (geomArr!=null) {
				for (int i=0; i<geomArr.length; i++)
					m_disp.addGeometry(geomArr[i]);
				bDefaultProject = false;
				// Add display to applet
				setLayout(new BorderLayout());
				add("Center", (Component)m_disp);
			} else
				if (PsDebug.WARNING) PsDebug.warning("Loading of Mathematica data from string failed");
		}
		// Load model from a string parameter in the applet of the Html page.
		if ((model=m_viewer.getParameter("maple")) != null) {
			if (PsDebug.NOTIFY) PsDebug.notify("Maple graphics string encountered = "+model);
			PgGeometryIf [] geomArr = PgLoader.load(null, model, "mpl");
			if (geomArr!=null) {
				for (int i=0; i<geomArr.length; i++)
					m_disp.addGeometry(geomArr[i]);
				bDefaultProject = false;
				// Add display to applet
				setLayout(new BorderLayout());
				add("Center", (Component)m_disp);
			} else
				if (PsDebug.WARNING) PsDebug.warning("Loading of Maple data from string failed");
		}
		if (bDefaultProject) {
			// Just continue with a default model.
			if (PsDebug.NOTIFY) PsDebug.notify("No geometry at stdin nor filename, using default model");
			PgElementSet geom = new PgElementSet(3);			// create a new geometry
			geom.setName("Snail");
			geom.computeSnail(20, 15, 2.);
			geom.makeElementColorsFromXYZ();
			geom.showElementColors(true);

			// Register geometry in display, and make it active.
			// For more advanced applications it is advisable to create a separate project
			// and register geometries in the project via project.addGeometry(geom) calls.
			m_disp.addGeometry(geom);

			// Add display to applet
			setLayout(new BorderLayout());
			add("Center", (Component)m_disp);
		}
		// Layout viewer inside the applet
		validate();

		// Choose initial panel in control window (must press F1 inside the applet)
		m_viewer.showPanel(PsViewerIf.MATERIAL);

		// Explicitly start the applet
		startFromThread();
	}
	/**
	 * Standalone application support. The main() method acts as the applet's
	 * entry point when it is run as a standalone application. It is ignored
	 * if the applet is run from within an HTML page.
	 */
	public static void main(String args[]) {
		jvTim va	= new jvTim();
		// Create toplevel window of application containing the applet
		Frame frame	= new jv.object.PsMainFrame(va, args);
		frame.pack();
		String osName = System.getProperty("os.name");
		if (osName!=null && osName.toLowerCase().startsWith("win")) {
			frame.setBounds(new Rectangle(400, 5, 620, 540));
		} else {
			frame.setSize(620, 540);
		}
		va.m_frame = frame;

		va.init();

		// background="0 0 100" size="1000x700" position="0x0"
		if (va.m_viewer!=null) {
			try {
				String parm = va.m_viewer.getParameter("Size");
				if (parm != null) {
					String [] comp = PuString.splitString(parm, 'x');
					if (comp!=null && comp.length==2) {
						int width	= Integer.parseInt(comp[0]);
						int height	= Integer.parseInt(comp[1]);
						Insets insets = frame.getInsets();
						if (insets != null) {
							frame.setSize(width+insets.left+insets.right,
											  height+insets.top+insets.bottom);
						} else {
							if (PsDebug.WARNING) PsDebug.warning("failed to obtain insets from frame.");
						}
					} else {
						if (PsDebug.WARNING) PsDebug.warning("wrong format in size of display = "+parm);
					}
				}
				parm = va.m_viewer.getParameter("Position");
				if (parm != null) {
					String [] comp = PuString.splitString(parm, 'x');
					if (comp!=null && comp.length==2) {
						int width	= Integer.parseInt(comp[0]);
						int height	= Integer.parseInt(comp[1]);
						frame.setLocation(width, height);
					} else {
						if (PsDebug.WARNING) PsDebug.warning("wrong format in size of display = "+parm);
					}
				}
			} catch (NumberFormatException e) {
				if (PsDebug.WARNING) PsDebug.warning("wrong format in size/position of display");
			}
		}
		frame.setVisible(true);
	}

	/** Set message string to be drawn in apllet while loading. */
	private void drawMessage(String message) {
		m_drawString = message;
		repaint();
	}
	/** Print info while initializing applet and viewer. */
	public void paint(Graphics g) {
		g.setColor(Color.blue);
		g.drawString(PsConfig.getProgram()+" v."+PsConfig.getVersion(), 20, 40);
		g.drawString(m_drawString, 20, 60);
	}
	/**
	 * Switch state of the geometry.
	 * @return		<code>false</code> if same instance already registered.
	 * @see			#removePickListener(PvPickListenerIf)
	 */
	public void flipNormals() {
		try {
			// Wait until other thread has created the display,
			// but do not wait too long ...
			int cnt = 0;
			while (m_disp==null && cnt<5) {
				cnt++;
				Thread.sleep(1000);
			}
		} catch (InterruptedException ex) {}
		PgGeometryIf geom = m_disp.getSelectedGeometry();
		if (geom != null) {

			if (geom instanceof PgElementSet) {
			    		    System.out.println("FLIPP");

				PgElementSet es = (PgElementSet)geom;
				//es.showVertexNormals(!es.isShowingVertexNormals());
				es.showElementNormals(!es.isShowingElementNormals());
				System.out.println(es.isShowingElementNormals());
				es.update(es);
			}
		}
	}
	/**
	 * Add pick listener to receive pick events {@link jv.project.PvPickEvent PvPickEvent}
	 * to the default display.
	 * 
	 * @param		PickListenerIf
	 * @return		<code>false</code> if same instance already registered.
	 * @see			#removePickListener(PvPickListenerIf)
	 */
	public void addPickListener(PvPickListenerIf listener) {
		try {
			while (m_disp == null)
				Thread.sleep(1000);
			/*
				PsDebug.warning("missing display");
				return;
			}
			*/
		} catch (InterruptedException ex) {}
		m_disp.addPickListener(listener);
	}
	/**
	 * Remove a registered listener from list of registered listeners.
	 *
	 * @param		PickListenerIf
	 * @return		<code>false</code> if listener does not exists.
	 * @see			#addPickListener(PvPickListenerIf)
	 * @see			#hasPickListener(PvPickListenerIf)
	 */
	public boolean removePickListener(PvPickListenerIf listener) {
		if (m_disp == null) {
			PsDebug.warning("missing display");
			return false;
		}
		return m_disp.removePickListener(listener);
	}
	/**
	 * Does clean-up when applet is destroyed by the browser.
	 * Here we just close and dispose all our control windows.
	 */
	public void destroy()			{ if (m_viewer != null) m_viewer.destroy(); }
	/** Stop viewer, e.g. stop animation if requested */
	public void stop()				{ if (m_viewer != null) m_viewer.stop(); }
	/**
	 * Start viewer, e.g. start animation if requested.
	 * Necessary, if initialization is done in a separate thread. In this case the original
	 * applet.start() has no effect.
	 */
	public void startFromThread()	{ if (m_viewer!=null) m_viewer.start(); }
}
