#include <stdio.h>
#include <math.h>

#define ABS(X)      ((X) < 0.0 ? -(X) : (X))

main (argc, argv)
     int argc;
     char **argv;
{
  int nlayers;
  FILE *fp;
  float theta [20];
  float thickness [20];
  float value [20];
  float medulla;
  float ratio;
  float radius;
  int   nstrands [20], height [20];

  int i;

  fp = fopen (argv [1], "r");

  fscanf (fp, "%d", &nlayers);

  for (i = 0; i < nlayers; i++) 
    fscanf (fp, "%d", nstrands + i);

  for (i = 0; i < nlayers; i++) 
    fscanf (fp, "%d", height + i);

  for (i = 0; i < nlayers; i++) 
    fscanf (fp, "%f", value + i);

  for (i = 0; i < nlayers; i++) 
    fscanf (fp, "%f", theta + i);

  for (i = 0; i < nlayers; i++)
    fscanf (fp, "%f", thickness + i);

  fscanf (fp, "%f", &medulla);
  fscanf (fp, "%f", &ratio);

  fprintf (stderr, "\n");
  fprintf (stderr, "\n");
  for (i = 0; i < nlayers; i++) 
    fprintf (stderr, "  %4d  ", i + 1);

  fprintf (stderr, "\n");

  for (i = 0; i < nlayers; i++) {
    fprintf (stderr, "%8.2f", value [i]);
  }
  
  fprintf (stderr, "\n");

  for (i = 0; i < nlayers; i++) {
    fprintf (stderr, "  %5.0f", ABS (theta [i]));
    if (theta [i] < 0.0) 
      fprintf (stderr, "L");
    else
      fprintf (stderr, "R");
  }

  fprintf (stderr, "\n");

  for (i = 0; i < nlayers; i++) {
    fprintf (stderr, "%8.1f", thickness [i]);
  }
  
  fprintf (stderr, "\n");

  fprintf (stderr, "         %8.0f     %8.1f\n", medulla, ratio);
  fprintf (stderr, "\n");

  

  printf ("%d\n%.2f\n", nlayers, ratio);

  radius = medulla / 2.0 + thickness [0] / 2.0;
  for (i = 0; i < nlayers; i++) {
    printf ("%d %.2f %.2f %.0f %d %.2f\n", 
	    nstrands [i], 
	    radius, thickness [i] / 2.0, -theta [i], 
	    height [i], value [i]);
    radius += (thickness [i] + thickness [i + 1]) / 2.0;
  }
}

