#include <math.h>
#include <stdio.h>

#define PI           3.14159265358979323846
#define TWOPI        6.28318530717958647693
#define PIBY2        1.57079632679489661923
#define DEG_TO_RAD   0.0174532925199432957692  /*  (PI / 180)  */
#define RAD_TO_DEG   57.2957795130823208768    /*  (180 / PI)  */


int group = 0;

#define MAXGR 102

float r_s [MAXGR], value [MAXGR];
int first [MAXGR];
int last  [MAXGR];

float aspect;
int luxo = 0;

int totnumcomp = 0;
int totnumbeads = 0;

main (argc, argv)
     int argc;
     char **argv;
{
  FILE *fp;
  int N, n, i, nb;
  float d, r, alpha, ytrans = 0.0;
  float hue, hincr, scale = .25, try = .3;

  fp = stdin;
  if (!fp) exit ();

  if (argc > 1) 
    luxo = atoi (argv [1]);
  if (argc > 2)
    ytrans = atof (argv [2]);
  if (argc > 3)
    scale = atof (argv [3]);
  if (argc > 4)
    try = atof (argv [4]);

  if (luxo)
    fprintf (stderr, "Luxo drawing\n");
  else
    fprintf (stderr, "Draft drawing\n");

  fscanf (fp, "%d", &N);
  fscanf (fp, "%f", &aspect);

  fprintf (stderr, "aspect = %f\n", aspect);

  put ("delete all");
  put ("new = f");
  put ("line dir 0 1 0");
  put ("open = t");
  put ("sat = 0.0");
  put ("drecap = f");
  printf ("scale = %f\ntry = %f\n", scale, try);

  for (i = 0; i < N; i++) {
    fscanf (fp, "%d%f%f%f%d%f", &n, &d, &r, &alpha, &nb, value + i);
    if (!luxo && n > 20) n = 20;
    make_layer (n, d / 10.0, r / 10.0, alpha, nb);
    totnumcomp += n;
    totnumbeads += n * nb;
  }
  
  put ("delete all");

  put ("Draw = f");

  
  for (i = group - 1; i >= 0; i--) 
    printf ("load comb hoof.%d.dum\n", i);

  for (i = 0; i < group; i++)
    printf ("mcyl %d %d %f\n", first [i], last [i], r_s [i]);


  put ("info");
  if (ytrans != 0.0)
    printf ("translate 0 %f 0\n", ytrans);
/*
  if (aspect != 1.0)
    printf ("scale %f 1 1\n", aspect);
*/

  if (aspect != 1.0)
    printf ("nonp 1 1 %f\n", 1.0 / aspect);

  put ("Draw = t");

  fprintf (stderr, "Total num comp = %d, beads = %d\n",
	   totnumcomp, totnumbeads);

  fclose (fp);

  fp = fopen ("cdum", "w");
  
  fprintf (fp, "delete all\nmcyl off\nDraw=f\nsbuff\nclear\ndisp t\ndisp t\n");
  fprintf (fp, "clear 3\nhincr=0\nauto=f\n\n");
  fprintf (fp, "scale = %f\ntry = %f\n", scale, try);


  for (i = 0; i < group; i++) {
    fprintf (fp, "cyl = %f\nvalue = %f\n", r_s [i], value [i]);
    fprintf (fp, "load hoof.%d.dum\n", i);
    fprintf (fp, "translate 0 %f 0\n", ytrans);
/*
   if (aspect != 1.0)
      fprintf (fp, "scale %f 1 1\n", aspect);
*/
    if (aspect != 1.0)
      fprintf (fp, "nonp 1 1 %f\n", 1.0 / aspect);
    fprintf (fp, "disp t, del all\n\n");
  }

  fclose (fp);
  
}


put (c)
  char *c;
{
  printf ("%s\n", c);
}



make_layer (n, d, r, alpha, nb)
     int n, nb;
     float d, r, alpha;
{
  float theta, theta_inc;
  int i;
  static int ncomps = 0;

  extern float f ();

  put ("delete all");
  printf ("line num %d\n", nb);
  put ("Draw = f");

  theta_inc = TWOPI / (float) n;

  for (i = 0, theta = 0.0; i < n; i++, theta += theta_inc) 
    printf ("line %f %f %f\n", 
	    d * cos (theta),
	    -5.0,
	    d * sin (theta));

  printf ("swirl %f\n", f (alpha, d));
  printf ("save hoof.%d.dum\n", group);
  put ("Draw = t");
  
  r_s [group] = r;
  first [group] = ncomps;
  last [group] = ncomps + n - 1;

  group++;

  ncomps += n;
}


float f (old_x, R)
     float old_x, R;
{
  float s, x;

  /*
  x = RAD_TO_DEG * atan (tan (DEG_TO_RAD * old_x) / aspect);
  */
  x = old_x;

  printf ("%% angles: old %f   new %f\n", old_x, x);
  if (x == 0.0)
    s = 0.0;
  else
    s = RAD_TO_DEG / (R * tan (PIBY2 - DEG_TO_RAD * x));
  

  return s;
}



  
  
