#include <stdio.h>
#include <ctype.h>

char comment [200];

#define is_section(x,y) (!strncmp(x,y,4))
#define TRUE  1
#define FALSE 0

main (argc, argv)
     char **argv;
     int argc;
{
  int c = 1;

  if (argc < 2) {
    fprintf (stderr, "Usage: %s  file1 file2 ... fileN > newfile\n", argv [0]);
    exit (1022);
  }

  fprintf (stdout, "KnotPlot 1.0  %c\n", (char) 12);  /* Control-L */
  while (c < argc) copy_file (argv [c++]);
  fprintf (stdout, "endf\n\n\n\n");
}

copy_file (file_name) 
     char *file_name;
{
  char sname [5];
  long num_to_skip, data_value;
  FILE *fp;
  
  fp = fopen (file_name, "r");
  
  /* Determine what kind of file it is. */

  fread (comment, 12, 1, fp);
  fprintf (stderr, "copying %s\n", file_name);

  if (strncmp (comment, "KnotPlot 1.0", 12)) {
    fclose (fp);
    fprintf (stderr, "File `%s' is not a KnotPlot file.\n", 
	     file_name);
    return;
  }

  /* If we get this far, then we have a KnotPlot 1.0 format file. */
  /* Scan to control L and then read one character. */

  while (fgetc (fp) != 12);  /* Empty loop. */
  fgetc (fp);                /* This character is arbitrary. */

  do {
    if (fread (sname, 1, 4, fp) != 4) {
      fprintf (stderr, " *** End of data before end of file `%s'.\n",
	       file_name);
      exit (1022);
    }
    sname [4] = '\0';

    if (is_section (sname, "endf")) {
      fclose (fp); return;
    }

    printf ("%s", sname);
    if (isupper (sname [0])) {
      if (isupper (sname [1])) {
	fread  (&num_to_skip, 4, 1, fp);
	fwrite (&num_to_skip, 4, 1, stdout);
	while (num_to_skip--) 
	  fputc (fgetc (fp), stdout);
      }
      else {
	fread  (&data_value, 4, 1, fp);
	fwrite (&data_value, 4, 1, stdout);
      }
    }
  } while (TRUE);
  
}



