package vgp.tutor.key;

import java.applet.Applet;
import java.awt.*;
import java.util.Date;

import jv.object.*;
import jv.viewer.PvViewer;

/**
 * Applet demonstrates the use of Keyframes to view a sequence of geometry files.
 * 
 * @see			jv.viewer.PvViewer
 * @author		Konrad Polthier
 * @version		23.10.99, 1.10 revised (kp) Argument of project removed.<br>
 *					19.07.99, 1.01 revised (kp) Start a thread during initialization.<br>
 *					30.06.99, 1.00 created (kp)
 */
public class PaKeyframe extends Applet implements Runnable {
	/** frame if run standalone, null if run as applet */
	public		Frame				m_frame			= null;
	/** 3D-viewer window for graphics output and which is embedded into the applet */
	protected	PvViewer			m_viewer;

	/** Applet parameters: {"Name", "Typ", "Default value", "Description"} */
	protected	String [][]	m_parm = {
		{"Console",	"String", "Hide",		"Show/Hide VGP-console for debugging"},
		{"Control",	"String", "Hide",		"Show/Hide control panel"},
		{"Frame",	"String", "Hide",		"Show/Hide frame around applet"},
		{"Panel",	"String", "Project",	"Name of initial panel if control panel is showing"}
	};

	/**
	 * Store time of construction to determine length of loading process.
	 * Length of loading process is printed to Java Console, not to JavaView Console.
	 * Time does not include the time needed for loading the system Java runtime environment.
	 */
	private		long				m_initTime		= (new Date()).getTime();
	/**
	 * Message string drawn in applet while loading. Modify string with drawMessage().
	 */
	private		String			m_drawString	= "Initializing ...";

	/**
	 * Interface used by design tools to show properties of applet.
	 * This method returns a list of string arrays, each of length 4 rather than 3
	 * as suggested by Java. The additional string at third position contains
	 * the value of the parameter.
	 * @see		jv.viewer.PvViewer#getParameter(String)
	 */
	public String[][] getParameterInfo() { return m_parm; }

	/** Interface of applet to inform about author, version, and copyright */
	public String getAppletInfo() {
		return "Name: "		+ this.getClass().getName()+ "\r\n" +
				 "Author: "		+ "Konrad Polthier" + "\r\n" +
				 "Version: "	+ "1.10" + "\r\n" +
				 "Demo applet showing a keyframe animation." + "\r\n";
	}
	/**
	 * Create thread that configures and initializes the viewer, loads system and user projects.
	 */
	public void init() {
		Thread thread = new Thread(this, "JavaView: inititialize applet");
		thread.setPriority(Thread.NORM_PRIORITY);
		thread.start();
	}
	/**
	 * Configure and initialize the viewer, load system and user projects.
	 * One of the user projects may be selected here.
	 */
	public void run() {
		drawMessage("Loading viewer ...");
		m_viewer = new PvViewer(this, m_frame);			// at first initalize the viewer

		drawMessage("Loading geometry ...");
		// Get parameter values from HTML page, or take default value
		String model = m_viewer.getParameter("Model");
		if (model != null)
			model = PsConfig.getCodeBase()+model;
		// Get number of keyframes
		String sNumber = m_viewer.getParameter("Number");
		int number = 0;
		if (sNumber != null) {
			try {
				number = Integer.parseInt(sNumber);
			} catch (NumberFormatException ne) {
				if (PsDebug.WARNING) PsDebug.warning("error parsing number of keys = "+sNumber);
				return;
			}
		}
		// Create and load a project
		PjKeyframe test = new PjKeyframe();
		test.setFileName(model, number);
		m_viewer.addProject(test);
		m_viewer.selectProject(test.getName());

		// Get 3d display from viewer and add it to applet
		setLayout(new BorderLayout());
		add("Center", (Component)m_viewer.getDisplay());
		validate();

		// Choose initial panel in control window (must press F1 inside the applet)
		m_viewer.showPanel(PsViewerIf.MATERIAL);

		// Explicitly call the applet.start()
		startFromThread();

		System.out.println("Applet loading completed after "+
								 ((new Date()).getTime()-m_initTime)+"ms");
	}
	/**
	 * Standalone application support. The main() method acts as the applet's
	 * entry point when it is run as a standalone application. It is ignored
	 * if the applet is run from within an HTML page.
	 */
	public static void main(String args[]) {
		PaKeyframe va	= new PaKeyframe();
		// Create toplevel window of application containing the applet
		Frame frame	= new jv.object.PsMainFrame(va, args);
		frame.pack();
		va.m_frame = frame;
		va.init();
		va.start();
		frame.setBounds(new Rectangle(420, 5, 640, 550));
		frame.setVisible(true);
	}
	/** Set message string to be drawn in apllet while loading. */
	private void drawMessage(String message) {
		m_drawString = message;
		repaint();
	}
	/** Print info while initializing applet and viewer. */
	public void paint(Graphics g) {
		g.setColor(Color.blue);
		g.drawString(PsConfig.getProgram()+" v."+PsConfig.getVersion(), 20, 40);
		g.drawString(m_drawString, 20, 60);
	}
	/**
	 * Does clean-up when applet is destroyed by the browser.
	 * Here we just close and dispose all our control windows.
	 */
	public void destroy()	{ if (m_viewer != null) m_viewer.destroy(); }

	/** Stop viewer, e.g. stop animation if requested */
	public void stop()		{ if (m_viewer != null) m_viewer.stop(); }
	/**
	 * Start viewer, e.g. start animation if requested.
	 * Necessary, if initialization is done in a separate thread. In this case the original
	 * applet thread might call applet.start() too early.
	 */
	public void startFromThread() { if (m_viewer!=null) m_viewer.start(); }
}
