Sub Main

' Output Set Variables
Dim setID as Long
Dim Title as String * 25
Dim from_program as Long
Dim anal_type as Long
Dim setValue as Double

' Output Vector Variables
Dim vectorID as Long
Dim vectorTitle as String * 25

' "Global" Variables
Dim Msg
Dim j as Long
Dim k as Long
Dim l as Long
Dim nodecount as Long
Dim nodevalue as Double
Dim nodeID as Long
Dim st as String


' Initialize Output Set Values
setID = 1
Title = "BASIC Script Set"
from_program = FEMAP
anal_type = NONLINSTATIC
setValue = 1.455

' Initialize Output Vector Values
vectorID = 300000
vectorTitle = "Nodal Temperature Data"


' First Create an Empty Output Set

j = esp_OutpCreateSet( setID, from_program, anal_type, setValue, Title )

If j = TRUE Then
	Msg = "Created Output Set " + Str(setID)
Else
	Msg = "Could Not Create Output Set " + Str(setID)
End If

Print Msg

' Now Create an Empty Output Vector

j = esp_OutpCreateVector( setID, vectorID, Temp, Node, VectorTitle )

If j = TRUE Then
	Msg = "Created Output Vector " + Str(vectorID)
Else
	Msg = "Could Not Create Output Vector " + Str(vectorID)
End If

Print Msg

If j = TRUE Then
	' Open the data file
	Open "outp_2.dat" for Input as #1
	Line Input #1, st
	ret_val = esp_MiscParseInit( st )
	ret_val = esp_MiscParseInt( 1, nodecount )
	If ret_val = TRUE Then
		For k = 1 to nodecount
		Line Input #1, st
		ret_val = esp_MiscParseInit( st )
		ret_val = esp_MiscParseInt( 1, nodeID )
		ret_val = esp_MiscParseDouble( 2, nodevalue )
		l = esp_OutpPutData( setID, vectorID, nodeID, nodevalue )
		Next k
	End If
	ret_val = esp_OutpVectorFinish( setID, vectorID )
End If

Close #1

End Sub