Sub Main

' Output Set Variables
Dim setID as Long
Dim Title as String * 25
Dim from_program as Long
Dim anal_type as Long
Dim setValue as Double

' "Global" Variables
Dim Msg
Dim j as Long
Dim k as Long
Dim l as Long
Dim nodecount as Long
Dim nodevalue as Double
Dim nodeID as Long
Dim st as String


' Initialize Output Set Values
setID = 1
Title = "BASIC Script Set"
from_program = FEMAP
anal_type = STAT
setValue = 0.0

' First Create an Empty Output Set

j = esp_OutpCreateSet( setID, from_program, anal_type, setValue, Title )

If j = TRUE Then
	Msg = "Created Output Set " + Str(setID)
Else
	Msg = "Could Not Create Output Set " + Str(setID)
End If

Print Msg


' Now Create the Component Vectors
' Bad programming practice, but we will assume that the creation will
' happen and not fail.
j = esp_OutpCreateVector( setID, 300001, Disp, Node, "X-Value" )
j = esp_OutpCreateVector( setID, 300002, Disp, Node, "Y-Value" )
j = esp_OutpCreateVector( setID, 300003, Disp, Node, "Z-Value" )

l = esp_OutpPutData( setID, 300001, 1, .125 )
l = esp_OutpPutData( setID, 300002, 1, .25 )
l = esp_OutpPutData( setID, 300003, 1, .375 )
l = esp_OutpPutData( setID, 300001, 2, .5 )
l = esp_OutpPutData( setID, 300002, 2, .25 )
l = esp_OutpPutData( setID, 300003, 2, .375 )

' Start FEMAP Internal Cleanup of Vectors

ret_val = esp_OutpVectorFinish( setID, 300001 )
ret_val = esp_OutpVectorFinish( setID, 300002 )
ret_val = esp_OutpVectorFinish( setID, 300003 )
ret_val = esp_OutpCreateVectorVectorSum( setID, 300000, 300001, 300002, 300003, Disp, Node, "Vector Sum" )
ret_val = esp_OutpVectorFinish( setID, 300000 )

End Sub