Sub Main

' Output Set Variables
Dim setID as Long
Dim Title as String * 25
Dim from_program as Long
Dim anal_type as Long
Dim setValue as Double

' Output Vector Variables
Dim vectorID as Long
Dim vectorTitle as String * 25

' "Global" Variables
Dim Msg
Dim j as Long
Dim k as Long
Dim l as Long
Dim m as Long
Dim nodecount as Long
Dim nodevalue as Double
Dim nodeID as Long
Dim st as String


' Initialize Output Set Values
setID = 1
Title = "BASIC Script Set"
from_program = FEMAP
anal_type = STAT
setValue = 0.0

' First Create an Empty Output Set

j = esp_OutpCreateSet( setID, from_program, anal_type, setValue, Title )

If j = TRUE Then
	Msg = "Created Output Set " + Str(setID)
	Print Msg
Else
	Msg = "Could Not Create Output Set " + Str(setID)
	Print Msg
	GoTo Failed
End If

' First, we will create the element centroidal vector

j = esp_OutpCreateVector( setID, 7033, Stress, Elem, "Plt. Top VonMises Stress" )

If j =  TRUE Then
	Msg = "Created Centroidal Vector"
	Print Msg
Else
	Msg = "Error Creating Centroidal Vector"
	Print Msg
	GoTo Failed
End If

' now create the corner vectors

j = esp_OutpCreateVector( setID, 20133, Stress, Elem, "Plt. Top VonMises Str C1" )
k = esp_OutpCreateVector( setID, 30133, Stress, Elem, "Plt. Top VonMises Str C2" )
l = esp_OutpCreateVector( setID, 40133, Stress, Elem, "Plt. Top VonMises Str C3" )
m = esp_OutpCreateVector( setID, 50133, Stress, Elem, "Plt. Top VonMises Str C4" )

If j =  TRUE Then
	Msg = "Created Corner 1 Vector"
	Print Msg
Else
	Msg = "Error Creating Corner 1 Vector"
	Print Msg
	GoTo Failed
End If

If k =  TRUE Then
	Msg = "Created Corner 2 Vector"
	Print Msg
Else
	Msg = "Error Creating Corner 2 Vector"
	Print Msg
	GoTo Failed
End If

If l =  TRUE Then
	Msg = "Created Corner 3 Vector"
	Print Msg
Else
	Msg = "Error Creating Corner 3 Vector"
	Print Msg
	GoTo Failed
End If

If m =  TRUE Then
	Msg = "Created Corner 4 Vector"
	Print Msg
Else
	Msg = "Error Creating Corner 4 Vector"
	Print Msg
	GoTo Failed
End If

' Set up Corner Pointers on Centroidal Vector

j = esp_OutpSetVectorComponent( setID, 7033, 0, 20133 )
If j = FALSE Then
	Msg = "Error Setting Corner Reference"
	Print Msg
	GoTo Failed
End If

j = esp_OutpSetVectorComponent( setID, 7033, 1, 30133 )
If j = FALSE Then
	Msg = "Error Setting Corner Reference"
	Print Msg
	GoTo Failed
End If

j = esp_OutpSetVectorComponent( setID, 7033, 2, 40133 )
If j = FALSE Then
	Msg = "Error Setting Corner Reference"
	Print Msg
	GoTo Failed
End If

j = esp_OutpSetVectorComponent( setID, 7033, 3, 50133 )
If j = FALSE Then
	Msg = "Error Setting Corner Reference"
	Print Msg
	GoTo Failed
End If

' Also need to set the Centroidal Flag to indicate that the corner
' vectors contain corner data.

j = esp_OutpSetVectorCentroidalFlag( setID, 20133, 0 )
If j = FALSE Then
	Msg = "Error Setting Centroidal Flag"
	Print Msg
	GoTo Failed
End If

j = esp_OutpSetVectorCentroidalFlag( setID, 30133, 0 )
If j = FALSE Then
	Msg = "Error Setting Centroidal Flag"
	Print Msg
	GoTo Failed
End If

j = esp_OutpSetVectorCentroidalFlag( setID, 40133, 0 )
If j = FALSE Then
	Msg = "Error Setting Centroidal Flag"
	Print Msg
	GoTo Failed
End If

j = esp_OutpSetVectorCentroidalFlag( setID, 50133, 0 )
If j = FALSE Then
	Msg = "Error Setting Centroidal Flag"
	Print Msg
	GoTo Failed
End If

' Now pump in the data, 
' this script assumes there are two elements, 1 and 2
' and 6 nodes, 1 through 6

l = esp_OutpPutData( setID, 7033, 1, 600 ) ' Center, Elem 1
l = esp_OutpPutData( setID, 7033, 2, 800 ) ' Center, Elem 2

l = esp_OutpPutData( setID, 20133, 1, 100 ) ' C1 E1
l = esp_OutpPutData( setID, 30133, 1, 200 ) ' C2 E1
l = esp_OutpPutData( setID, 40133, 1, 500 ) ' C3 E1
l = esp_OutpPutData( setID, 50133, 1, 400 ) ' C4 E1

l = esp_OutpPutData( setID, 20133, 2, 200 ) ' C1 E2
l = esp_OutpPutData( setID, 30133, 2, 300 ) ' C2 E2
l = esp_OutpPutData( setID, 40133, 2, 600 ) ' C3 E2
l = esp_OutpPutData( setID, 50133, 2, 500 ) ' C4 E2

ret_val = esp_OutpVectorFinish( setID, 20133 )
ret_val = esp_OutpVectorFinish( setID, 30133 )
ret_val = esp_OutpVectorFinish( setID, 40133 )
ret_val = esp_OutpVectorFinish( setID, 50133 )
ret_val = esp_OutpVectorFinish( setID, 7033 )
GoTo Success:

Failed:

Msg = "Error Executing Script File"
Print Msg

Success:

End Sub
