VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   3  'Fester Dialog
   Caption         =   "berfallwehr Kreisquerschnitt (smtl. Details entstehen zur Laufzeit!)"
   ClientHeight    =   4545
   ClientLeft      =   1680
   ClientTop       =   1470
   ClientWidth     =   8280
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'ZReihenfolge
   ScaleHeight     =   4545
   ScaleWidth      =   8280
   ShowInTaskbar   =   0   'False
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Const g = 9.81    'Erdbeschleunigung in m/s^2
Const R = 1       'Radius des Wehrs in m
Const hmax = 0.8  'Maximale Wassersule in m
Dim h0!, dh!, xl!
Dim Vges1!, Vges2!, Vges3!, Vsp!
Dim sHydr!, maxSchicht!, xS!, Ss!

Private Sub Form_Activate()
  Scale (-1.1, 0.1)-(1.1, -1.1)
  h0 = R - hmax        'Abstand freier Spiegel bis Wehrmitte
  dh = hmax / 1000     'Schichtendicke in m bei 1000 Schichten
  Call Startbild
  Call Rechnen
  Call AusgabeBox
  Call Grafik_Ergnzen
  
End Sub

Private Sub Form_Click()
  End
End Sub

Public Sub Startbild()
  '*)-- Achsenkreuz und Wehrradius --
  Line (0, 0.1)-(0, -1.1 * R), QBColor(15)  'senkr. Achse
  Line (-R, 0)-(R, 0), QBColor(15)          'waagerechte Achse
  Circle (0, 0), R, QBColor(0), 3.12, 0.2   'Kreisbogen Wehr
  '*)-- Lage des freien Spiegels --
  xl = Sqr(R ^ 2 - h0 ^ 2)                  'Halbe Breite freier Spiegel
  Line (-xl, -h0)-(xl, -h0), QBColor(2)
  '*)-- Symbol fr freien Spiegel (Dreieck) --
  Line (0.3, -h0 + 0.07)-(0.4, -h0 + 0.07), QBColor(4)
  Line (0.3, -h0 + 0.07)-(0.35, -h0 + 0.005), QBColor(4)
  Line (0.4, -h0 + 0.07)-(0.35, -h0 + 0.005), QBColor(4)
End Sub

Public Sub Rechnen()
 '*)-- Schleife (Volumen 1) --
 For h = h0 To R Step dh
   Y = Sqr(R ^ 2 - h ^ 2)
   dA = 2 * Y * dh   'Rechteckstreifenflche
   A = A + dA        'Summiert Streifenflchen zur Gesamtflche
   dM = dA * h       'Berechnet Teilflchenmoment
   M = M + dM        'Summiert Flchenmomente zum Gesamtmoment
   w = Sqr(2 * g * (h - h0 + dh / 2)) 'mittlere Strmungsgeschwindigkeit
   dV = dA * w        'Teilvolumen
   Vges1 = Vges1 + dV 'Summiert Teilvolumen
 Next
 '*)-- Schleife fr Nherung Volumen 2, y*SQR(x)-Kurve --
 For h = -h0 To -R Step -dh
  Y = Sqr(R ^ 2 - h ^ 2)     'Abstand von h-Achse bis Wehrrand
  X = Abs(h) - h0 + dh / 2   'Abstand Schichtmitte bis freier Spiegel
  z = Sqr(X)                 'Wurzel aus dem Abstand x
  yKurve = Y * z             'Abstand von h-Achse bis Kurve
  df = yKurve * dh           'Flchenstreifen unter Kurve
 Do
  If Marke$ = "#" Then Exit Do
  If yKurve <= dSp Then
    Beep                     'Piepston bei Maximum
    Marke$ = "#"             'Setzt Marke$ auf "#"
    sHydr = h                'Lage des max. Schichtenvolumens
    ymax = yKurve            'Max. yKurve
  End If
  dSp = yKurve               'Bestimmt Maximum der Kurve
 Loop While Marke$ = "#"
  Vf = Vf + df               'Summiert Flche (Planimetrieren)
  xWand = Sqr(R ^ 2 - h ^ 2)
  Line (-xWand, h)-(xWand, h), RGB(20, 50, 250) 'Markiert Flssigkeitsquerschnitt
  Line (0, h)-(yKurve, h), RGB(10, 200, 80) 'Markiert Feld unter der Kurve
  PSet (yKurve, h), QBColor(13)         'Zeichnet Kurvenpunkt
  PSet (z, h), QBColor(15)              'Zunahme Schichtgeschw. (Tendenz)
  PSet (Y, h), QBColor(14)              'Abnahme Querschnittflche
  Line (0, sHydr)-(ymax, sHydr), QBColor(11)  'Markiert Schicht-Maximum
 Next
 Vges2 = Vf * Sqr(2 * g) * 2            'Bestimmt Vges2
 '*)-- Flchenschwerpunkt, Geschw. dort, Volumen 3 --
  xS = M / A - h0         'Abstand Schwerpunkt bis freier Spiegel
  wSP = Sqr(2 * g * xS)   'Geschwindigkeit im Schwerpunkt
  Vsp = A * wSP           'Nherungsvolumen 3
  maxSchicht = sHydr + h0 'Lage der max. Schixhtenstrmung
  Ss = -xS - h0           'fr Schwerpunktlage
End Sub

Public Sub Grafik_Ergnzen()
  Form1.FontSize = 10
  '*)-- Rechtwinkliges Dreieck fr R, yl, h0 --
  Line (-0.002, 0)-(-0.002, -h0 + 0.005), QBColor(10)
  Line (0, 0)-(-xl, -h0 + 0.005), QBColor(10)
  Line (0, -h0 + 0.002)-(-xl, -h0 + 0.002), QBColor(10)
  '*)-- Lage der Bezeichnungen am Pyth-Dreieck --
  CurrentX = -0.5: CurrentY = -0.04: Print "R"
  CurrentX = 0.01: CurrentY = -0.05: Print "h0"
  CurrentX = -0.5: CurrentY = -0.2: Print "xl"
  '*)-- Punkte auf senkrechter h-Achse --
  Line (0, 0.3)-(0, -R), QBColor(15)     'senkr. Achse neu zeichnen
   For Y = 0 To -(R + 0.05) Step -0.05
     i = i + 1
     If i / 2 <> Int(i / 2) Then
       Line (-0.01, Y)-(0, Y), QBColor(15)
     Else
       Line (-0.005, Y)-(0, Y), QBColor(15)
     End If
   Next
  '*)-- Benennung an Kurven schreiben --
  CurrentX = 0.82: CurrentY = -0.8: ForeColor = QBColor(0): Print "v"
  CurrentX = 0.82: CurrentY = -0.6: ForeColor = QBColor(0): Print "A"
  '*)-- Markiert Schwerpunktlage auf h-Achse --
   For Rk = 0 To 0.015 Step 0.001
     Circle (0, Ss), Rk, QBColor(4)
   Next
   Circle (0, Ss), Rk, QBColor(15)
   CurrentX = 0.02: CurrentY = Ss: ForeColor = QBColor(15): Print "S"
  'Ausdruck des Hinweises "Beenden mit..." auf Formular
   With Form1
    .FontSize = 10          'Schriftgre
    .FontName = "Arial"     'Schriftart
    .FontBold = True        'Fett
    .FontUnderline = True   'unterstrichen
   End With
   CurrentX = 0.1: CurrentY = -1: ForeColor = QBColor(12):
   Print "Beenden mit Klick auf Form"
  Form1.Caption = "berfallwehr Kreisquerschnitt: In Prozeduren aufgebaut"
End Sub

Public Sub AusgabeBox()
  '*)-- Rahmen um Ergebnisausdruck --
  Line (-1, -0.6)-(-0.1, -1), QBColor(8), BF
  '*)-- Ausgabe Volumen 1 --
  Form1.FontSize = 8
  ForeColor = QBColor(15)
  Vges1 = Format$(Vges1, "#.##0")
  CurrentX = -1: CurrentY = -0.6: ForeColor = QBColor(15):
  Print " Volumen 1 (1.Nherung) = "; Vges1; " m^3/s"
  '*)-- Ausgabe Volumen 2 --
  Vges2 = Format$(Vges2, "#.##0")
  CurrentX = -1: CurrentY = -0.66: ForeColor = QBColor(15):
  Print " Volumen 2 (2.Nherung) = "; Vges2; " m^3/s"
  '*)-- Ausgabe Volumen 3 und anderes --
  Vsp = Format$(Vsp, "#.##0")
  CurrentX = -1: CurrentY = -0.72: ForeColor = QBColor(15):
  Print " Volumen 3 (3.Nherung) = "; Vsp; " m^3/s"
  CurrentX = -1: CurrentY = -0.8: ForeColor = QBColor(15):
  maxSchicht = Format$(maxSchicht, "0.##0")
  Print " Maximales Schichtenvolumen bei "; maxSchicht; " m"
  xS = Format$(-xS, "0.##0")
  CurrentX = -1: CurrentY = -0.88: ForeColor = QBColor(15):
  Print " Lage Flchenschwerpunkt      bei "; xS; " m"
End Sub

