VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Torsionskraftverlauf Zweitakt - Motor"
   ClientHeight    =   6240
   ClientLeft      =   1770
   ClientTop       =   1530
   ClientWidth     =   8475
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   PaletteMode     =   1  'ZReihenfolge
   ScaleHeight     =   6240
   ScaleWidth      =   8475
   Begin VB.CommandButton Command4 
      Caption         =   "Beenden"
      Height          =   495
      Left            =   7365
      TabIndex        =   3
      Top             =   2670
      Width           =   1065
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Arbeiten"
      Height          =   495
      Left            =   7365
      TabIndex        =   0
      Top             =   1200
      Width           =   1065
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Cls"
      Height          =   495
      Left            =   7365
      TabIndex        =   2
      Top             =   2175
      Width           =   1065
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Verdichten"
      Height          =   495
      Left            =   7365
      TabIndex        =   1
      Top             =   1680
      Width           =   1065
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Zentriert
      BackColor       =   &H00FF0000&
      BorderStyle     =   1  'Fest Einfach
      ForeColor       =   &H00FFFFFF&
      Height          =   270
      Left            =   3870
      TabIndex        =   6
      Top             =   3420
      Visible         =   0   'False
      Width           =   3465
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Zentriert
      BackColor       =   &H000040C0&
      BorderStyle     =   1  'Fest Einfach
      Caption         =   "Kompressionstakt"
      ForeColor       =   &H00FFFFFF&
      Height          =   270
      Left            =   3870
      TabIndex        =   5
      Top             =   195
      Visible         =   0   'False
      Width           =   3465
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Zentriert
      BackColor       =   &H0000C000&
      BorderStyle     =   1  'Fest Einfach
      Caption         =   "Arbeitstakt"
      ForeColor       =   &H00FFFFFF&
      Height          =   270
      Left            =   405
      TabIndex        =   4
      Top             =   195
      Visible         =   0   'False
      Width           =   3465
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Const PI = 3.141592653
Const m = 1       'Masse m = 1 kg
Const R = 287     'Gaskonstante fr Luft in Nm/kgK
Const cv = 718    'Spez. Wrmekapazitt in J/kgK = Nm/kgK
Const p1 = 1      'Ausgangsdruck in bar
Const t = 70      'Anfangstemp. in Grad C
Const E = 8.5     'Verdichtungsverhltnis
Const T3 = 2200   'Max. Temp. in K
Const k = 1.4     'Adiabatenexponent
Const dk = 10     'Kolbendurchmesser in cm
Const rk = 60     'Kurbelradius
Const l = 280     'Pleuellnge

Dim V1!, T1!, p2!, V2!, T2!, p3!, V3!
Dim Ak!, Zahl%, FTges!

Private Sub Form_Load()
  Scale (-20, 55)-(420, -25)
  Show
  Ak = dk ^ 2 * PI / 4
  
  '*)------Rasterlinien (grn) als Hintergrund -------
  AutoRedraw = True
  For AG = 0 To 360 Step 10
      If AG = 90 Or AG = 180 Or AG = 270 Or AG = 360 Then
          ForeColor = QBColor(15)
      Else
          ForeColor = QBColor(2)
      End If
    Line (AG, -20)-(AG, 50)
  Next
  ForeColor = QBColor(2)
  For j = -20 To 50 Step 5
    Line (0, j)-(360, j)
  Next

  '*)---- Zeichnen der Achsen ------------
  Line (0, 50)-(0, -20), QBColor(15)
  Line (0, 0)-(360, 0), QBColor(15)

  '*)---- Markierung der X-Achse (Anstriche, Zahlen) --
  ForeColor = QBColor(0)
  For AG = 0 To 360 Step 90
    Line (AG, 0)-(AG, -2)
    CurrentY = -1: Print AG
  Next

  '*)---- Benennungen an Kraftachse (vertikal) --------
  For j = -20 To 55 Step 10
    Line (-3, j)-(0, j), QBColor(9)    'Anstriche
    CurrentX = -15: CurrentY = j + 1   'Position Druckausgabe
    Print j
  Next
  ForeColor = QBColor(13)
  CurrentX = -15: CurrentY = 55: Print "T in kN"
  CurrentX = 361: CurrentY = 2: Print " AG in "
  AutoRedraw = False
  Call KreisPro
End Sub

Private Sub KreisPro()
    T1 = t + 273
    V1 = m * R * T1 / p1 / 100000
    V2 = V1 / E
    V4 = V1
    p2 = p1 * E ^ k
    T2 = p2 * V2 * 100000 / (m * R)
    V3 = V2
    p3 = T3 * p2 / T2
End Sub

Private Sub Command1_Click()     'Arbeitstakt
  Vx = V3
  For AG = 1 To 180
    Zahl = Zahl + 1         'Zhler fr Mitteldruck
    AB = AG * PI / 180      'Winkel im Bogenma
    Deltax = rk * (1 - Cos(AB))  'Wegdifferenz in x-Richtung
    dVh = Ak * Deltax / 10 / 100000  'Vol.Diff. in m^3
    Vx = Vx + dVh                'Vol.Diff. werden addiert
    px = p3 * V3 ^ k / Vx ^ k    'Druckhhe beim Expandieren
    pw = px - p1                 'Diff.druck am Kolben (bar)
    F = pw * Ak * 10 / 1000      'Kraft auf Kolben in kN
    sinBB = rk / l * Sin(AB)     'Sinussatz, BB ist der Winkel
    cosBB = Sqr(1 - sinBB ^ 2)   'zwischen Pleuelstange und
    tanBB = sinBB / cosBB        'Kolbenweg. Hieraus folgt
    BB = Atn(tanBB)              'der Winkel BB in Bogenma
    S = F / cosBB                'Kraft in Pleuelstange
    rx = rk * Sin(AB + BB)       'Wirksamer Hebelarm fr S
    Mtorsion = S * rx            'Torsionsmoment
    FT = Mtorsion / rk           'Torsionskraft
    FTges = FTges + FT           'Summenbildung
    Line (AG, 0)-(AG, FT), QBColor(10)
    PSet (AG, FT), QBColor(13)      'Torsionskraft
    PSet (AG, F), QBColor(15)       'Kolbenkraft
    PSet (AG, rx / 2.5), QBColor(0) 'Kolbenposition
    'For j = 1 To 5000: Next         'Verzgerung
  Next
    ForeColor = QBColor(9)
    For S = 45 To 55 Step 0.2       'Flche fr "+"-Zeichen
      CurrentX = S: CurrentY = 10: Print "|"
    Next
    ForeColor = QBColor(15)
    CurrentX = 47: CurrentY = 10: Print " + ";
    Label1.Visible = True
    Command2.SetFocus
End Sub

Private Sub Command2_Click()        'Verdichten
  Vx = V1
  For AG = 181 To 360
    Zahl = Zahl + 1        'Zhler fr Mitteldruck
    AB = AG * PI / 180     'Winkel im Bogenma
    Deltax = -rk * (1 - Cos(AB))
    dVh = Ak * Deltax / 10 / 100000     'm^3
    Vx = Vx + dVh
    px = p1 * V1 ^ k / Vx ^ k
    pw = px - p1                                                 'bar
    F = pw * Ak * 10 / 1000                              'kN
    sinBB = rk / l * Sin(AB)
    cosBB = Sqr(1 - sinBB ^ 2)
    tanBB = sinBB / cosBB
    BB = Atn(tanBB)
    S = F / cosBB
    rx = rk * Sin(AB + BB)
    Mtorsion = S * rx
    FT = Mtorsion / rk
    FTges = FTges + FT
    Line (AG, 0)-(AG, FT), QBColor(4)
    PSet (AG, FT), QBColor(13)
    PSet (AG, -F), QBColor(15)
    'For j = 1 To 2000: Next
    'If AG = 260 Then Stop     'Zum Testen der Variablen
  Next
  ForeColor = QBColor(9)
  For S = 295 To 305 Step 0.2
    CurrentX = S: CurrentY = -2: Print "|"
  Next
  ForeColor = QBColor(15): CurrentX = 297: CurrentY = -2: Print " - ";
  FTm = FTges / Zahl
  If Zahl = 180 Then FTm = FTm / 2
  FTm = Format(FTm, "##.##0")
  Line (0, 50)-(0, -10), QBColor(15)    'Senkr. Achse neu
  Line (0, FTm)-(360, 0), QBColor(9), B 'Mittl. Torsionskraft (Rahmen)
  ForeColor = QBColor(15)
'  Stop
  For AG = 0 To 360 Step 90
    Line (AG, 0)-(AG, -2)
    CurrentY = -1: Print AG
  Next
  Command3.SetFocus
  Label2.Visible = True
  Label3.Visible = True
  Label3.Caption = "Mittlere Torsionskraft  = " & FTm & " [kN]"
End Sub

Private Sub Command3_Click()        'cls
  Form1.Cls
  Command1.SetFocus
  Label3.Visible = False
  FTges = 0: Zahl = 0 'Variablen zurcksetzen
End Sub

Private Sub Command4_Click()
  End
End Sub

