'*)----------- Mech. Indiziereinrichtung  INDIKAT.BAS
COLOR 14, 1: CLS : BEEP
PI = 3.141529
Schritt = .8
l = 6: c = 2.4: PHI = 12
R = c ^ 2 / (l - c)

'*)----------- Mittenabstand MD ermitteln ------
PHIB = PHI / 180 * PI
AE = R * SIN(PHIB)
ED = R * COS(PHIB)
yD = -ED
xD = -(c + R - AE)
MD = SQR(yD ^ 2 + xD ^ 2)
tgBeta1 = yD / xD
BetaB1 = ATN(tgBeta1)

'*)----------- Beginn Alpha (AG = AlphaGrad) fr Schleife --
CSGamma = (MD ^ 2 + R ^ 2 - (R + c) ^ 2) / (2 * MD * R)
x = CSGamma
Gamma = ATN(SQR(1 - x ^ 2) / x)
AlphaB = PI - (Gamma - BetaB1)
AG = AlphaB / PI * 180

'*)----------- Schleifengrenzen-------------
'*)--- Schleifenbeginn ausprobiert (Anfang=124.5, Ende =282)
Anfang = 124.5
Ende = 282

'*)--------- Grafikschema der Indiziereinrichtung ----
SCREEN 12
WINDOW (-6, -4.8)-(6, 4.8)

CIRCLE (0, 0), R, 3
CIRCLE (xD, yD), R, 3

'*)------Zeigt Lage des Hilfskoordinatensystems ------
'LINE (xD, yD)-(xD, yD + 2.7), 7
'LINE (xD, yD)-(xD + 2, yD), 7

'*)------Zeigt Lage der Anlenkstange (vom Indizierzyl. kommend)--
LINE (xD + 1, yD - 2)-(xD + 1, yD + 2), 5

'*)------Zeichnet Gelenkelemente -----
LINE (0, 0)-(xD, yD), 6
LINE (xD, yD)-(xD, yD + 1.7), 2
LINE (0, 0)-(-1.4, .8), 2
LINE (xD, yD + 1.7)-(2, 1.8), 4

'*)------ Betont Gelenkpunkte -----
CIRCLE (0, 0), .1, 4: PAINT (0, 0), 4
CIRCLE (xD, yD), .1, 4: PAINT (xD, yD), 4
CIRCLE (xD, yD + 1.7), .05, 3: PAINT (xD, yD + 1.7), 3
CIRCLE (xD + 1, yD + 2), .05, 3: PAINT (xD + 1, yD + 2), 3
CIRCLE (-1.4, .8), .05, 3: PAINT (-1.4, .8), 3
CIRCLE (2, 1.8), .05, 2: PAINT (2, 1.8), 2
CIRCLE (xD + 1, yD), .05, 3: PAINT (xD + 1, yD), 3

'*)-------Zeigt Hauptkoordinatensystem ------
LINE (0, 5)-(0, -4), 7
LINE (-6, 0)-(6, 0), 7

'*)--------- Start fr Schleifendurchlufe -------
PRINT "Starten mit Return";
a$ = INPUT$(1)
LOCATE 1, 1
PRINT "                  "

'*)--------- Schleife I ----------
FOR AlphaG = Anfang TO Ende STEP Schritt
  AlphaB = AlphaG / 180 * PI
  yB = R * SIN(AlphaB)
  xB = R * COS(AlphaB)
  BetaB = PI - AlphaB + BetaB1
  DB = SQR(R ^ 2 + MD ^ 2 - 2 * R * MD * COS(BetaB))
  SnABB = R * SIN(BetaB) / DB
  x = SnABB
  ABB = ATN(x / SQR(1 - x ^ 2))
  CsWINB = (R ^ 2 + DB ^ 2 - c ^ 2) / (2 * R * DB)
  x = CsWINB
  WINB = ATN(SQR(1 - x ^ 2) / x)
  WB = WINB + ABB + BetaB1 - PI / 2
  xStrichA = -R * SIN(WB)
  yStrichA = R * COS(WB)
  yA = yStrichA + yD
  xA = xStrichA + xD
  m = (yB - yA) / (xB - xA)
  Delta = ATN(m)
  yS = (l - c) * SIN(Delta) + yB
  xS = (yS - yB) / m + xB
  PSET (xS, yS), 13
NEXT

'*)--------- Schleife II---------
FOR AlphaG = Ende TO Anfang STEP -Schritt
  AlphaB = AlphaG / 180 * PI
  yB = R * SIN(AlphaB)
  xB = R * COS(AlphaB)
  BetaB = PI - AlphaB + BetaB1
  DB = SQR(R ^ 2 + MD ^ 2 - 2 * R * MD * COS(BetaB))
  SnABB = R * SIN(BetaB) / DB
  x = SnABB
  ABB = ATN(x / SQR(1 - x ^ 2))
  CsWINB = (R ^ 2 + DB ^ 2 - c ^ 2) / (2 * R * DB)
  x = CsWINB
  WINB = ATN(SQR(1 - x ^ 2) / x)
  WB = -WINB + ABB + BetaB1
  xStrichA = R * COS(WB)
  yStrichA = R * SIN(WB)
  yA = yStrichA + yD
  xA = xStrichA + xD
  m = (yB - yA) / (xB - xA)
  Delta = ATN(m)
  yS = (l - c) * SIN(Delta) + yB
  xS = (yS - yB) / m + xB
  PSET (xS, yS), 13
NEXT

COLOR 7
LOCATE 1, 1: PRINT "Koppelkurve einer mechanischen";
LOCATE 2, 1: PRINT "Indiziereinrichtung";
LOCATE 4, 1: PRINT "Programm INDIKAT.BAS"
COLOR 3: LOCATE 30, 20: PRINT "Weiter mit beliebiger Taste";
COLOR 7
LOCATE 30, 80:
a$ = INPUT$(1)
SCREEN 0
CHAIN "D:\basic\pull.bas"

