Attribute VB_Name = "Module1"
'Mit Public deklarierte Variable, Konstanten oder Prozeduren sind in allen
'Formmodulen des Projektes bekannt (ffentlich). Alternativ kann
'auch Global verwendet werden.
Public Const MaxLaenge As Integer = 45
Public Const Lateindatei = "Latein.dat"      'Legt Namen fr Werkstoffdatei fest
Public Const Englischdatei = "Englisch.dat"  'Legt Namen fr Werkstoffdatei fest
Public Const Italienischdatei = "Italien.dat"      'Legt Namen fr Werkstoffdatei fest
Public DateiNr As Integer                    'Dateinummer fr Dateiaktionen
Public DateiGroesse As Integer               'in Byte
Public SatzGroesse As Integer                'in Byte
Public AnzWorte As Integer                 'Anzahl Werkstoffe in Werkstoffdatei
Public FlagCommand1 As Boolean             'Gibt an, da Command1 (auf Form1) bettigt wurde
Public FlagCommand2 As Boolean             ' "    "   "      "  2   "    "        "      "
Public N As Integer                        'meist fr DatenSatz-Nr verwendet

'Benutzerdefinierten Datentyp festlegen. Mehrere werkstoffbezogene Daten knnen so
'in einem Datensatz zusammengefat werden (hier WerkstoffName u. Alpha-Wert).
Type LateinTyp
  DeutschesWort As String * 45
  LateinischesWort As String * 25
End Type

Type EnglischTyp
  DeutschesWort As String * 45
  EnglischesWort As String * 25
End Type

Type ItalienischTyp
  DeutschesWort As String * 45
  ItalienischesWort As String * 25
End Type

'Variable LateinSatz als LateinTyp deklarieren
Public LateinSatz As LateinTyp
'Variable EnglischSatz als EnglischTyp deklarieren
Public EnglischSatz As EnglischTyp
'Variable ItalienischSatz als ItalienischTyp deklarieren
Public ItalienischSatz As ItalienischTyp


'Dateiaktionen werden vorbereitet
Public Sub DateiAktionenVorbereiten() 'Global gltig
  DateiNr = FreeFile                  'Freie DateiNr wird bestimmt mit FreeFile
  If Form1.Option1 = True Then
    SatzGroesse = Len(LateinSatz)    'Die Funktion Len ermittelt Satzgre (hier 28)
    
    'Datei ffnen bzw. - wenn Werkstoffdatei noch nicht existiert - erstellen und ffnen.
    Open Lateindatei For Random As DateiNr Len = SatzGroesse
  ElseIf Form1.Option2 = True Then
    SatzGroesse = Len(EnglischSatz)    'Die Funktion Len ermittelt Satzgre (hier 28)
    
    'Datei ffnen bzw. - wenn Werkstoffdatei noch nicht existiert - erstellen und ffnen.
    Open Englischdatei For Random As DateiNr Len = SatzGroesse
  Else
    SatzGroesse = Len(ItalienischSatz)    'Die Funktion Len ermittelt Satzgre (hier 28)
    
    'Datei ffnen bzw. - wenn Werkstoffdatei noch nicht existiert - erstellen und ffnen.
    Open Italienischdatei For Random As DateiNr Len = SatzGroesse
  End If
  DateiGroesse = LOF(DateiNr)  'LOF bestimmt Gre einer geffneten Datei in Byte
  AnzWorte = DateiGroesse \ SatzGroesse  'Errechnung von Anzahl der Datenstze
  
End Sub

'ListBoxInhalt auf Form 1 wird aktualisiert
Public Sub ListNeuFuellen()         'Global gltig, also von Form1 und Form2 aufrufbar
  On Error Resume Next
  Form1.List1.Clear                 'ListBoxinhalte lschen
  Call DateiAktionenVorbereiten     'Aufruf der global gltigen Prozedur (s.u.)
'  Form1.List1.Clear
  If Form1.Option1 = True Then
    For N = 1 To AnzWorte             'WerkstoffName in List1 einlesen
      Get DateiNr, , LateinSatz    'Satz lesen mit Get
      Form1.List1.AddItem LateinSatz.DeutschesWort 'AddItem-Methode zum Einlesen in List1
    Next
  ElseIf Form1.Option2 = True Then
    For N = 1 To AnzWorte             'WerkstoffName in List1 einlesen
      Get DateiNr, , EnglischSatz    'Satz lesen mit Get
      Form1.List1.AddItem EnglischSatz.DeutschesWort 'AddItem-Methode zum Einlesen in List1
    Next
  Else
    For N = 1 To AnzWorte             'WerkstoffName in List1 einlesen
      Get DateiNr, , ItalienischSatz    'Satz lesen mit Get
      Form1.List1.AddItem ItalienischSatz.DeutschesWort 'AddItem-Methode zum Einlesen in List1
    Next
  End If
  Form1.List1.Selected(0) = True    'Ersten Listeneintrag markieren (Index 0)
  Close DateiNr                     'Geffnete Datei schlieen
End Sub

