VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   3  'Fester Dialog
   Caption         =   "Vergleich der Kompressionslinien Adiabate, Polytrope, Isotherme"
   ClientHeight    =   6630
   ClientLeft      =   1185
   ClientTop       =   1365
   ClientWidth     =   8925
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'ZReihenfolge
   ScaleHeight     =   6630
   ScaleWidth      =   8925
   ShowInTaskbar   =   0   'False
   Begin VB.Shape Shape1 
      BackColor       =   &H00FFFF00&
      BackStyle       =   1  'Undurchsichtig
      BorderColor     =   &H00000000&
      Height          =   165
      Index           =   2
      Left            =   1545
      Top             =   1215
      Width           =   165
   End
   Begin VB.Shape Shape1 
      BackColor       =   &H000000FF&
      BackStyle       =   1  'Undurchsichtig
      BorderColor     =   &H00000000&
      Height          =   165
      Index           =   1
      Left            =   1545
      Top             =   1020
      Width           =   165
   End
   Begin VB.Shape Shape1 
      BackColor       =   &H80000006&
      BackStyle       =   1  'Undurchsichtig
      BorderColor     =   &H00000000&
      Height          =   165
      Index           =   0
      Left            =   1545
      Top             =   825
      Width           =   165
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Sub Form_Load()
  Form1.Scale (-0.1, 50)-(1.1, -5)
End Sub

Private Sub Form_Activate()
  p1 = 1   'Ausgangsdruck in bar
  ta = 70  'Ausgangstemperatur in C
  R = 287  'Gaskonstante fr Luft
  k = 1.4  'Adiabatenexponent
  m = 1    'Masse = 1 kg
  n = 1.3  'Polytropenexponent
  E = 15   'Verdichtungsverhltnis Epsylon

  T1 = ta + 273   'Umrechnung in Kelvin
  V1 = m * R * T1 / p1 / 100000  'Allgemeine Gasgleichung
  V2 = V1 / E     'Kompressionsvolumen
  
  CIso = p1 * V1       'Konstante fr Isotherme
  CAd = p1 * V1 ^ k    '    "      "  Adiabate
  CPol = p1 * V1 ^ n   '    "      "  Polytrope
  
  p2Ad = CAd / V2 ^ k    'Druck am Ende der Kompression
  p2Pol = CPol / V2 ^ n  'Enddruck bei Polytrope
  p2Iso = CIso / V2      'Enddruck bei Isotherme
  
  T2Iso = T1             'T ist konstant bei Isotherme
  T2Ad = p2Ad * V2 / m / R * 100000   'Temp. bei Adiabate
  T2Pol = p2Pol * V2 / m / R * 100000 '  "    "  Polytrope
 
  '*)------------ Rasterlinien grn (senkrecht/waagerecht) -----
  For x = 0 To 1.1 Step 0.1
    Line (x, -1)-(x, 35), QBColor(2)
  Next
  For y = 0 To 35 Step 5
    Line (-0.01, y)-(1, y), QBColor(2)
  Next

  '*)-------------- Achsen des Koordinatensystems (weiss) ----
  Line (0, 0)-(1, 0), QBColor(15)
  Line (0, 0)-(0, 36), QBColor(15)
  
  '*)-------------- Techn. Gasarbeit darstellen u. berechnen ---
  Zahl = 400
  dp = (p2Pol - p1) / Zahl
  For p = p1 To p2Pol Step dp
    For i = 1 To 10000: Next        'Verzgerungsschleife
    v = V1 * (p1 / p) ^ (1 / n)     'Volumenberechnung
    Line (v, p)-(0, p), QBColor(8)  'markiert Flche
    dW = v * dp                     'Teilarbeit
    W = W + dW                      'Summenbildung
  Next
  Wt = W * 100                      'Gasarbeit
  '*)-------------- Kompr.linien graphisch darstellen ---
  For Vx = V1 To V2 Step -0.001
    For i = 1 To 10000: Next
    pPol = CPol / Vx ^ n
    pAd = CAd / Vx ^ k
    pIso = CIso / Vx
    If pAd > 35 Then GoTo weiter  'Anzeige begrenzen auf Schreibbereich
    PSet (Vx, pAd), QBColor(0)
weiter:
    PSet (Vx, pPol), QBColor(12)
    PSet (Vx, pIso), QBColor(11)
  Next
  '*)----------- Vergleichskaro --------------------
  Line (0.5, 15)-(0.6, 10), QBColor(8), BF:
  Print " --> entspricht 50 kJ"
  
  '*)------------ Rasterlinien grn (berschreiben) -----
  For x = 0 To 1.1 Step 0.1
    Line (x, -1)-(x, 35), QBColor(2)
  Next
  For y = 0 To 35 Step 5
    Line (-0.01, y)-(1, y), QBColor(2)
  Next

  '*)-------------- Achsen des Koordinatensystems (wei) ----
  Line (0, 0)-(1, 0), QBColor(15)
  Line (0, 0)-(0, 36), QBColor(15)
  
   '*)----------- V-Achse beschriften --------------------
  For v = 0 To 1 Step 0.1
      CurrentX = v - 0.02: CurrentY = -1.2
      If v > 0.99 Then CurrentX = 0.99
      'Warum funktioniert die nachfolgende Zeile nicht???
      'If v = 1 Then CurrentX = 0.99
    Print v
  Next
  ForeColor = QBColor(12)
    CurrentX = 1.02: CurrentY = 0.6
    Print "V"
  ForeColor = QBColor(0)
  '*)----------- p-Achse beschriften --------------------
  For p = 0 To 35 Step 5
    If p < 10 Then
      CurrentX = -0.04: CurrentY = p + 0.6
    Else
      CurrentX = -0.05: CurrentY = p + 0.6
    End If
    Print p
  Next
  ForeColor = QBColor(12)
    CurrentX = -0.005: CurrentY = 38
    Print "p"
  ForeColor = QBColor(0)
 
  '*)------------- Rechenwerte ausgeben ---------------
  CurrentY = 50
  Form1.ForeColor = QBColor(1):
  Print "                        Rechenwerte"
  Print "                        p    --> bar                 V --> m^3              T  --> K"
  Print "                        ----------------------------------------------------------------------------------"
  Print "                        p1      =    1,00          V1 = ";
  Print Format$(V1, "0.###");
  Print "          T1 =  ";
  Print Format$(T1, "#.0##")

  Print "                        p2Ad  = ";
  Print Format$(p2Ad, "#.###");
  Print "         V2 = ";
  Print Format$(V2, "0.###");
  Print "     T2Ad = ";
  Print Format$(T2Ad, "#.###")
  
  Print "                        p2Pol = ";
  Print Format$(p2Pol, "#.###");
  Print "             V2 = ";
  Print Format$(V2, "0.###");
  Print "     T2Pol =  ";
  Print Format$(T2Pol, "#.###")

  Print "                        p2Iso = ";
  Print Format$(p2Iso, "#.0##");
  Print "              V2 = ";
  Print Format$(V2, "0.###");
  Print "     T2Iso = ";
  Print Format$(T2Iso, "#.0##")
  Print
  Print "                        Techn. Gasarbeit  --> WPol = ";
  Print Format$(Wt, "#.###");
  Print " kJ"
End Sub
