VERSION 5.00
Begin VB.Form Form1 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fest Einfach
   Caption         =   "Theoretischer Kreisproze des Otto-Motors"
   ClientHeight    =   6180
   ClientLeft      =   1995
   ClientTop       =   1515
   ClientWidth     =   7680
   FillStyle       =   0  'Ausgefllt
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'ZReihenfolge
   ScaleHeight     =   6180
   ScaleWidth      =   7680
   Begin VB.TextBox Text2 
      BackColor       =   &H00E0E0E0&
      ForeColor       =   &H00000000&
      Height          =   315
      Left            =   6165
      TabIndex        =   1
      Top             =   3555
      Width           =   915
   End
   Begin VB.TextBox Text1 
      BackColor       =   &H00E0E0E0&
      ForeColor       =   &H00000000&
      Height          =   315
      Left            =   6165
      TabIndex        =   0
      Top             =   3210
      Width           =   915
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Drucken"
      Height          =   405
      Left            =   3255
      TabIndex        =   6
      Top             =   5730
      Width           =   960
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Ende"
      Height          =   405
      Left            =   6120
      TabIndex        =   5
      Top             =   5730
      Width           =   930
   End
   Begin VB.CommandButton command2 
      Caption         =   "Cls"
      Height          =   405
      Left            =   5190
      TabIndex        =   4
      Top             =   5730
      Width           =   930
   End
   Begin VB.ListBox List1 
      BackColor       =   &H00FFFFFF&
      ForeColor       =   &H00000000&
      Height          =   2790
      ItemData        =   "OTTO.frx":0000
      Left            =   3030
      List            =   "OTTO.frx":0002
      TabIndex        =   3
      Top             =   300
      Width           =   4065
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Zeichnen"
      Height          =   405
      Left            =   4200
      TabIndex        =   2
      Top             =   5730
      Width           =   990
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim Flag As Boolean
Const k = 1.4, m = 1, R = 287, cv = 718, p1 = 1, t = 70
'  k = 1.4               'Adiabaten-Exponent
'  m = 1                 'Masse m = 1 kg
'  R = 287               'Gaskonstante fr Luft in Nm/kgK
'  cv = 718              'Spez. Wrmekapazitt in J/kgK = Nm/kgK
'  p1 = 1: t = 70        'Anfangsdruck in bar, Anfangstemp. in Grad C

Private Sub Zeichne()
  On Error GoTo Meldung
  If Val(Text1) > 13 Then
    MsgBox "Wert fr Otto-Motoren zu hoch", 0, "Hinweis"
    Text1 = ""
    Text1.SetFocus
    Exit Sub
  End If
  If Flag = True Then GoTo weiter
  command2.SetFocus
weiter:
  E = Val(Text1)         'Verdichtungsverhltnis
  T3 = Val(Text2)        'Maximaltemperatur in K
  '*)------------ Berechnung der Eckpunkte des Kreisprozesses ----
  T1 = t + 273
  V1 = m * R * T1 / p1 / 100000
  V2 = V1 / E
  V4 = V1
  p2 = p1 * E ^ k
  T2 = p2 * V2 * 100000 / (m * R)
  V3 = V2
  p3 = T3 * p2 / T2
  p4 = p3 / (V4 / V3) ^ k
  T4 = T1 * p4 / p1
  
  '*)--- Berechnung der Wrmemengen, Nutzarbeit(Theor.), Eta theor ---
  Qzu = m * cv * (T3 - T2)
  Qab = m * cv * (T4 - T1)
  WNutz = Qzu - Qab
  ETAth = WNutz / Qzu
  DeltaV = V1 - V2
  pm = WNutz / DeltaV / 100000
  ForeColor = QBColor(8)    'Dunkelgrau
  PSet (V1, p1)
  For V = V1 To V2 Step -0.0005
    p = p1 * V1 ^ k / V ^ k
    Line -(V, p)
  Next
  Line (V2, p)-(V3, p3)
  For V = V3 To V4 Step 0.001
    pu = p1 * V1 ^ k / V ^ k
    p = p3 * V3 ^ k / V ^ k
    Line -(V, p)
    'Line (V, p)-(V, pu), QBColor(14)
  Next
  Line -(V1, p1)
  Line (V4, p4)-(V1, p1)
  
  '*)--- Arbeitsflche farblich markieren (Windows-GDI)
  ScaleMode = 3         'Windows verwendet Pixel
  '*)--- um x und y fr Floodfill zu bestimmen
  ' Line (280, 350)-(300, 500), QBColor(15)
  ' PSet (120, 320), QBColor(14)
  FillStyle = 0        'Solid
  FillColor = QBColor(14)   'Gelb
  '*)--- Um die richtigen Koord. x, y zu finden
  '*) -> floodfill mit Rem rausnehmen
  FloodFill hdc, 280, 350, ForeColor
  
  '*)-- Zurcksetzen des KoordinatenSystems
  ScaleMode = 0         'Benutzerdefiniert
  Scale (-0.06, 85)-(1.1, -12)
  Line (V2, p2)-(V3, p3), QBColor(12)
  '*)------------ Rechteck fr Mitteldruck zeichnen -------------
  FillStyle = 1
  Line (V1, p1)-(V2, pm + p1), QBColor(9), B
  '*)--------- Mitteldruck zahlenmig eintragen ------
  ForeColor = QBColor(9)
  CurrentX = 0.1: CurrentY = 6
  Print "pthm =" + Format(pm, "0.00") + " bar"
  
  '*)------------ Rechteck-Flche als Mastabshilfe ---
  Line (0.4, 25)-(0.5, 30), QBColor(14), BF
  CurrentX = 0.41: CurrentY = 29: Print ">50 kJ<"
  
  '*)-------- Markieren der Eckpunkte des Prozesses ---
  FillStyle = 0           'Solid
  FillColor = QBColor(9)
  Circle (V1, p1), 0.006, QBColor(9)
  FillColor = QBColor(5)
  Circle (V2, p2), 0.006, QBColor(5)
  FillColor = QBColor(13)
  Circle (V3, p3), 0.006, QBColor(13)
  FillColor = QBColor(3)
  Circle (V4, p4), 0.006, QBColor(3)
  
  With List1
    .AddItem "Tabelle der Rechenwerte"
    .AddItem "p --> bar      |   V  --> m      |   T  --> K  "
    .AddItem "-------------------|----------------------|--------------------"
  
    .AddItem "p1 = " + Format(p1, "  ##.00") + _
  "  |   V1 = " + Format(V1, "0.000") + _
  "  |   T1 = " + Format(T1, "  000")
  
    .AddItem "p2 = " + Format(p2, "##.00") + _
  "  |   V2 = " + Format(V2, "0.000") + _
  "  |   T2 = " + Format(T2, "  000")
  
    .AddItem "p3 = " + Format(p3, "##.00") + _
  "  |   V3 = " + Format(V3, "0.000") + _
  "  |   T3 = " + Format(T3, "000")
  
    .AddItem "p4 = " + Format(p4, "  ##.00") + _
  "  |   V4 = " + Format(V4, "0.000") + _
  "  |   T4 = " + Format(T4, "  000")
    .AddItem ""
    .AddItem "Mitteldruck                          pthm = " + Format(pm, "    0.00") + " bar"
    .AddItem "Nutzarbeit                        WNutz = " + Format(WNutz / 1000, "000.00") + " kJ"
    .AddItem "Theoretischer Wirkungsgrad Eta = " + Format(ETAth * 100, "  00.00") + " %"
    If Len(E) = 2 Then
    .AddItem "Verdichtungsverhltnis    Epsilon = " + Format(E, "  00.0")
    Else
    .AddItem "Verdichtungsverhltnis    Epsilon = " + Format(E, "    0.0")
    End If
    .AddItem "Adiabaten-Exponent                 k = " + Format(k, "    0.0")
    .ListIndex = 10
  End With

    'Rasterlinien
    For V = 0 To 1.1 Step 0.1
     Line (V, 0)-(V, 80), QBColor(2)
    Next
    For p = 0 To 80 Step 5
     Line (0, p)-(1, p), QBColor(2)
    Next
    '*)------------ Zeichnen der Achsen --------------------------
    Line (0, 80)-(0, 0), QBColor(0)
    Line (0, 0)-(1, 0), QBColor(0)
  If Flag = True Then
    List1.ListIndex = -1
    ForeColor = QBColor(0)
  Else
    'Leer
  End If
  
  '*)--------- Markierungen der Eckpunkte an Tabelle ---------------
  FillColor = QBColor(9)
  Circle (0.38, 69), 0.006, QBColor(9)
  FillColor = QBColor(5)
  Circle (0.38, 66), 0.006, QBColor(5)
  FillColor = QBColor(13)
  Circle (0.38, 63), 0.006, QBColor(13)
  FillColor = QBColor(3)
  Circle (0.38, 60), 0.006, QBColor(3)
  FillStyle = 1   'Transparent
  Exit Sub
Meldung:
MsgBox "Bitte Werte eingeben!", 48, "Achtung"
Text1.SetFocus
End Sub

Private Sub Command1_Click()
  Call Zeichne
End Sub

Private Sub command2_Click()
  Flag = False
 ' Form1.BackColor = QBColor(7)     'Autoredraw wirkungslos (paint!!)
  Cls
  Text1 = "": Text2 = ""
  Text1.SetFocus
  List1.Clear
  List1.BackColor = QBColor(9)
  List1.ForeColor = QBColor(15)
End Sub

Private Sub Command3_Click()
  End
End Sub

Private Sub Command4_Click()     'Drucken
  If Form1.Text1 = "" Or Form1.Text2 = "" Then GoTo Meldung
  Flag = True
  Command1.Visible = False
  command2.Visible = False
  Command3.Visible = False
  Command4.Visible = False
  With List1
    .Clear
    .BackColor = QBColor(15)
    .ForeColor = QBColor(0)
  End With
  Form1.BackColor = QBColor(15)
  Call Form_activate
  AutoRedraw = True
  Call Zeichne
  ForeColor = QBColor(9)
  Form1.FontSize = 12
 ' CurrentY = 85: CurrentX = 0.2
  CurrentY = -5: CurrentX = 0.2
  FontUnderline = True
  Form1.Print "Theoretischer Kreisproze des Otto-Motors"
  FontUnderline = False
  FontSize = 8
  CurrentX = 0.58: CurrentY = 34: Print "Verdichtungsverhltnis   ="
  CurrentX = 0.58: CurrentY = 29: Print "Hchsttemperatur T3[K] ="
  AutoRedraw = False
  Form1.PrintForm
  Printer.EndDoc
  Exit Sub
Meldung:
  MsgBox "Bitte Werte eingeben!", 48, "Achtung"
  Text1.SetFocus
End Sub


Private Sub Form_activate()
  Scale (-0.06, 85)-(1.1, -12)
'  BackColor = QBColor(15)
  Call Raster(0)
End Sub

Private Sub Raster(Farbe)
  AutoRedraw = True
  Farbe = QBColor(Farbe)
  ForeColor = QBColor(2)
'*)-------------- Raster (senkr/waagerecht) ----
  For V = 0 To 1.1 Step 0.1
   Line (V, 0)-(V, 80)
  Next
  For p = 0 To 80 Step 5
   Line (0, p)-(1, p)
  Next
  '*)------------ Zeichnen der Achsen --------------------------
  Line (0, 80)-(0, 0), Farbe
  Line (0, 0)-(1, 0), Farbe
  
  '*)------------ Markierung der Achsen (Anstriche) ------------
  For V = 0 To 1.1 Step 0.1
   Line (V, 0)-(V, -1), Farbe
  Next
  For p = 0 To 80 Step 5
   Line (-0.01, p)-(0, p), Farbe
  Next
  '*)------------ Benennungen der Achsen ------------
  For p = 0 To 80 Step 10
    CurrentY = p + 1.2: CurrentX = -0.05
    If p = 0 Then
      Print "  " + Str(p)
    Else
      Print p
    End If
  Next
  For V = 0 To 1 Step 0.1
    CurrentY = -0.5: CurrentX = V - 0.02
    Print V
  Next
  ForeColor = QBColor(13)
  CurrentY = 85: CurrentX = -0.02:  Print "p [bar]"
  CurrentY = -2: CurrentX = 1:  Print "V [m]"
  ForeColor = QBColor(9)
  CurrentX = 0.58: CurrentY = 34: Form1.Print "Verdichtungsverhltnis   ="
  CurrentX = 0.58: CurrentY = 29: Form1.Print "Hchsttemperatur T3[K] ="
  AutoRedraw = False
End Sub

Private Sub Text1_KeyPress(KeyAscii As Integer)
'Auf das "Sieb" wurde verzichtet. Sie knnen selbst verfeinern.
  If KeyAscii = 13 Then Text2.SetFocus
End Sub

Private Sub Text2_KeyPress(KeyAscii As Integer)
  If KeyAscii = 13 Then Call Command1_Click
End Sub
