'*)--------------- pV - Diagramm Diesel-Motor ------------------
'*)--------------- Diesel.BAS ----------------------------------
COLOR 14, 1
CLS : BEEP

'*)--------------- Eingabe von Epsilon, T3 und k (bzw. n) ------
'INPUT "Verdichtungsverhltnis Diesel, z.B. 14       "; E
'INPUT "Max. Temperatur des Prozesses (T3 in K)      "; T3
'INPUT "Exponent (Polytrope o. Adiabate (1,27 -->1.4)"; k
E = 21
T3 = 2200
k = 1.4
CLS

'*)--------------- Schalten in Grafikmodus ---------------------
SCREEN 12
WINDOW (-.06, -8)-(1, 80)

'*)---------------------- Wertezuweisungen ---------------------
m = 1                 'Masse m = 1 kg
R = 287               'Gaskonstante fr Luft in Nm/kgK
cv = 718
cp = 1007             'Spez. Wrmekapazitt in J/kgK = Nm/kgK
p1 = 1: t = 70        'Anfangsdruck in bar, Anfangstemp. in Grad C

'*)------------ Berechnung der Eckpunkte des Kreisprozesses ----
T1 = t + 273
V1 = m * R * T1 / p1 / 100000
V2 = V1 / E
V4 = V1
p2 = p1 * E ^ k
T2 = p2 * V2 * 100000 / (m * R)
p3 = p2
V3 = T3 * V2 / T2
'V3 = m * R * T3 / p3 / 100000         'Alternative Rechnung

p4 = p3 / (V4 / V3) ^ k
T4 = T1 * p4 / p1

'*)--- Berechnung der Wrmemengen, Nutzarbeit(Theor.), Eta theor ---
Qzu = m * cp * (T3 - T2)
Qab = m * cv * (T4 - T1)
Wnutz = Qzu - Qab
Etath = Wnutz / Qzu
DeltaV = V1 - V2
pm = Wnutz / DeltaV / 100000

'*)------------ Rasterlinien (grn) als Hintergrund -----------
COLOR 2
FOR V = 0 TO 1.1 STEP .1
 LINE (V, 0)-(V, 80)
NEXT
FOR p = 0 TO 85 STEP 5
 LINE (0, p)-(1, p)
NEXT

'*)------------ Zeichnen der Achsen --------------------------
LINE (0, 80)-(0, 0), 15
LINE (0, 0)-(1, 0), 15

'*)------------ Markierung der Achsen (Anstriche) ------------
COLOR 15
FOR V = 0 TO 1.1 STEP .1
 LINE (V, 0)-(V, -1)
NEXT
FOR p = 0 TO 80 STEP 5
 LINE (-.01, p)-(0, p)
NEXT

'*)------------ Benennungen an Druckachse --------------------
LOCATE 3, 1: PRINT "pabs"
LOCATE 1, 1: PRINT 80
LOCATE 7, 1: PRINT 60
LOCATE 11, 1: PRINT 50
LOCATE 14, 1: PRINT 40
LOCATE 17, 1: PRINT 30
LOCATE 21, 1: PRINT 20
LOCATE 24, 1: PRINT 10
LOCATE 28, 2: PRINT 0

'*)----------- Benennungen an Volumenachse -------------------
LOCATE 29, 5
PRINT "0     .1      .2      .3     .4      .5     .6      .7";
PRINT "     .8      .9   V  1";

'*)----------- berschrift schreiben -------------------------
LOCATE 2, 15
LINE (.11, 78)-(.92, 73), 3, B
PAINT (.52, 76), 3
COLOR 15
PRINT "Theoretischer Vergleichsproze - Diesel-Motor (Gleichdruck)";

'*)---------------- Meldebox ------------------------
LINE (.41, 69)-(.99, 64), 1, B    'groer Rahmen in blau
PAINT (.52, 66), 1
LINE (.42, 68)-(.98, 65), 0, B    'kleinerer Schreibteil in schwarz
PAINT (.52, 66), 0
COLOR 3: LOCATE 5, 40: PRINT "Kompression des Gases"

'*)-------- Zeichnen des Diagramms ----------------------------
PSET (V1, p1)

FOR V = V1 TO V2 STEP -.0005
  p = p1 * V1 ^ k / V ^ k
  LINE -(V, p), 15
NEXT

'*)-------- Eintrag in Meldebox ndern ------------------------
COLOR 4: LOCATE 5, 40: PRINT "Arbeitstakt          "

FOR V = V3 TO V4 STEP .0005
  p = p3 * V3 ^ k / V ^ k
  LINE -(V, p), 15
NEXT
LINE -(V1, p1), 15

PAINT (V3, p3 - 2), 8, 15

'*)----------- Bereiche Wrmezu- und -abfuhr farbig betonen ---
LINE (V2, p2)-(V3, p3), 9
LINE (V4, p4)-(V1, p1), 9

'*)------------ Rechteck fr Mitteldruck zeichnen -------------
LINE (V2, p1)-(V1, pm), 4, B

'*)------------ Rasterlinien (grn) neu schreiben -------------
COLOR 2
FOR V = 0 TO 1.1 STEP .1
 LINE (V, 0)-(V, 80)
NEXT
FOR p = 0 TO 85 STEP 5
 LINE (0, p)-(1, p)
NEXT

'*)------------ berschrift neu schreiben --------------------
LOCATE 2, 15
LINE (.12, 78)-(.92, 74), 3, B
PAINT (.52, 76), 3
COLOR 15
PRINT "Theoretischer Vergleichsproze - Diesel-Motor (Gleichdruck)";

'*)----------- Markieren der Eckpunkte des Prozesses ---------
CIRCLE (V1, p1), .006, 5: PAINT (V1, p1), 5
CIRCLE (V2, p2), .006, 2: PAINT (V2, p2), 2
CIRCLE (V3, p3), .006, 4: PAINT (V3, p3), 4
CIRCLE (V4, p4), .006, 3: PAINT (V4, p4), 3

'*)---------------- Rahmen fr Tabellenwerte ------------------------
LINE (.41, 69)-(.99, 31), 1, B    'groer Rahmen in blau
PAINT (.52, 50), 1
LINE (.42, 68)-(.98, 32), 0, B    'kleinerer Schreibteil in schwarz
PAINT (.52, 50), 0

'*)---------------- Wertetabelle ------------------------------------
COLOR 3
LOCATE 5, 40: PRINT "Tabelle der Rechenwerte                "
COLOR 7
LOCATE 6, 40: PRINT "p --> bar      V --> m^3      T --> K  "
LOCATE 7, 40: PRINT "---------------------------------------"

LOCATE 8, 40: PRINT "p1 = "; USING " ##.##    "; p1
LOCATE 9, 40: PRINT "p2 = "; USING " ##.##    "; p2
LOCATE 10, 40: PRINT "p3 = "; USING " ##.## "; p3
LOCATE 11, 40: PRINT "p4 = "; USING " ##.##    "; p4

LOCATE 8, 55: PRINT "V1 = "; USING " #.###    "; V1
LOCATE 9, 55: PRINT "V2 = "; USING " #.###    "; V2
LOCATE 10, 55: PRINT "V3 = "; USING " #.### "; V3
LOCATE 11, 55: PRINT "V4 = "; USING " #.###    "; V4

LOCATE 8, 70: PRINT "T1 = "; USING "####"; T1
LOCATE 9, 70: PRINT "T2 = "; USING "####"; T2
LOCATE 10, 70: PRINT "T3 = "; USING "####"; T3
LOCATE 11, 70: PRINT "T4 = "; USING "####"; T4
LOCATE 12, 40: PRINT "pthm      = "; USING "  ##.##"; pm;
PRINT " bar"
LOCATE 13, 40: PRINT "WNutz     = "; USING "####.##"; Wnutz / 1000;
PRINT " kJ"
LOCATE 14, 40: PRINT "Eta theor = "; USING "  ##.##"; Etath * 100;
PRINT " %"
LOCATE 15, 40: PRINT "Epsylon           = "; E
LOCATE 16, 40: PRINT "Exponent k bzw. n = "; k

'*)--------- Markierungen der Eckpunkte in Tabelle ---------------
CIRCLE (.43, 58), .006, 5: PAINT (.43, 58), 5
CIRCLE (.43, 55), .006, 2: PAINT (.43, 55), 2
CIRCLE (.43, 52), .006, 4: PAINT (.43, 52), 4
CIRCLE (.43, 49), .006, 3: PAINT (.43, 49), 3

'*)--------- Mitteldruck zahlenmig eintragen -------------------
COLOR 4
LOCATE 24, 60: PRINT "pthm ="; USING "##.##"; pm;
PRINT " bar"
COLOR 7

'a$ = INPUT$(1)

SLEEP 10
SCREEN 0
'************************************************************************
'**             Trennteil fr DEMO (R.BAS)                             **
'************************************************************************

CLS
COLOR 4, 14
x1 = 6: x2 = 74: y = 0
FOR x = x1 TO (x2 / 2 - 1) STEP 3
y = y + 1
LOCATE y, x: PRINT "";                     ' Alt 218
PRINT STRING$(80 - 2 * x - 1, ""); "";     ' Alt 196          Alt 191
  FOR i = y + 1 TO 25 - y - 1
   LOCATE i, x: PRINT "";                   'Alt 179
   LOCATE i, 80 - x: PRINT "";
  NEXT
LOCATE 25 - y, x: PRINT "";                 ' Alt 192
PRINT STRING$(80 - 2 * x - 1, ""); "";     ' Alt 196          Alt 217

Pausenzeit = .01
TIME$ = "00:00:00"
DO
LOOP UNTIL TIMER > Pausenzeit
NEXT

Pausenzeit = Zeit
TIME$ = "00:00:00"
DO
LOOP UNTIL TIMER > Pausenzeit

CLS
COLOR 14, 0
x1 = 4: x2 = 76: y = 13

FOR x = (x2 / 2 - 1) TO x1 STEP -3
COLOR 14
y = y - 1
LOCATE y, x: PRINT "";                     ' Alt 218
PRINT STRING$(80 - 2 * x - 1, ""); "";     ' Alt 196          Alt 191
  FOR i = y + 1 TO 25 - y - 1
   LOCATE i, x: PRINT "";                   'Alt 179
   LOCATE i, 80 - x: PRINT "";
  NEXT
LOCATE 25 - y, x: PRINT "";                 ' Alt 192
PRINT STRING$(80 - 2 * x - 1, ""); "";     ' Alt 196          Alt 217

Pausenzeit = .01
TIME$ = "00:00:00"
DO
LOOP UNTIL TIMER > Pausenzeit

NEXT

Pausenzeit = Zeit
TIME$ = "00:00:00"
DO
LOOP UNTIL TIMER > Pausenzeit

CHAIN "Thales.bas"



