VERSION 5.00
Begin VB.Form FrmKompr 
   BorderStyle     =   1  'Fest Einfach
   Caption         =   "Arbeitsprozesse eines Kolbenkompressors"
   ClientHeight    =   6180
   ClientLeft      =   1995
   ClientTop       =   1515
   ClientWidth     =   7680
   FillStyle       =   0  'Ausgefllt
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'ZReihenfolge
   ScaleHeight     =   6180
   ScaleWidth      =   7680
   Begin VB.CommandButton Command4 
      Caption         =   "Drucken"
      Height          =   405
      Left            =   3255
      TabIndex        =   4
      Top             =   5730
      Width           =   960
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Ende"
      Height          =   405
      Left            =   6120
      TabIndex        =   3
      Top             =   5730
      Width           =   930
   End
   Begin VB.CommandButton command2 
      Caption         =   "Cls"
      Height          =   405
      Left            =   5190
      TabIndex        =   2
      Top             =   5730
      Width           =   930
   End
   Begin VB.ListBox List1 
      BackColor       =   &H00E0E0E0&
      ForeColor       =   &H00000000&
      Height          =   2790
      ItemData        =   "KOMPR.frx":0000
      Left            =   3030
      List            =   "KOMPR.frx":0002
      TabIndex        =   1
      Top             =   300
      Width           =   4005
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Zeichnen"
      Height          =   405
      Left            =   4200
      TabIndex        =   0
      Top             =   5730
      Width           =   990
   End
End
Attribute VB_Name = "FrmKompr"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim Farbe As Integer
Dim Flag As Boolean
Const k = 1.4, m = 1, R = 287, cp = 1005, t = 70, Vs = 0.1
'  T3 = 2200             'Maximaltemperatur in K
'  k = 1.4               'Adiabaten-Exponent
 ' m = 1                 'Masse m = 1 kg
  'R = 287               'Gaskonstante fr Luft in Nm/kgK
  'cp = 1005             'Spez. Wrmekapazitt in J/kgK = Nm/kgK
'  p1 = 1: t = 70        'Anfangsdruck in bar, Anfangstemp. in Grad C

Private Sub Command1_Click()
  command2.SetFocus
  p1 = 4           'Als Startdruck nach Vorkompression gesehen
  Farbe = 10
  For p2 = 12.5 To 70 Step 14
  z = z + 1
  Farbe = Farbe + 1
  '*)------------ Berechnung der Eckpunkte des Kreisprozesses ----
  T1 = t + 273
  'V1 = m * R * T1 / p1 / 100000
  V1 = 1
  V2 = V1 * (p1 / p2) ^ (1 / k)
  V3 = Vs
  T2 = p2 * V2 * 100000 / (m * R)
  p3 = p2
  T3 = T2 * V3 / V2
  p4 = p1
  V4 = V3 * (p3 / p4) ^ (1 / k)
  T4 = T1 * V4 / V1
    
  '*)--- Berechnung der Nutzarbeit(Theor.), Eta theor ---
  dp = (p2 - p1) / 1000
  ForeColor = QBColor(9)    'Dunkelblau
  PSet (V1, p1)
  For p = p1 To p2 Step dp
    dA1 = V * dp
    A1 = A1 + dA1
    V = V1 * (p1 / p) ^ (1 / k)
    Line -(V, p)
  Next
  Line (V, p)-(V3, p2)
  For p = p3 To p1 Step -dp
    V = V3 * (p3 / p) ^ (1 / k)
    dA2 = V * dp
    A2 = A2 + dA2
    Line -(V, p)
  Next
  Line -(V1, p1)
  Line (V4, p4)-(V1, p1)
  
  '*)--- Arbeitsflche farblich markieren (Windows-GDI)
  ScaleMode = 3         'Windows verwendet Pixel
  '*)--- um x und y fr Floodfill zu bestimmen
   'Line (280, 325)-(0, 0), QBColor(15)
  FillStyle = 0        'Solid
 If Farbe = 11 Then
  FillColor = QBColor(Farbe) 'Zyan hell
  '*)--- Um die richtigen Koord. x, y zu finden
  '*) -> floodfill mit Rem rausnehmen
  FloodFill hdc, 280, 325, ForeColor
 End If
  '*)-- Zurcksetzen des KoordinatenSystems
  ScaleMode = 0         'Benutzerdefiniert
  Scale (-0.06, 85)-(1.1, -12)
  'Line (V2, p2)-(V3, p3), QBColor(12)
  '*)------------ Rechteck fr Mitteldruck zeichnen -------------
  FillStyle = 1
'  Line (V1, p1)-(V4, p4), QBColor(9), B
  '*)--------- Mitteldruck zahlenmig eintragen ------
  ForeColor = QBColor(9)
  CurrentX = 0.1: CurrentY = 6
'  Print "pthm =" + Format(pm, "0.00") + " bar"
  
  '*)------------ Rechteck-Flche als Mastabshilfe ---
  Line (0.4, 25)-(0.5, 30), QBColor(11), BF
  CurrentX = 0.41: CurrentY = 29: Print ">50 kJ<"
  
  '*)-------- Markieren der Eckpunkte des Prozesses ---
  FillStyle = 0           'Solid
  FillColor = QBColor(9)
  Circle (V1, p1), 0.006, QBColor(9)
  FillColor = QBColor(5)
  Circle (V2, p2), 0.006, QBColor(5)
  FillColor = QBColor(13)
  Circle (V3, p3), 0.006, QBColor(13)
  FillColor = QBColor(3)
  Circle (V4, p4), 0.006, QBColor(3)
  DoEvents
  If z = 1 Then
    GoSub Tabelle  'Sprungmarke Tabelle, s. u.
    GoTo Endpos
  End If
  Eta = (V1 - V4) / (V1 - V3) * 100
  List1.AddItem "Theoretischer Liefergrad   Lambda = " + Format(Eta, "  00.00") + " %" + "  (" + Format(z) + ")"
  ForeColor = QBColor(13): Print z
Endpos:
 Next
Call RasterNeu: Exit Sub

'Zur Demonstration Unterprogrammtechnik mit Gosub Return eingefgt
Tabelle:
WNutz = (A1 - A2) * 100000
Eta = (V1 - V4) / (V1 - V3) * 100
ForeColor = QBColor(13): Print z
  With List1
    .AddItem "Tabelle der Rechenwerte"
    .AddItem "p --> bar      |   V  --> m      |   T  -->   K  "
    .AddItem "-------------------|----------------------|----------------------"
  
    .AddItem "p1 = " + Format(p1, "  ##.00") + _
  "  |   V1 = " + Format(V1, "0.000") + _
  "  |   T1 = " + Format(T1, "    #000")
  
    .AddItem "p2 = " + Format(p2, "##.00") + _
  "  |   V2 = " + Format(V2, "0.000") + _
  "  |   T2 = " + Format(T2, "  #000")
  
    .AddItem "p3 = " + Format(p3, "##.00") + _
  "  |   V3 = " + Format(V3, "0.000") + _
  "  |   T3 = " + Format(T3, "    #000")
  
    .AddItem "p4 = " + Format(p4, "  ##.00") + _
  "  |   V4 = " + Format(V4, "0.000") + _
  "  |   T4 = " + Format(T4, "      ##00")
    .AddItem ""
    .AddItem "Nutzarbeit                           WNutz = " + Format(WNutz / 1000, "000.00") + " kJ"
    .AddItem "Theoretischer Liefergrad   Lambda = " + Format(Eta, "  00.00") + " %  (1)"
    .ListIndex = 9
  End With
  Return
End Sub

Private Sub command2_Click()         'Cls
  Command1.SetFocus
  Flag = False
  List1.Clear
  List1.BackColor = QBColor(9)
  List1.ForeColor = QBColor(0)
  List1.BackColor = RGB(210, 210, 210)
  Cls
  Call Raster(15)
End Sub

Private Sub Command3_Click()         'Ende
  End
End Sub

Private Sub Command4_Click()    'Form ausdrucken
  Flag = True
  With List1
    .Clear
    .BackColor = QBColor(15)
    .ForeColor = QBColor(0)
  End With
  FrmKompr.BackColor = QBColor(15)
  AutoRedraw = True
  Call Command1_Click
  Call Raster(0)
  ForeColor = QBColor(9)
  FrmKompr.FontSize = 12
  CurrentY = -5: CurrentX = 0.2
  FontUnderline = True
  Print "Arbeitsprozesse eines KolbenKompressors"
  FontUnderline = False
  AutoRedraw = False
  Command1.Visible = False
  command2.Visible = False
  Command3.Visible = False
  Command4.Visible = False
  PrintForm
  Printer.EndDoc
  Command1.Visible = True
  command2.Visible = True
  Command3.Visible = True
  Command4.Visible = True
  Exit Sub
End Sub

Private Sub Form_activate()
  Scale (-0.06, 85)-(1.1, -12)
  AutoRedraw = True
  Call Raster(15)
  AutoRedraw = False
End Sub

Private Sub Raster(Farbe)
  Farbe = QBColor(Farbe)
  ForeColor = QBColor(2)
'*)-------------- Raster (senkr/waagerecht) ----
  For V = 0 To 1.1 Step 0.1
   Line (V, 0)-(V, 80)
  Next
  For p = 0 To 80 Step 5
   Line (0, p)-(1, p)
  Next
  '*)------------ Zeichnen der Achsen --------------------------
  Line (0, 80)-(0, 0), Farbe
  Line (0, 0)-(1, 0), Farbe
  
  '*)------------ Markierung der Achsen (Anstriche) ------------
  For V = 0 To 1.1 Step 0.1
   Line (V, 0)-(V, -1), Farbe
  Next
  For p = 0 To 80 Step 5
   Line (-0.01, p)-(0, p), Farbe
  Next
  '*)------------ Benennungen der Achsen ------------
  For p = 0 To 80 Step 10
    CurrentY = p + 1.2: CurrentX = -0.05
    If p = 0 Then
      Print "  " + Str(p)
    Else
      Print p
    End If
  Next
  For V = 0 To 1 Step 0.1
    CurrentY = -0.5: CurrentX = V - 0.02
    Print V
  Next
  ForeColor = QBColor(13)
  CurrentY = 85: CurrentX = -0.02:  Print "p [bar]"
  CurrentY = -2: CurrentX = 1:  Print "V [m]"
End Sub

Private Sub Text1_KeyPress(KeyAscii As Integer)
  If KeyAscii = 13 Then Text2.SetFocus
End Sub

Private Sub Text2_KeyPress(KeyAscii As Integer)
  If KeyAscii = 13 Then Call Command1_Click
End Sub

Public Sub RasterNeu()
  'Rasterlinien
  For V = 0 To 1.1 Step 0.1
   Line (V, 0)-(V, 80), QBColor(2)
  Next
  For p = 0 To 80 Step 5
   Line (0, p)-(1, p), QBColor(2)
  Next
  '*)------------ Zeichnen der Achsen --------------------------
  Line (0, 80)-(0, 0), QBColor(15)
  Line (0, 0)-(1, 0), QBColor(15)
  If Flag = True Then
    List1.ListIndex = -1
    ForeColor = QBColor(0)
  End If
  '*)--------- Markierungen der Eckpunkte an Tabelle ---------------
  FillColor = QBColor(9)
  Circle (0.38, 69), 0.006, QBColor(9)
  FillColor = QBColor(5)
  Circle (0.38, 66), 0.006, QBColor(5)
  FillColor = QBColor(13)
  Circle (0.38, 63), 0.006, QBColor(13)
  FillColor = QBColor(3)
  Circle (0.38, 60), 0.006, QBColor(3)
  FillStyle = 1   'Transparent
End Sub

