VERSION 5.00
Begin VB.Form Form1 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Rauhtiefen beim Drehen (Fluchtentafel-Nomogramm)"
   ClientHeight    =   6555
   ClientLeft      =   1410
   ClientTop       =   1395
   ClientWidth     =   8835
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   PaletteMode     =   1  'ZReihenfolge
   ScaleHeight     =   6555
   ScaleWidth      =   8835
   Begin VB.CommandButton Command3 
      Caption         =   "Zurck"
      Height          =   420
      Left            =   5220
      TabIndex        =   4
      Top             =   6105
      Visible         =   0   'False
      Width           =   900
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Ende"
      Height          =   420
      Left            =   6120
      TabIndex        =   3
      Top             =   6105
      Width           =   900
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Drucken"
      Height          =   420
      Left            =   5220
      TabIndex        =   2
      Top             =   6105
      Width           =   900
   End
   Begin VB.PictureBox Picture1 
      BackColor       =   &H00FFFF80&
      Height          =   1200
      Left            =   7755
      ScaleHeight     =   1140
      ScaleWidth      =   930
      TabIndex        =   0
      Top             =   4410
      Width           =   990
      Begin VB.Line Line1 
         BorderColor     =   &H000000FF&
         X1              =   480
         X2              =   390
         Y1              =   75
         Y2              =   195
      End
      Begin VB.Label Label1 
         Caption         =   "R"
         ForeColor       =   &H000000FF&
         Height          =   225
         Left            =   510
         TabIndex        =   1
         Top             =   270
         Width           =   150
      End
      Begin VB.Shape Shape2 
         Height          =   330
         Left            =   240
         Shape           =   3  'Kreis
         Top             =   30
         Width           =   315
      End
      Begin VB.Line Line10 
         X1              =   255
         X2              =   60
         Y1              =   90
         Y2              =   870
      End
      Begin VB.Line Line9 
         X1              =   60
         X2              =   60
         Y1              =   885
         Y2              =   1245
      End
      Begin VB.Line Line8 
         X1              =   450
         X2              =   885
         Y1              =   30
         Y2              =   285
      End
      Begin VB.Line Line7 
         X1              =   870
         X2              =   870
         Y1              =   285
         Y2              =   1260
      End
      Begin VB.Line Line6 
         X1              =   60
         X2              =   885
         Y1              =   885
         Y2              =   495
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim flag As Boolean
Const L = 100

Private Sub Command1_Click()
  flag = True
  Command1.Visible = False: Command2.Visible = False
  Form1.BackColor = QBColor(15)
  Form1.Width = 10215: Form1.ScaleWidth = 10100
  Call Form_Activate
  Form2.Show 1      'Aufruf eigener Meldebox, gebunden
  If DruckenFlag = True Then
    'If MsgBox("Ist der Drucker vorbereitet?", 33, _
    "Zum Ausdrucken") = 6 Then
    'Der Wert "6" in obiger Zeile steht fr die VB-Konstante vbYES = Ja-Taste
    'Weitere Werte: 1 >> vbOK, 2 >> vbCANCEL (Abbruch), 3 >> vbABORT (Abbruch)
    '4 >> vbRETRY (Wiederholen-Taste), 5 >> vbIGNORE (Ignorieren-Taste), 7 >> vbNO
  PrintForm
  Printer.EndDoc
  Else
    Call Command3_Click
    Exit Sub
  End If
  With Command2: .Left = 0.55: .Visible = True: End With
  With Command3: .Left = 0.45: .Visible = True: .SetFocus: End With
End Sub

Private Sub Command2_Click()
  End
End Sub

Private Sub Command3_Click()  'Zurckstellen
  flag = False
  Command1.Visible = True
  Command3.Visible = False
  AutoRedraw = True
  Cls
  Form1.BackColor = QBColor(7)
  Form1.Width = 8955: Form1.ScaleWidth = 8835
  Call Form_Activate
  Command2.Left = 0.52
  Command2.Visible = True
  Command1.SetFocus
End Sub

Private Sub Form_Activate()
  ScaleMode = 6        'Mastab mm
  If flag = True Then
    Form1.Scale (-0.3, 105)-(0.82, -25)
    AutoRedraw = True
  Else
    Form1.Scale (-0.15, 105)-(0.82, -25)
  End If
  Call Diagramm
  
  '*)------------------- Diagrammkurven berechnen ---------------
  For i = 1 To 8
    Select Case i         'Ersetzt Read Data frherer Basic-Versionen
      Case 1: R = 0.4
      Case 2: R = 0.8
      Case 3: R = 1.2
      Case 4: R = 1.6
      Case 5: R = 2
      Case 6: R = 4
      Case 7: R = 6.35
      Case 8: R = 12.7
    End Select
    For f = 0.05 To 0.75 Step 0.002
      Rt = f ^ 2 / (8 * R) * 1000  '1000 wegen Umrechnung in M
      Zahl = Log(Rt) / Log(100)
      x = Zahl * L
      If x < -10 Or Rt > 100 Then GoTo weiter
      PSet (f, x), QBColor(1)
weiter:
    Next
  Next
  Call Beschriftung
 
  '*)------------- Benennung beim Drucken ------------
  If flag = True Then
    Form1.FontSize = 14
    Print
    Print "             Rauhtiefen beim Drehen"
    Form1.FontSize = 8
    AutoRedraw = False
    Exit Sub
  End If
  Command1.SetFocus
End Sub


Public Sub Diagramm()
  '*)---------------- Leiterlinien zeichnen -----------
  Line (0, -15)-(0, 100), QBColor(0)         'Senkrechte schwarz, rechts
  Line (-0.08, -15)-(-0.08, 100), QBColor(0) '    "       "     , links
  Line (-0.15, -10)-(0.8, -10), QBColor(0)   'untere Waagerechte schwarz
  
  '*)------------------- Grne Rasterlinien senkrecht -----------
  For i = 0.05 To 0.8 Step 0.05
    Line (i, 100)-(i, -10), QBColor(2)
  Next
  
  '*)------------------- Grne Rasterlinien waagerecht ----------
  '*)------------------- (in logarithmischer Teilung) -----------
  For i = 1 To 11
    Select Case i
      Case 1 To 3: j = i: Case 4: j = 5: Case 5: j = 7
      Case 6: j = 10: Case 7: j = 15: Case 8: j = 25
      Case 9: j = 40: Case 10: j = 60: Case 11: j = 100
    End Select
    Zahl = Log(j) / Log(100)
    y = Zahl * L
    Line (0, y)-(0.75, y), QBColor(2)
    Line (-0.005, y)-(0, y), QBColor(0) 'Anstriche an Rt-Achse
    Line (-0.085, y)-(-0.078, y), QBColor(0) 'Anstriche an Ra-Achse
  Next
End Sub

Public Sub Beschriftung()
  '*)-------------- Diagramm-Linien etc. beschriften ------------
  ForeColor = QBColor(12)
  CurrentY = 100: CurrentX = 0.435: Print "R = 0,4 mm"
  CurrentY = 100: CurrentX = 0.75: Print "0,8"
  CurrentY = 90: CurrentX = 0.75: Print "1,2"
  CurrentY = 84: CurrentX = 0.75: Print "1,6"
  CurrentY = 79: CurrentX = 0.75: Print "2,0"
  CurrentY = 65: CurrentX = 0.75: Print "4,0"
  CurrentY = 55: CurrentX = 0.75: Print "6,35"
  CurrentY = 40: CurrentX = 0.75: Print "12,7"
  CurrentY = 100: CurrentX = 0.75: Print "0,8"
  Form1.ForeColor = QBColor(13)
  CurrentY = 100: CurrentX = 0: Print "  Rauhtiefen in My"
  CurrentY = -15: CurrentX = 0.65: Print "Vorschub f in mm"
  CurrentY = -11: CurrentX = -0.15: Print "   Ra               Rt"
  Form1.ForeColor = QBColor(0)
  
  '*)-------------- Achse unten beschriften ----------------------
  For i = 0.05 To 0.85 Step 0.05
    CurrentY = -11:   Print i - 0.05; "  ";
  Next
  
  '*)-------------- Achsen senkr. beschriften --------------
  CurrentY = 100: CurrentX = -0.15: Print "  25               100"
  CurrentY = 90: CurrentX = -0.15: Print "  14,2              60"
  CurrentY = 81: CurrentX = -0.15: Print "   9,25             40"
  CurrentY = 72: CurrentX = -0.15: Print "   5,5               25"
  CurrentY = 60: CurrentX = -0.15: Print "   2,9               15"
  CurrentY = 51: CurrentX = -0.15: Print "   2                  10"
  CurrentY = 44: CurrentX = -0.15: Print "   1,33               7"
  CurrentY = 36: CurrentX = -0.15: Print "   0,93               5"
  CurrentY = 25: CurrentX = -0.15: Print "   0,53               3"
  CurrentY = 16: CurrentX = -0.15: Print "   0,34               2"
  CurrentY = 2: CurrentX = -0.15: Print "   0,16               1"
  CurrentY = -6: CurrentX = -0.15: Print "   0,09              0,6"
End Sub
