/* @(#)hprof_class.h	1.2 98/08/25
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#ifndef _HPROF_CLASS_H
#define _HPROF_CLASS_H

#include "hprof_hash.h"

/* Methods */
typedef struct hprof_method_t {
    jmethodID method_id;                      /* id from JVM,  -1 on class unload */
    struct hprof_class_t *class;              /* class to which this method belongs */
    struct hprof_name_t *method_name;         /* name of method */
    struct hprof_name_t *method_signature;    /* signature of method */
} hprof_method_t;

/* Fields */
typedef struct {
    struct hprof_name_t *name;                /* name of the field */
    jint type;                                /* type */
} hprof_field_t;

/* Classes */
typedef struct hprof_class_t {
    struct hprof_objmap_t *class_id;   /* ptr to jvm<--->hprof object map, 
					  -1 on unload */
    struct hprof_class_t *super;       /* super class */
    unsigned int serial_num;           /* unique serial number */
    struct hprof_name_t *name;         /* class name */
    struct hprof_name_t *src_name;     /* id of src file name */
    int num_interfaces;                /* number of interfaces */
    int num_statics;                   /* number of static fields */
    hprof_field_t *statics;            /* statics */
    int num_instances;                 /* number of instances */
    hprof_field_t *instances;          /* instances */
    int num_methods;                   /* number of methods */
    hprof_method_t **methods;          /* methods */
} hprof_class_t;

extern hprof_class_t *java_lang_object_class;

void hprof_class_table_init(void);
hprof_class_t * hprof_lookup_class_objmap(struct hprof_objmap_t *objmap);
hprof_class_t * hprof_lookup_class(jobjectID class_id);
void hprof_class_load_event(JNIEnv *env_id, 
			    char* name,
			    char* src_name,
			    int num_interfaces,
			    int num_statics,
			    JVMPI_Field *statics,
			    int num_instances,
			    JVMPI_Field *instances,
			    int num_methods,
			    JVMPI_Method *methods,
			    jobjectID class_id,
			    int requested);
void hprof_class_unload_event(JNIEnv *env_id, jobjectID class_id);
void hprof_superclass_link(jobjectID class_id, jobjectID super_id);

#endif /* _HPROF_CLASS_H */
