/*
 * @(#)hprof_hash.h	1.1 98/08/14
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#ifndef _HPROF_HASH_H
#define _HPROF_HASH_H

/* Generic support for hash tables */

typedef struct hprof_bucket_t {
    struct hprof_bucket_t *next;
    void *content;
} hprof_bucket_t;

typedef struct {
    unsigned int n_entries;            /* total buckets in the table */
    unsigned int size;                 /* size of the top-level table */
    hprof_bucket_t **entries;
    unsigned int (*hash_f)(void *);    /* hash function */
    unsigned int (*size_f)(void *);    /* content size */
    int (*compare_f)(void *, void *);  /* comparison function */
} hprof_hash_t;

void hprof_hash_init(hprof_hash_t *table, 
		     int size,
		     unsigned int (*hash_f)(void *),
		     unsigned int (*size_f)(void *),
		     int (*compare_f)(void *, void *));
void * hprof_hash_iterate(hprof_hash_t *table,
			  void * (*f)(void *, void *),
			  void *arg);
void hprof_hash_remove(hprof_hash_t *table,
		       int (*f)(void *, void *),
		       void *arg);
void hprof_hash_removeall(hprof_hash_t *table);
void * hprof_hash_lookup(hprof_hash_t *table, void *new);
void * hprof_hash_put(hprof_hash_t *table, void *new);
void * hprof_hash_intern(hprof_hash_t *table, void *new);

#endif /* _HPROF_HASH_H */
