/*
 * @(#)hprof_monitor.h	1.2 98/08/18
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#ifndef _HPROF_MONITOR_H
#define _HPROF_MONITOR_H

#include "hprof_name.h"

void hprof_raw_monitor_table_init(void);
void hprof_contended_monitor_table_init(void);
void hprof_clear_contended_monitor_table(void);
void hprof_raw_monitor_event(JVMPI_Event *event,
			     char *name,
			     JVMPI_RawMonitor mid);
void hprof_monitor_event(JVMPI_Event *event, jobjectID obj);
void hprof_monitor_wait_event(JVMPI_Event *event, jobjectID obj,
			      jlong timeout);
void hprof_dump_monitors(void);
void hprof_monitor_dump_event(JVMPI_Event *event);
void hprof_output_cmon_times(float cutoff);

typedef struct {
    hprof_name_t *name;
    JVMPI_RawMonitor id;
} hprof_raw_monitor_t;

typedef struct {
    jint type;                        /* Java or Raw? */
    void *mon_info;                   /* (hprof_objmap_t *) or
					 (hprof_raw_monitor_t *) */
    unsigned int trace_serial_num;    /* trace where contention occured */
    jlong time;                       /* time associated with the contention */
    jint num_hits;                    /* # of times this monitor is contended 
					 at this trace */
} hprof_contended_monitor_t;

/* Auxilary data structure used for collecting contended monitor info. */
typedef struct {
    hprof_contended_monitor_t **cmons;               
    int index;
    jlong total_time;
} hprof_cmon_iterate_t;

#endif /* _HPROF_MONITOR_H */
