// Pult.java

import java.io.*;

interface Methode {
    void fuehreAus(Getriebe g);
}

class Pult {
    private Getriebe g;
    private String[] anzeige =  { 
     "0.  Ausschalten", "1.  Hochschalten", "2.  Herunterschalten", "3.  Leerlauf"
    };
    private Methode[] aktion = {
        new Aus(), new Hoch(), new Herunter(), new Leerlauf()
    };
    private BufferedReader in = new BufferedReader(
                                      new InputStreamReader(System.in));
    Pult(Getriebe g) throws IOException {
        this.g = g;
        schalte();
    }
    void schalte() throws IOException {
        int auswahl = 0;
        while ((auswahl = waehle()) != 0) 
            aktion[auswahl].fuehreAus(g);
    }
    int waehle() throws IOException {
        System.out.println("Gang: " + g.gang()); 
        for (int i = 0; i < anzeige.length; i++)
            System.out.println(anzeige[i]);
        System.out.print("\nAktion whlen: ");
        return Integer.parseInt(in.readLine());
    }
    public static void main(String[] args) throws IOException {
        new Pult(new Getriebe());
    }
}

class Hoch implements Methode {
    public void fuehreAus(Getriebe g) { g.hoch(); }
}

class Herunter implements Methode {
    public void fuehreAus(Getriebe g) { g.herunter(); }
}

class Leerlauf implements Methode {
    public void fuehreAus(Getriebe g) { g.leerlauf(); }
}

class Aus implements Methode {
    public void fuehreAus(Getriebe g) { }
}
