// ButtonEvents.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

class ButtonEvents extends JPanel {
    ButtonEvents() {
        final JButton b1 = new JButton("JButton");
        final JToggleButton b2 = new JToggleButton("JToggleButton");
        add(b1);
        add(b2);
        b1.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                System.out.println("JButton ActionEvent\n"
                   + "\tisEnabled: " + b1.isEnabled() + "\n"
                   + "\tisPressed: " + b1.getModel().isPressed() + "\n"
                   + "\tisRollover: " + b1.getModel().isRollover() + "\n"
                   + "\tisArmed: " + b1.getModel().isArmed() + "\n"
                   + "\tisSelected: " + b1.isSelected() + "\n");
            }
        });
        b2.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                System.out.println("JToggleButton ActionEvent\n"
                   + "\tisEnabled: " + b2.isEnabled() + "\n"
                   + "\tisPressed: " + b2.getModel().isPressed() + "\n"
                   + "\tisRollover: " + b2.getModel().isRollover() + "\n"
                   + "\tisArmed: " + b2.getModel().isArmed() + "\n"
                   + "\tisSelected: " + b2.isSelected() + "\n");
            }
        });
        b1.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                System.out.println("JButton ItemEvent\n"
                   + "\tisEnabled: " + b1.isEnabled() + "\n"
                   + "\tisPressed: " + b1.getModel().isPressed() + "\n"
                   + "\tisRollover: " + b1.getModel().isRollover() + "\n"
                   + "\tisArmed: " + b1.getModel().isArmed() + "\n"
                   + "\tisSelected: " + b1.isSelected() + "\n");
            }
        });
        b2.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                System.out.println("JToggleButton ItemEvent\n"
                   + "\tisEnabled: " + b2.isEnabled() + "\n"
                   + "\tisPressed: " + b2.getModel().isPressed() + "\n"
                   + "\tisRollover: " + b2.getModel().isRollover() + "\n"
                   + "\tisArmed: " + b2.getModel().isArmed() + "\n"
                   + "\tisSelected: " + b2.isSelected() + "\n");
            }
        });
        b1.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                System.out.println("JButton ChangeEvent\n"
                   + "\tisEnabled: " + b1.isEnabled() + "\n"
                   + "\tisPressed: " + b1.getModel().isPressed() + "\n"
                   + "\tisRollover: " + b1.getModel().isRollover() + "\n"
                   + "\tisArmed: " + b1.getModel().isArmed() + "\n"
                   + "\tisSelected: " + b1.isSelected() + "\n");
            }
        });
        b2.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                System.out.println("JToggleButton ChangeEvent\n"
                   + "\tisEnabled: " + b2.isEnabled() + "\n"
                   + "\tisPressed: " + b2.getModel().isPressed() + "\n"
                   + "\tisRollover: " + b2.getModel().isRollover() + "\n"
                   + "\tisArmed: " + b2.getModel().isArmed() + "\n"
                   + "\tisSelected: " + b2.isSelected() + "\n");
            }
        });
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("ButtonEvent-Test");
        f.getContentPane().add(new ButtonEvents());
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
