// CardTest.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class CardTest {
    public static void main(String[] args) {
        JFrame f = new JFrame("Card-Test");
        Container cont = f.getContentPane();
        JButton l = new JButton(new ImageIcon(CardTest.class.getResource("icons/left.gif"))),
            r = new JButton(new ImageIcon(CardTest.class.getResource("icons/right.gif")));
        final CardLayout layout = new CardLayout();
        final JPanel pan = new JPanel();
        pan.setLayout(layout);
        String[] texte = {
            "Blau", "Grn", "Orange", "Rot", "Gelb"
        };
        for (int i = 0; i < texte.length; i++)
            pan.add(new JButton(texte[i]), texte[i]);
        l.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                layout.previous(pan);
            }
        });
        r.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                layout.next(pan);
            }
        });
        cont.add(l, BorderLayout.WEST); 
        cont.add(r, BorderLayout.EAST);
        cont.add(pan, BorderLayout.CENTER);
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
