// ComboEvents.java

import java.awt.event.*;
import javax.swing.*;

class ComboEvents extends JPanel {
    ComboEvents() {
        String[] os =  { 
            "HP-UX", "JavaOS", "Linux", "MacOS", "MVS", 
            "OS390", "Solaris", "Windows 2000", "Windows XP" 
        };
        final JComboBox com = new JComboBox(os);
        add(com);
        com.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                System.out.println("JComboBox ActionEvent: " + e.getActionCommand());
            }
        });
        com.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == ItemEvent.SELECTED)
                    System.out.println("JComboBox ItemEvent: " + com.getSelectedItem()
                        + " selektiert");
            }
        });
     }
    public static void main(String[] args) {
        JFrame f = new JFrame("ComboEvent-Test");
        f.getContentPane().add(new ComboEvents());
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
