// DialogTest.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class DialogTest extends JDialog {
    DialogTest(JFrame f) {
        super(f, "Rckfrage", true);
        Container c = getContentPane();
        c.setLayout(new FlowLayout());
        c.add(new JLabel("Anwendung wirklich beenden?"));
        JButton ja = new JButton("Ja"), 
            nein = new JButton("Nein");
        c.add(ja); 
        c.add(nein);
        ActionListener lis = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Ja"))
                    getOwner().dispose();
		else 
                    dispose();
            }
        };
        ja.addActionListener(lis); 
        nein.addActionListener(lis);
    }
    public static void main(String[] args) {
        final JFrame f = new JFrame("Dialog-Test");
        f.getContentPane().add(new JLabel("Schlieen Sie dieses Fenster."));
        f.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                JDialog diag = new DialogTest(f);
                diag.pack();
		diag.setLocationRelativeTo(f);
		diag.setLocation(diag.getX()+10, diag.getY()+70);
                diag.setVisible(true);
            }
        });
        f.pack();
        f.setVisible(true);
    }
}
