// FontWahl.java

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

class FontWahl extends JPanel {
    FontWahl() {
        setLayout(new GridLayout(2, 1));
        final JLabel text = new JLabel("Java-Fonts");
        final JSlider slider = new JSlider(JSlider.HORIZONTAL, 0, 100, 12);
        add(text);
        add(slider);
        slider.setPaintLabels(true);
        slider.setMajorTickSpacing(10);
        slider.setMinorTickSpacing(5);
        slider.setPaintTicks(true);
        slider.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent ev) {
                text.setFont(new Font(text.getFont().getFamily(), 
                    Font.PLAIN, slider.getValue()));
            }
        });
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Font-Wahl");
        f.getContentPane().add(new FontWahl());
        f.setSize(400, 200);
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
