// LabelList.java

import java.awt.*;
import javax.swing.*;

class LabelList extends JPanel {
    private JList l; 
    private DefaultListModel model;
    private int anz = 25;
    LabelList() {
        l = new JList(model = new DefaultListModel());
        for (int i = 0; i < anz; i++)
            model.add(model.size(), "Tier " + i);
        JScrollPane span = new JScrollPane(l);
        l.setCellRenderer(new ListCellRenderer() {
            public Component getListCellRendererComponent(JList list, Object value,
                    int index, boolean isSelected, boolean hasFocus) {
                JLabel lab = new JLabel();
                lab.setIcon(new ImageIcon(LabelList.class.getResource("icons/tier" + index + ".gif")));
                lab.setText(" Tier " + index);
                lab.setBorder(BorderFactory.createLineBorder(Color.blue, 3));
                lab.setPreferredSize(new Dimension(275, 80));
                if (isSelected) {
                    lab.setBackground(Color.cyan);
                    lab.setForeground(Color.red);
                } else {
                    lab.setBackground(Color.white);
                    lab.setForeground(Color.black);
                }
                return lab;
            }
        });
        add(span);
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Listen-Renderer");
        f.getContentPane().add(new LabelList());
        f.setSize(300, 750);
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    } 
}
