// LayoutTest.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class LayoutTest extends JPanel {
    LayoutTest() {
        setLayout(new BorderLayout());
        final JTextArea text1 = new JTextArea(5, 30),
            text2 = new JTextArea(5, 30);
        text1.setLineWrap(true);
        text2.setLineWrap(true);
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        JButton cut = erzeugeButton(b, "cut.gif", "Cut"),
            copy = erzeugeButton(b, "copy.gif", "Copy"), 
	    paste = erzeugeButton(b, "paste.gif", "Paste");
        b.add(Box.createHorizontalGlue());
        add(text1, BorderLayout.NORTH);
        add(b, BorderLayout.CENTER);
        add(text2, BorderLayout.SOUTH);
        cut.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                text1.cut();
            }
        });
        copy.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                text1.copy();
            }
        });
        paste.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                text2.paste();
            }
        });
    }
    protected JButton erzeugeButton(JComponent c, String icon, String toolTip) {
	JButton but = new JButton(new ImageIcon(
                        LayoutTest.class.getResource("icons/" + icon)));
	but.setToolTipText(toolTip);
	c.add(but);
	return but;
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Layout-Test");
        f.getContentPane().add(new LayoutTest());
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
