// ListModifikation.java

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

class ListModifikation extends JPanel {
    ListModifikation() {
        String[] os = { "HP-UX", "JavaOS", "Linux", "MacOS", "MVS", 
			"OS390", "Solaris", "Windows 2000", "Windows XP" };
        final DefaultListModel lModel = new DefaultListModel(),
            rModel = new DefaultListModel();
        for (int i = 0; i < os.length; i++)
            lModel.add(0, os[i]);
        final JList lList = new JList(lModel), rList = new JList(rModel);
        lList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	setLayout(new GridLayout(1,2));
        add(lList);
        add(rList);
        lList.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                if (! lList.isSelectionEmpty()) {
                    int i = lList.getMinSelectionIndex();
                    Object obj = lModel.remove(i);
                    rModel.add(0, obj);
                }
            }
        });
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Listen-Modifikation");
        f.getContentPane().add(new ListModifikation());
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
