// MenueTest.java

import javax.swing.*;

class MenueTest {
    protected static void erzeugeMenuItem(JComponent c, String text, 
					  String icon) {
	JMenuItem it = new JMenuItem(text);
	if (icon != null)
	    it.setIcon(new ImageIcon(
                         MenueTest.class.getResource("icons/" + icon)));
	c.add(it);
    }
    public static void main(String[] args) {
        JMenuBar mbar = new JMenuBar();
        JMenu edit = new JMenu("Edit"), opt = new JMenu("Einstellungen"),
            all = new JMenu("Allgemeine Einstellungen");
        erzeugeMenuItem(edit, "Ausschneiden", "cut.gif");
	erzeugeMenuItem(edit, "Kopieren", "copy.gif");
	erzeugeMenuItem(edit, "Einfgen", "paste.gif");
	erzeugeMenuItem(all, "Hilfe bei erweiterten Befehlen", null);
	erzeugeMenuItem(all, "Debuggen bei Fehler", null);
	opt.add(new JCheckBoxMenuItem("Read only"));
        opt.add(all); 
        opt.addSeparator(); 
	erzeugeMenuItem(opt, "Einstellungen sichern", null);
        mbar.add(edit); 
        mbar.add(opt);
        JFrame f = new JFrame("Men-Test");
        f.setSize(300, 200);
        f.setJMenuBar(mbar);
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
