// MouseTest.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class MouseTest extends JPanel {
    MouseTest() {
        final JLabel lab = new JLabel("Einfacher Text");
        final Icon ic = new ImageIcon(
                          MouseTest.class.getResource("icons/smile.gif"));
        lab.addMouseListener(new MouseAdapter() {
            public void mouseEntered(MouseEvent e) {
                lab.setIcon(ic);
            }
            public void mouseExited(MouseEvent e) {
                lab.setIcon(null);
            }
        });
        add(lab);
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Mouse-Test");
        f.getContentPane().add(new MouseTest());
        f.setSize(200, 80);
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
