// MultiViewer.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class MultiViewer extends JPanel {
    JDesktopPane desk;
    MultiViewer() {
        setLayout(new BorderLayout());
        Box toolbar = Box.createHorizontalBox();
        JButton[] but = { 
            new JButton("LayoutTest"), 
            new JButton("RadioTest"),
            new JButton("ButtonTest"),
            new JButton("ListTest"),
        };
        ActionListener lis = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                String str = e.getActionCommand();
                JInternalFrame fr = new JInternalFrame(str, true, true, true, true);
                JPanel pan = null;
                try {
                    Class c = Class.forName(str);
                    pan = (JPanel)c.newInstance();
                } catch (Exception ign) { }
                if (pan != null) {
                    fr.getContentPane().add(pan);
                    fr.pack();
                    fr.setVisible(true);
                    desk.add(fr);
                }
            }
        };
        for (int i = 0; i < but.length; i++) {
            toolbar.add(but[i]); 
            but[i].addActionListener(lis);
        }
        add(toolbar, BorderLayout.NORTH);
        desk = new JDesktopPane();
        add(desk);
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("MultiViewer");
        f.getContentPane().add(new MultiViewer());
        f.setSize(640, 400);
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
