// OverlayTest.java

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

class OverlayTest extends JPanel {
    OverlayTest() {
        String[] n = { "bluerose.gif", "redballs.gif", "greenribbon.gif" };
        final JList list = new JList(n);
	final Anzeige anzeige = new Anzeige(n);
	setLayout(new BorderLayout());
        add(list, BorderLayout.WEST);
        add(anzeige, BorderLayout.CENTER);
        list.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                for (int i = 0; i < anzeige.icons.length; i++)
                    anzeige.icons[i].setVisible(list.isSelectedIndex(i)); 
            }
        });
    }
    static class Anzeige extends JPanel {
	JLabel[] icons;
        public Anzeige(String[] namen) {
	    setLayout(new OverlayLayout(this));
	    icons = new JLabel[namen.length];
	    for (int i = 0; i < icons.length; i++) {
		icons[i] = new JLabel(new ImageIcon(OverlayTest.class.getResource("icons/" + namen[i])));
		icons[i].setOpaque(false);
		icons[i].setVisible(false);
		add(icons[i]);
	    }
	}
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Overlay-Test");
        f.getContentPane().add(new OverlayTest());
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
